/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.util;

import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.util.ObjectMap;

public class IdentityObjectIntMap<K> {
    public int size;
    K[] keyTable;
    int[] valueTable;
    int capacity;
    int stashSize;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private boolean isBigTable;

    public IdentityObjectIntMap() {
        this(32, 0.8f);
    }

    public IdentityObjectIntMap(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n2);
        }
        if (this.capacity > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n2);
        }
        this.capacity = ObjectMap.nextPowerOfTwo(n2);
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f2);
        }
        this.loadFactor = f2;
        this.isBigTable = this.capacity >>> 16 != 0;
        this.threshold = (int)((float)this.capacity * f2);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new Object[this.capacity + this.stashCapacity];
        this.valueTable = new int[this.keyTable.length];
    }

    public void put(K k2, int n2) {
        int n3;
        if (k2 == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        K[] KArray = this.keyTable;
        int n4 = this.mask;
        boolean bl2 = this.isBigTable;
        int n5 = System.identityHashCode(k2);
        int n6 = n5 & n4;
        K k3 = KArray[n6];
        if (k2 == k3) {
            this.valueTable[n6] = n2;
            return;
        }
        int n7 = this.hash2(n5);
        K k4 = KArray[n7];
        if (k2 == k4) {
            this.valueTable[n7] = n2;
            return;
        }
        int n8 = this.hash3(n5);
        K k5 = KArray[n8];
        if (k2 == k5) {
            this.valueTable[n8] = n2;
            return;
        }
        int n9 = -1;
        K k6 = null;
        if (bl2 && k2 == (k6 = (K)KArray[n9 = this.hash4(n5)])) {
            this.valueTable[n9] = n2;
            return;
        }
        int n10 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n10; ++n3) {
            if (KArray[n3] != k2) continue;
            this.valueTable[n3] = n2;
            return;
        }
        if (k3 == null) {
            KArray[n6] = k2;
            this.valueTable[n6] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (k4 == null) {
            KArray[n7] = k2;
            this.valueTable[n7] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (k5 == null) {
            KArray[n8] = k2;
            this.valueTable[n8] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (bl2 && k6 == null) {
            KArray[n9] = k2;
            this.valueTable[n9] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(k2, n2, n6, k3, n7, k4, n8, k5, n9, k6);
    }

    private void putResize(K k2, int n2) {
        int n3 = System.identityHashCode(k2);
        int n4 = n3 & this.mask;
        K k3 = this.keyTable[n4];
        if (k3 == null) {
            this.keyTable[n4] = k2;
            this.valueTable[n4] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n5 = this.hash2(n3);
        K k4 = this.keyTable[n5];
        if (k4 == null) {
            this.keyTable[n5] = k2;
            this.valueTable[n5] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n6 = this.hash3(n3);
        K k5 = this.keyTable[n6];
        if (k5 == null) {
            this.keyTable[n6] = k2;
            this.valueTable[n6] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n7 = -1;
        K k6 = null;
        if (this.isBigTable && (k6 = (K)this.keyTable[n7 = this.hash4(n3)]) == null) {
            this.keyTable[n7] = k2;
            this.valueTable[n7] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(k2, n2, n4, k3, n5, k4, n6, k5, n7, k6);
    }

    private void push(K k2, int n2, int n3, K k3, int n4, K k4, int n5, K k5, int n6, K k6) {
        int n7;
        K k7;
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n8 = this.mask;
        boolean bl2 = this.isBigTable;
        int n9 = 0;
        int n10 = this.pushIterations;
        int n11 = bl2 ? 4 : 3;
        while (true) {
            switch (ObjectMap.random.nextInt(n11)) {
                case 0: {
                    k7 = k3;
                    n7 = nArray[n3];
                    KArray[n3] = k2;
                    nArray[n3] = n2;
                    break;
                }
                case 1: {
                    k7 = k4;
                    n7 = nArray[n4];
                    KArray[n4] = k2;
                    nArray[n4] = n2;
                    break;
                }
                case 2: {
                    k7 = k5;
                    n7 = nArray[n5];
                    KArray[n5] = k2;
                    nArray[n5] = n2;
                    break;
                }
                default: {
                    k7 = k6;
                    n7 = nArray[n6];
                    KArray[n6] = k2;
                    nArray[n6] = n2;
                }
            }
            int n12 = System.identityHashCode(k7);
            n3 = n12 & n8;
            k3 = KArray[n3];
            if (k3 == null) {
                KArray[n3] = k7;
                nArray[n3] = n7;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n4 = this.hash2(n12);
            k4 = KArray[n4];
            if (k4 == null) {
                KArray[n4] = k7;
                nArray[n4] = n7;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n5 = this.hash3(n12);
            k5 = KArray[n5];
            if (k5 == null) {
                KArray[n5] = k7;
                nArray[n5] = n7;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (bl2 && (k6 = KArray[n6 = this.hash4(n12)]) == null) {
                KArray[n6] = k7;
                nArray[n6] = n7;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n9 == n10) break;
            k2 = k7;
            n2 = n7;
        }
        this.putStash(k7, n7);
    }

    private void putStash(K k2, int n2) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put(k2, n2);
            return;
        }
        int n3 = this.capacity + this.stashSize;
        this.keyTable[n3] = k2;
        this.valueTable[n3] = n2;
        ++this.stashSize;
        ++this.size;
    }

    public int get(K k2, int n2) {
        int n3 = System.identityHashCode(k2);
        int n4 = n3 & this.mask;
        if (k2 != this.keyTable[n4] && k2 != this.keyTable[n4 = this.hash2(n3)] && k2 != this.keyTable[n4 = this.hash3(n3)]) {
            if (this.isBigTable) {
                n4 = this.hash4(n3);
                if (k2 != this.keyTable[n4]) {
                    return this.getStash(k2, n2);
                }
            } else {
                return this.getStash(k2, n2);
            }
        }
        return this.valueTable[n4];
    }

    private int getStash(K k2, int n2) {
        int n3;
        K[] KArray = this.keyTable;
        int n4 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n4; ++n3) {
            if (k2 != KArray[n3]) continue;
            return this.valueTable[n3];
        }
        return n2;
    }

    public void clear(int n2) {
        if (this.capacity <= n2) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n2);
    }

    public void clear() {
        K[] KArray = this.keyTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            KArray[n2] = null;
        }
        this.size = 0;
        this.stashSize = 0;
    }

    private void resize(int n2) {
        int n3 = this.capacity + this.stashSize;
        this.capacity = n2;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n2);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n2)) * 2);
        this.pushIterations = Math.max(Math.min(n2, 8), (int)Math.sqrt(n2) / 8);
        this.isBigTable = this.capacity >>> 16 != 0;
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        this.keyTable = new Object[n2 + this.stashCapacity];
        this.valueTable = new int[n2 + this.stashCapacity];
        int n4 = this.size;
        this.size = 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                K k2 = KArray[i2];
                if (k2 == null) continue;
                this.putResize(k2, nArray[i2]);
            }
        }
    }

    private int hash2(int n2) {
        return ((n2 *= -1105259343) ^ n2 >>> this.hashShift) & this.mask;
    }

    private int hash3(int n2) {
        return ((n2 *= -1262997959) ^ n2 >>> this.hashShift) & this.mask;
    }

    private int hash4(int n2) {
        return ((n2 *= -825114047) ^ n2 >>> this.hashShift) & this.mask;
    }

    public String toString() {
        K k2;
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n2 = KArray.length;
        while (n2-- > 0) {
            k2 = KArray[n2];
            if (k2 == null) continue;
            stringBuilder.append(k2);
            stringBuilder.append('=');
            stringBuilder.append(nArray[n2]);
            break;
        }
        while (n2-- > 0) {
            k2 = KArray[n2];
            if (k2 == null) continue;
            stringBuilder.append(", ");
            stringBuilder.append(k2);
            stringBuilder.append('=');
            stringBuilder.append(nArray[n2]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

