/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.BufferRecycler;
import java.io.OutputStream;
import java.util.LinkedList;

public final class ByteArrayBuilder
extends OutputStream {
    public static final byte[] NO_BYTES = new byte[0];
    private final BufferRecycler _bufferRecycler;
    private final LinkedList<byte[]> _pastBlocks = new LinkedList();
    private int _pastLen;
    private byte[] _currBlock;
    private int _currBlockPtr;

    public ByteArrayBuilder() {
        this(null);
    }

    public ByteArrayBuilder(BufferRecycler bufferRecycler) {
        this(bufferRecycler, 500);
    }

    public ByteArrayBuilder(int n2) {
        this(null, n2);
    }

    public ByteArrayBuilder(BufferRecycler bufferRecycler, int n2) {
        this._bufferRecycler = bufferRecycler;
        if (n2 > 131072) {
            n2 = 131072;
        }
        this._currBlock = bufferRecycler == null ? new byte[n2] : bufferRecycler.allocByteBuffer(2);
    }

    private ByteArrayBuilder(BufferRecycler bufferRecycler, byte[] byArray, int n2) {
        this._bufferRecycler = null;
        this._currBlock = byArray;
        this._currBlockPtr = n2;
    }

    public static ByteArrayBuilder fromInitial(byte[] byArray, int n2) {
        return new ByteArrayBuilder(null, byArray, n2);
    }

    public void reset() {
        this._pastLen = 0;
        this._currBlockPtr = 0;
        if (!this._pastBlocks.isEmpty()) {
            this._pastBlocks.clear();
        }
    }

    public int size() {
        return this._pastLen + this._currBlockPtr;
    }

    public void append(int n2) {
        if (this._currBlockPtr >= this._currBlock.length) {
            this._allocMore();
        }
        this._currBlock[this._currBlockPtr++] = (byte)n2;
    }

    public void appendTwoBytes(int n2) {
        if (this._currBlockPtr + 1 < this._currBlock.length) {
            this._currBlock[this._currBlockPtr++] = (byte)(n2 >> 8);
            this._currBlock[this._currBlockPtr++] = (byte)n2;
        } else {
            this.append(n2 >> 8);
            this.append(n2);
        }
    }

    public void appendThreeBytes(int n2) {
        if (this._currBlockPtr + 2 < this._currBlock.length) {
            this._currBlock[this._currBlockPtr++] = (byte)(n2 >> 16);
            this._currBlock[this._currBlockPtr++] = (byte)(n2 >> 8);
            this._currBlock[this._currBlockPtr++] = (byte)n2;
        } else {
            this.append(n2 >> 16);
            this.append(n2 >> 8);
            this.append(n2);
        }
    }

    public byte[] toByteArray() {
        int n2 = this._pastLen + this._currBlockPtr;
        if (n2 == 0) {
            return NO_BYTES;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (byte[] byArray2 : this._pastBlocks) {
            int n4 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n3, n4);
            n3 += n4;
        }
        System.arraycopy(this._currBlock, 0, byArray, n3, this._currBlockPtr);
        if ((n3 += this._currBlockPtr) != n2) {
            throw new RuntimeException("Internal error: total len assumed to be " + n2 + ", copied " + n3 + " bytes");
        }
        if (!this._pastBlocks.isEmpty()) {
            this.reset();
        }
        return byArray;
    }

    public byte[] finishCurrentSegment() {
        this._allocMore();
        return this._currBlock;
    }

    public byte[] completeAndCoalesce(int n2) {
        this._currBlockPtr = n2;
        return this.toByteArray();
    }

    public byte[] getCurrentSegment() {
        return this._currBlock;
    }

    public void setCurrentSegmentLength(int n2) {
        this._currBlockPtr = n2;
    }

    public int getCurrentSegmentLength() {
        return this._currBlockPtr;
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        while (true) {
            int n4;
            int n5;
            if ((n5 = Math.min(n4 = this._currBlock.length - this._currBlockPtr, n3)) > 0) {
                System.arraycopy(byArray, n2, this._currBlock, this._currBlockPtr, n5);
                n2 += n5;
                this._currBlockPtr += n5;
                n3 -= n5;
            }
            if (n3 <= 0) break;
            this._allocMore();
        }
    }

    @Override
    public void write(int n2) {
        this.append(n2);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    private void _allocMore() {
        int n2 = this._pastLen + this._currBlock.length;
        if (n2 < 0) {
            throw new IllegalStateException("Maximum Java array size (2GB) exceeded by `ByteArrayBuilder`");
        }
        this._pastLen = n2;
        int n3 = Math.max(this._pastLen >> 1, 1000);
        if (n3 > 131072) {
            n3 = 131072;
        }
        this._pastBlocks.add(this._currBlock);
        this._currBlock = new byte[n3];
        this._currBlockPtr = 0;
    }
}

