/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.StreamReadCapability;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.JsonNodeFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.node.ArrayNode;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.node.ContainerNode;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.node.ObjectNode;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.RawValue;
import java.io.IOException;
import java.util.Arrays;

abstract class BaseNodeDeserializer<T extends JsonNode>
extends StdDeserializer<T>
implements ContextualDeserializer {
    protected final Boolean _supportsUpdates;
    protected final boolean _mergeArrays;
    protected final boolean _mergeObjects;

    public BaseNodeDeserializer(Class<T> clazz, Boolean bl2) {
        super(clazz);
        this._supportsUpdates = bl2;
        this._mergeArrays = true;
        this._mergeObjects = true;
    }

    protected BaseNodeDeserializer(BaseNodeDeserializer<?> baseNodeDeserializer, boolean bl2, boolean bl3) {
        super(baseNodeDeserializer);
        this._supportsUpdates = baseNodeDeserializer._supportsUpdates;
        this._mergeArrays = bl2;
        this._mergeObjects = bl3;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Untyped;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return this._supportsUpdates;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        Boolean bl2 = deserializationConfig.getDefaultMergeable(ArrayNode.class);
        Boolean bl3 = deserializationConfig.getDefaultMergeable(ObjectNode.class);
        Boolean bl4 = deserializationConfig.getDefaultMergeable(JsonNode.class);
        boolean bl5 = BaseNodeDeserializer._shouldMerge(bl2, bl4);
        boolean bl6 = BaseNodeDeserializer._shouldMerge(bl3, bl4);
        if (bl5 != this._mergeArrays || bl6 != this._mergeObjects) {
            return this._createWithMerge(bl5, bl6);
        }
        return this;
    }

    private static boolean _shouldMerge(Boolean bl2, Boolean bl3) {
        if (bl2 != null) {
            return bl2;
        }
        if (bl3 != null) {
            return bl3;
        }
        return true;
    }

    protected abstract JsonDeserializer<?> _createWithMerge(boolean var1, boolean var2);

    protected void _handleDuplicateField(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory, String string, ObjectNode objectNode, JsonNode jsonNode, JsonNode jsonNode2) throws IOException {
        if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY)) {
            deserializationContext.reportInputMismatch(JsonNode.class, "Duplicate field '%s' for `ObjectNode`: not allowed when `DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY` enabled", string);
        }
        if (deserializationContext.isEnabled(StreamReadCapability.DUPLICATE_PROPERTIES)) {
            if (jsonNode.isArray()) {
                ((ArrayNode)jsonNode).add(jsonNode2);
                objectNode.replace(string, jsonNode);
            } else {
                ArrayNode arrayNode = jsonNodeFactory.arrayNode();
                arrayNode.add(jsonNode);
                arrayNode.add(jsonNode2);
                objectNode.replace(string, arrayNode);
            }
        }
    }

    protected final ObjectNode _deserializeObjectAtName(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory, ContainerStack containerStack) throws IOException {
        ObjectNode objectNode = jsonNodeFactory.objectNode();
        String string = jsonParser.currentName();
        while (string != null) {
            ContainerNode<ContainerNode> containerNode;
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == null) {
                jsonToken = JsonToken.NOT_AVAILABLE;
            }
            switch (jsonToken.id()) {
                case 1: {
                    containerNode = this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, containerStack, jsonNodeFactory.objectNode());
                    break;
                }
                case 3: {
                    containerNode = this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, containerStack, jsonNodeFactory.arrayNode());
                    break;
                }
                default: {
                    containerNode = this._deserializeAnyScalar(jsonParser, deserializationContext);
                }
            }
            JsonNode jsonNode = objectNode.replace(string, containerNode);
            if (jsonNode != null) {
                this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, string, objectNode, jsonNode, containerNode);
            }
            string = jsonParser.nextFieldName();
        }
        return objectNode;
    }

    protected final JsonNode updateObject(JsonParser jsonParser, DeserializationContext deserializationContext, ObjectNode objectNode, ContainerStack containerStack) throws IOException {
        String string;
        if (jsonParser.isExpectedStartObjectToken()) {
            string = jsonParser.nextFieldName();
        } else {
            if (!jsonParser.hasToken(JsonToken.FIELD_NAME)) {
                return (JsonNode)this.deserialize(jsonParser, deserializationContext);
            }
            string = jsonParser.currentName();
        }
        JsonNodeFactory jsonNodeFactory = deserializationContext.getNodeFactory();
        while (string != null) {
            block18: {
                JsonNode jsonNode;
                JsonToken jsonToken;
                block16: {
                    JsonNode jsonNode2;
                    block17: {
                        jsonToken = jsonParser.nextToken();
                        jsonNode2 = objectNode.get(string);
                        if (jsonNode2 == null) break block16;
                        if (!(jsonNode2 instanceof ObjectNode)) break block17;
                        if (jsonToken != JsonToken.START_OBJECT || !this._mergeObjects) break block16;
                        jsonNode = this.updateObject(jsonParser, deserializationContext, (ObjectNode)jsonNode2, containerStack);
                        if (jsonNode != jsonNode2) {
                            objectNode.set(string, jsonNode);
                        }
                        break block18;
                    }
                    if (!(jsonNode2 instanceof ArrayNode) || jsonToken != JsonToken.START_ARRAY || !this._mergeArrays) break block16;
                    this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, containerStack, (ArrayNode)jsonNode2);
                    break block18;
                }
                if (jsonToken == null) {
                    jsonToken = JsonToken.NOT_AVAILABLE;
                }
                switch (jsonToken.id()) {
                    case 1: {
                        jsonNode = this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, containerStack, jsonNodeFactory.objectNode());
                        break;
                    }
                    case 3: {
                        jsonNode = this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, containerStack, jsonNodeFactory.arrayNode());
                        break;
                    }
                    case 6: {
                        jsonNode = jsonNodeFactory.textNode(jsonParser.getText());
                        break;
                    }
                    case 7: {
                        jsonNode = this._fromInt(jsonParser, deserializationContext, jsonNodeFactory);
                        break;
                    }
                    case 9: {
                        jsonNode = jsonNodeFactory.booleanNode(true);
                        break;
                    }
                    case 10: {
                        jsonNode = jsonNodeFactory.booleanNode(false);
                        break;
                    }
                    case 11: {
                        if (deserializationContext.isEnabled(JsonNodeFeature.READ_NULL_PROPERTIES)) {
                            jsonNode = jsonNodeFactory.nullNode();
                            break;
                        }
                        break block18;
                    }
                    default: {
                        jsonNode = this._deserializeRareScalar(jsonParser, deserializationContext);
                    }
                }
                objectNode.set(string, jsonNode);
            }
            string = jsonParser.nextFieldName();
        }
        return objectNode;
    }

    protected final ContainerNode<?> _deserializeContainerNoRecursion(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory, ContainerStack containerStack, ContainerNode<?> containerNode) throws IOException {
        ContainerNode containerNode2 = containerNode;
        int n2 = deserializationContext.getDeserializationFeatures() & F_MASK_INT_COERCIONS;
        block21: do {
            block32: {
                Object object;
                ContainerNode containerNode3;
                block30: {
                    if (!(containerNode2 instanceof ObjectNode)) break block30;
                    containerNode3 = (ObjectNode)containerNode2;
                    object = jsonParser.nextFieldName();
                    while (object != null) {
                        block31: {
                            JsonNode jsonNode;
                            JsonNode jsonNode2;
                            JsonToken jsonToken = jsonParser.nextToken();
                            if (jsonToken == null) {
                                jsonToken = JsonToken.NOT_AVAILABLE;
                            }
                            switch (jsonToken.id()) {
                                case 1: {
                                    jsonNode2 = jsonNodeFactory.objectNode();
                                    JsonNode jsonNode3 = ((ObjectNode)containerNode3).replace((String)object, jsonNode2);
                                    if (jsonNode3 != null) {
                                        this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, (String)object, (ObjectNode)containerNode3, jsonNode3, jsonNode2);
                                    }
                                    containerStack.push(containerNode2);
                                    containerNode2 = containerNode3 = jsonNode2;
                                    break block31;
                                }
                                case 3: {
                                    jsonNode2 = jsonNodeFactory.arrayNode();
                                    JsonNode jsonNode3 = ((ObjectNode)containerNode3).replace((String)object, jsonNode2);
                                    if (jsonNode3 != null) {
                                        this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, (String)object, (ObjectNode)containerNode3, jsonNode3, jsonNode2);
                                    }
                                    containerStack.push(containerNode2);
                                    containerNode2 = jsonNode2;
                                    continue block21;
                                }
                                case 6: {
                                    jsonNode = jsonNodeFactory.textNode(jsonParser.getText());
                                    break;
                                }
                                case 7: {
                                    jsonNode = this._fromInt(jsonParser, n2, jsonNodeFactory);
                                    break;
                                }
                                case 8: {
                                    jsonNode = this._fromFloat(jsonParser, deserializationContext, jsonNodeFactory);
                                    break;
                                }
                                case 9: {
                                    jsonNode = jsonNodeFactory.booleanNode(true);
                                    break;
                                }
                                case 10: {
                                    jsonNode = jsonNodeFactory.booleanNode(false);
                                    break;
                                }
                                case 11: {
                                    if (deserializationContext.isEnabled(JsonNodeFeature.READ_NULL_PROPERTIES)) {
                                        jsonNode = jsonNodeFactory.nullNode();
                                        break;
                                    }
                                    break block31;
                                }
                                default: {
                                    jsonNode = this._deserializeRareScalar(jsonParser, deserializationContext);
                                }
                            }
                            jsonNode2 = ((ObjectNode)containerNode3).replace((String)object, jsonNode);
                            if (jsonNode2 != null) {
                                this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, (String)object, (ObjectNode)containerNode3, jsonNode2, jsonNode);
                            }
                        }
                        object = jsonParser.nextFieldName();
                    }
                    break block32;
                }
                containerNode3 = (ArrayNode)containerNode2;
                block23: while (true) {
                    if ((object = jsonParser.nextToken()) == null) {
                        object = JsonToken.NOT_AVAILABLE;
                    }
                    switch (((JsonToken)((Object)object)).id()) {
                        case 1: {
                            containerStack.push(containerNode2);
                            containerNode2 = jsonNodeFactory.objectNode();
                            ((ArrayNode)containerNode3).add(containerNode2);
                            continue block21;
                        }
                        case 3: {
                            containerStack.push(containerNode2);
                            containerNode2 = jsonNodeFactory.arrayNode();
                            ((ArrayNode)containerNode3).add(containerNode2);
                            continue block21;
                        }
                        case 4: {
                            break block23;
                        }
                        case 6: {
                            ((ArrayNode)containerNode3).add(jsonNodeFactory.textNode(jsonParser.getText()));
                            continue block23;
                        }
                        case 7: {
                            ((ArrayNode)containerNode3).add(this._fromInt(jsonParser, n2, jsonNodeFactory));
                            continue block23;
                        }
                        case 8: {
                            ((ArrayNode)containerNode3).add(this._fromFloat(jsonParser, deserializationContext, jsonNodeFactory));
                            continue block23;
                        }
                        case 9: {
                            ((ArrayNode)containerNode3).add(jsonNodeFactory.booleanNode(true));
                            continue block23;
                        }
                        case 10: {
                            ((ArrayNode)containerNode3).add(jsonNodeFactory.booleanNode(false));
                            continue block23;
                        }
                        case 11: {
                            ((ArrayNode)containerNode3).add(jsonNodeFactory.nullNode());
                            continue block23;
                        }
                        default: {
                            ((ArrayNode)containerNode3).add(this._deserializeRareScalar(jsonParser, deserializationContext));
                            continue block23;
                        }
                    }
                    break;
                }
            }
            containerNode2 = containerStack.popOrNull();
        } while (containerNode2 != null);
        return containerNode;
    }

    protected final JsonNode _deserializeAnyScalar(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNodeFactory jsonNodeFactory = deserializationContext.getNodeFactory();
        switch (jsonParser.currentTokenId()) {
            case 2: {
                return jsonNodeFactory.objectNode();
            }
            case 6: {
                return jsonNodeFactory.textNode(jsonParser.getText());
            }
            case 7: {
                return this._fromInt(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case 8: {
                return this._fromFloat(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case 9: {
                return jsonNodeFactory.booleanNode(true);
            }
            case 10: {
                return jsonNodeFactory.booleanNode(false);
            }
            case 11: {
                return jsonNodeFactory.nullNode();
            }
            case 12: {
                return this._fromEmbedded(jsonParser, deserializationContext);
            }
        }
        return (JsonNode)deserializationContext.handleUnexpectedToken(this.handledType(), jsonParser);
    }

    protected final JsonNode _deserializeRareScalar(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.currentTokenId()) {
            case 2: {
                return deserializationContext.getNodeFactory().objectNode();
            }
            case 8: {
                return this._fromFloat(jsonParser, deserializationContext, deserializationContext.getNodeFactory());
            }
            case 12: {
                return this._fromEmbedded(jsonParser, deserializationContext);
            }
        }
        return (JsonNode)deserializationContext.handleUnexpectedToken(this.handledType(), jsonParser);
    }

    protected final JsonNode _fromInt(JsonParser jsonParser, int n2, JsonNodeFactory jsonNodeFactory) throws IOException {
        if (n2 != 0) {
            if (DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.enabledIn(n2)) {
                return jsonNodeFactory.numberNode(jsonParser.getBigIntegerValue());
            }
            return jsonNodeFactory.numberNode(jsonParser.getLongValue());
        }
        JsonParser.NumberType numberType = jsonParser.getNumberType();
        if (numberType == JsonParser.NumberType.INT) {
            return jsonNodeFactory.numberNode(jsonParser.getIntValue());
        }
        if (numberType == JsonParser.NumberType.LONG) {
            return jsonNodeFactory.numberNode(jsonParser.getLongValue());
        }
        return jsonNodeFactory.numberNode(jsonParser.getBigIntegerValue());
    }

    protected final JsonNode _fromInt(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException {
        int n2 = deserializationContext.getDeserializationFeatures();
        JsonParser.NumberType numberType = (n2 & F_MASK_INT_COERCIONS) != 0 ? (DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.enabledIn(n2) ? JsonParser.NumberType.BIG_INTEGER : (DeserializationFeature.USE_LONG_FOR_INTS.enabledIn(n2) ? JsonParser.NumberType.LONG : jsonParser.getNumberType())) : jsonParser.getNumberType();
        if (numberType == JsonParser.NumberType.INT) {
            return jsonNodeFactory.numberNode(jsonParser.getIntValue());
        }
        if (numberType == JsonParser.NumberType.LONG) {
            return jsonNodeFactory.numberNode(jsonParser.getLongValue());
        }
        return jsonNodeFactory.numberNode(jsonParser.getBigIntegerValue());
    }

    protected final JsonNode _fromFloat(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException {
        JsonParser.NumberType numberType = jsonParser.getNumberType();
        if (numberType == JsonParser.NumberType.BIG_DECIMAL) {
            return jsonNodeFactory.numberNode(jsonParser.getDecimalValue());
        }
        if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            if (jsonParser.isNaN()) {
                return jsonNodeFactory.numberNode(jsonParser.getDoubleValue());
            }
            return jsonNodeFactory.numberNode(jsonParser.getDecimalValue());
        }
        if (numberType == JsonParser.NumberType.FLOAT) {
            return jsonNodeFactory.numberNode(jsonParser.getFloatValue());
        }
        return jsonNodeFactory.numberNode(jsonParser.getDoubleValue());
    }

    protected final JsonNode _fromEmbedded(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNodeFactory jsonNodeFactory = deserializationContext.getNodeFactory();
        Object object = jsonParser.getEmbeddedObject();
        if (object == null) {
            return jsonNodeFactory.nullNode();
        }
        Class<?> clazz = object.getClass();
        if (clazz == byte[].class) {
            return jsonNodeFactory.binaryNode((byte[])object);
        }
        if (object instanceof RawValue) {
            return jsonNodeFactory.rawValueNode((RawValue)object);
        }
        if (object instanceof JsonNode) {
            return (JsonNode)object;
        }
        return jsonNodeFactory.pojoNode(object);
    }

    static final class ContainerStack {
        private ContainerNode[] _stack;
        private int _top;
        private int _end;

        public void push(ContainerNode containerNode) {
            if (this._top < this._end) {
                this._stack[this._top++] = containerNode;
                return;
            }
            if (this._stack == null) {
                this._end = 10;
                this._stack = new ContainerNode[this._end];
            } else {
                this._end += Math.min(4000, Math.max(20, this._end >> 1));
                this._stack = Arrays.copyOf(this._stack, this._end);
            }
            this._stack[this._top++] = containerNode;
        }

        public ContainerNode popOrNull() {
            if (this._top == 0) {
                return null;
            }
            return this._stack[--this._top];
        }
    }
}

