/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.impl;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DatabindContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;

public class MinimalClassNameIdResolver
extends ClassNameIdResolver {
    protected final String _basePackageName;
    protected final String _basePackagePrefix;

    protected MinimalClassNameIdResolver(JavaType javaType, TypeFactory typeFactory, PolymorphicTypeValidator polymorphicTypeValidator) {
        super(javaType, typeFactory, polymorphicTypeValidator);
        String string = javaType.getRawClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            this._basePackageName = "";
            this._basePackagePrefix = ".";
        } else {
            this._basePackagePrefix = string.substring(0, n2 + 1);
            this._basePackageName = string.substring(0, n2);
        }
    }

    public static MinimalClassNameIdResolver construct(JavaType javaType, MapperConfig<?> mapperConfig, PolymorphicTypeValidator polymorphicTypeValidator) {
        return new MinimalClassNameIdResolver(javaType, mapperConfig.getTypeFactory(), polymorphicTypeValidator);
    }

    @Override
    public String idFromValue(Object object) {
        String string = object.getClass().getName();
        if (string.startsWith(this._basePackagePrefix)) {
            return string.substring(this._basePackagePrefix.length() - 1);
        }
        return string;
    }

    @Override
    protected JavaType _typeFromId(String string, DatabindContext databindContext) throws IOException {
        if (string.startsWith(".")) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + this._basePackageName.length());
            if (this._basePackageName.isEmpty()) {
                stringBuilder.append(string.substring(1));
            } else {
                stringBuilder.append(this._basePackageName).append(string);
            }
            string = stringBuilder.toString();
        }
        return super._typeFromId(string, databindContext);
    }
}

