/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.node;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.type.WritableTypeId;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.node.ContainerNode;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArrayNode
extends ContainerNode<ArrayNode>
implements Serializable {
    private final List<JsonNode> _children = new ArrayList<JsonNode>();

    public ArrayNode(JsonNodeFactory jsonNodeFactory) {
        super(jsonNodeFactory);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider) {
        return this._children.isEmpty();
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.ARRAY;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.iterator();
    }

    public JsonNode get(int n2) {
        if (n2 >= 0 && n2 < this._children.size()) {
            return this._children.get(n2);
        }
        return null;
    }

    @Override
    public JsonNode get(String string) {
        return null;
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        List<JsonNode> list = this._children;
        int n2 = list.size();
        jsonGenerator.writeStartArray(this, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            JsonNode jsonNode = list.get(i2);
            jsonNode.serialize(jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(this, JsonToken.START_ARRAY));
        for (JsonNode jsonNode : this._children) {
            ((BaseJsonNode)jsonNode).serialize(jsonGenerator, serializerProvider);
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    public ArrayNode add(JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        this._add(jsonNode);
        return this;
    }

    public ArrayNode add(String string) {
        return this._add(string == null ? this.nullNode() : this.textNode(string));
    }

    public ArrayNode set(int n2, String string) {
        return this._set(n2, string == null ? this.nullNode() : this.textNode(string));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof ArrayNode) {
            return this._children.equals(((ArrayNode)object)._children);
        }
        return false;
    }

    public int hashCode() {
        return this._children.hashCode();
    }

    protected ArrayNode _set(int n2, JsonNode jsonNode) {
        if (n2 < 0 || n2 >= this._children.size()) {
            throw new IndexOutOfBoundsException("Illegal index " + n2 + ", array size " + this.size());
        }
        this._children.set(n2, jsonNode);
        return this;
    }

    protected ArrayNode _add(JsonNode jsonNode) {
        this._children.add(jsonNode);
        return this;
    }
}

