/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.google.common.hash;

import com.gradle.scan.plugin.internal.dep.com.google.common.base.Preconditions;
import com.gradle.scan.plugin.internal.dep.com.google.common.hash.AbstractNonStreamingHashFunction;
import com.gradle.scan.plugin.internal.dep.com.google.common.hash.HashCode;
import com.gradle.scan.plugin.internal.dep.com.google.common.hash.HashFunction;
import com.gradle.scan.plugin.internal.dep.com.google.common.hash.LittleEndianByteArray;

final class FarmHashFingerprint64
extends AbstractNonStreamingHashFunction {
    static final HashFunction FARMHASH_FINGERPRINT_64 = new FarmHashFingerprint64();

    FarmHashFingerprint64() {
    }

    @Override
    public HashCode hashBytes(byte[] byArray, int n2, int n3) {
        Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
        return HashCode.fromLong(FarmHashFingerprint64.fingerprint(byArray, n2, n3));
    }

    public String toString() {
        return "Hashing.farmHashFingerprint64()";
    }

    static long fingerprint(byte[] byArray, int n2, int n3) {
        if (n3 <= 32) {
            if (n3 <= 16) {
                return FarmHashFingerprint64.hashLength0to16(byArray, n2, n3);
            }
            return FarmHashFingerprint64.hashLength17to32(byArray, n2, n3);
        }
        if (n3 <= 64) {
            return FarmHashFingerprint64.hashLength33To64(byArray, n2, n3);
        }
        return FarmHashFingerprint64.hashLength65Plus(byArray, n2, n3);
    }

    private static long shiftMix(long l2) {
        return l2 ^ l2 >>> 47;
    }

    private static long hashLength16(long l2, long l3, long l4) {
        long l5 = (l2 ^ l3) * l4;
        l5 ^= l5 >>> 47;
        long l6 = (l3 ^ l5) * l4;
        l6 ^= l6 >>> 47;
        return l6 *= l4;
    }

    private static void weakHashLength32WithSeeds(byte[] byArray, int n2, long l2, long l3, long[] lArray) {
        long l4 = LittleEndianByteArray.load64(byArray, n2);
        long l5 = LittleEndianByteArray.load64(byArray, n2 + 8);
        long l6 = LittleEndianByteArray.load64(byArray, n2 + 16);
        long l7 = LittleEndianByteArray.load64(byArray, n2 + 24);
        l3 = Long.rotateRight(l3 + (l2 += l4) + l7, 21);
        long l8 = l2;
        l2 += l5;
        lArray[0] = l2 + l7;
        lArray[1] = (l3 += Long.rotateRight(l2 += l6, 44)) + l8;
    }

    private static long hashLength0to16(byte[] byArray, int n2, int n3) {
        if (n3 >= 8) {
            long l2 = -7286425919675154353L + (long)(n3 * 2);
            long l3 = LittleEndianByteArray.load64(byArray, n2) + -7286425919675154353L;
            long l4 = LittleEndianByteArray.load64(byArray, n2 + n3 - 8);
            long l5 = Long.rotateRight(l4, 37) * l2 + l3;
            long l6 = (Long.rotateRight(l3, 25) + l4) * l2;
            return FarmHashFingerprint64.hashLength16(l5, l6, l2);
        }
        if (n3 >= 4) {
            long l7 = -7286425919675154353L + (long)(n3 * 2);
            long l8 = (long)LittleEndianByteArray.load32(byArray, n2) & 0xFFFFFFFFL;
            return FarmHashFingerprint64.hashLength16((long)n3 + (l8 << 3), (long)LittleEndianByteArray.load32(byArray, n2 + n3 - 4) & 0xFFFFFFFFL, l7);
        }
        if (n3 > 0) {
            byte by2 = byArray[n2];
            byte by3 = byArray[n2 + (n3 >> 1)];
            byte by4 = byArray[n2 + (n3 - 1)];
            int n4 = (by2 & 0xFF) + ((by3 & 0xFF) << 8);
            int n5 = n3 + ((by4 & 0xFF) << 2);
            return FarmHashFingerprint64.shiftMix((long)n4 * -7286425919675154353L ^ (long)n5 * -4348849565147123417L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    private static long hashLength17to32(byte[] byArray, int n2, int n3) {
        long l2 = -7286425919675154353L + (long)(n3 * 2);
        long l3 = LittleEndianByteArray.load64(byArray, n2) * -5435081209227447693L;
        long l4 = LittleEndianByteArray.load64(byArray, n2 + 8);
        long l5 = LittleEndianByteArray.load64(byArray, n2 + n3 - 8) * l2;
        long l6 = LittleEndianByteArray.load64(byArray, n2 + n3 - 16) * -7286425919675154353L;
        return FarmHashFingerprint64.hashLength16(Long.rotateRight(l3 + l4, 43) + Long.rotateRight(l5, 30) + l6, l3 + Long.rotateRight(l4 + -7286425919675154353L, 18) + l5, l2);
    }

    private static long hashLength33To64(byte[] byArray, int n2, int n3) {
        long l2 = -7286425919675154353L + (long)(n3 * 2);
        long l3 = LittleEndianByteArray.load64(byArray, n2) * -7286425919675154353L;
        long l4 = LittleEndianByteArray.load64(byArray, n2 + 8);
        long l5 = LittleEndianByteArray.load64(byArray, n2 + n3 - 8) * l2;
        long l6 = LittleEndianByteArray.load64(byArray, n2 + n3 - 16) * -7286425919675154353L;
        long l7 = Long.rotateRight(l3 + l4, 43) + Long.rotateRight(l5, 30) + l6;
        long l8 = FarmHashFingerprint64.hashLength16(l7, l3 + Long.rotateRight(l4 + -7286425919675154353L, 18) + l5, l2);
        long l9 = LittleEndianByteArray.load64(byArray, n2 + 16) * l2;
        long l10 = LittleEndianByteArray.load64(byArray, n2 + 24);
        long l11 = (l7 + LittleEndianByteArray.load64(byArray, n2 + n3 - 32)) * l2;
        long l12 = (l8 + LittleEndianByteArray.load64(byArray, n2 + n3 - 24)) * l2;
        return FarmHashFingerprint64.hashLength16(Long.rotateRight(l9 + l10, 43) + Long.rotateRight(l11, 30) + l12, l9 + Long.rotateRight(l10 + l3, 18) + l11, l2);
    }

    private static long hashLength65Plus(byte[] byArray, int n2, int n3) {
        long l2;
        int n4 = 81;
        long l3 = n4;
        long l4 = (long)n4 * -5435081209227447693L + 113L;
        long l5 = FarmHashFingerprint64.shiftMix(l4 * -7286425919675154353L + 113L) * -7286425919675154353L;
        long[] lArray = new long[2];
        long[] lArray2 = new long[2];
        l3 = l3 * -7286425919675154353L + LittleEndianByteArray.load64(byArray, n2);
        int n5 = n2 + (n3 - 1) / 64 * 64;
        int n6 = n5 + (n3 - 1 & 0x3F) - 63;
        do {
            l3 = Long.rotateRight(l3 + l4 + lArray[0] + LittleEndianByteArray.load64(byArray, n2 + 8), 37) * -5435081209227447693L;
            l4 = Long.rotateRight(l4 + lArray[1] + LittleEndianByteArray.load64(byArray, n2 + 48), 42) * -5435081209227447693L;
            l5 = Long.rotateRight(l5 + lArray2[0], 33) * -5435081209227447693L;
            FarmHashFingerprint64.weakHashLength32WithSeeds(byArray, n2, lArray[1] * -5435081209227447693L, (l3 ^= lArray2[1]) + lArray2[0], lArray);
            FarmHashFingerprint64.weakHashLength32WithSeeds(byArray, n2 + 32, l5 + lArray2[1], (l4 += lArray[0] + LittleEndianByteArray.load64(byArray, n2 + 40)) + LittleEndianByteArray.load64(byArray, n2 + 16), lArray2);
            l2 = l3;
            l3 = l5;
            l5 = l2;
        } while ((n2 += 64) != n5);
        l2 = -5435081209227447693L + ((l5 & 0xFFL) << 1);
        n2 = n6;
        lArray2[0] = lArray2[0] + (long)(n3 - 1 & 0x3F);
        lArray[0] = lArray[0] + lArray2[0];
        lArray2[0] = lArray2[0] + lArray[0];
        l3 = Long.rotateRight(l3 + l4 + lArray[0] + LittleEndianByteArray.load64(byArray, n2 + 8), 37) * l2;
        l4 = Long.rotateRight(l4 + lArray[1] + LittleEndianByteArray.load64(byArray, n2 + 48), 42) * l2;
        l5 = Long.rotateRight(l5 + lArray2[0], 33) * l2;
        FarmHashFingerprint64.weakHashLength32WithSeeds(byArray, n2, lArray[1] * l2, (l3 ^= lArray2[1] * 9L) + lArray2[0], lArray);
        FarmHashFingerprint64.weakHashLength32WithSeeds(byArray, n2 + 32, l5 + lArray2[1], (l4 += lArray[0] * 9L + LittleEndianByteArray.load64(byArray, n2 + 40)) + LittleEndianByteArray.load64(byArray, n2 + 16), lArray2);
        return FarmHashFingerprint64.hashLength16(FarmHashFingerprint64.hashLength16(lArray[0], lArray2[0], l2) + FarmHashFingerprint64.shiftMix(l4) * -4348849565147123417L + l3, FarmHashFingerprint64.hashLength16(lArray[1], lArray2[1], l2) + l5, l2);
    }
}

