/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpChannel;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpConversation;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpDestination;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpRequest;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpResponse;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.ResponseNotifier;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Result;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.CyclicTimeouts;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.util.List;

public class HttpExchange
implements CyclicTimeouts.Expirable {
    private static final Logger LOG = Log.getLogger(HttpExchange.class);
    private final HttpDestination destination;
    private final HttpRequest request;
    private final List<Response.ResponseListener> listeners;
    private final HttpResponse response;
    private State requestState = State.PENDING;
    private State responseState = State.PENDING;
    private HttpChannel _channel;
    private Throwable requestFailure;
    private Throwable responseFailure;

    public HttpExchange(HttpDestination httpDestination, HttpRequest httpRequest, List<Response.ResponseListener> list) {
        this.destination = httpDestination;
        this.request = httpRequest;
        this.listeners = list;
        this.response = new HttpResponse(httpRequest, list);
        HttpConversation httpConversation = httpRequest.getConversation();
        httpConversation.getExchanges().offer(this);
        httpConversation.updateResponseListeners(null);
    }

    public HttpConversation getConversation() {
        return this.request.getConversation();
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getRequestFailure() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            return this.requestFailure;
        }
    }

    public List<Response.ResponseListener> getResponseListeners() {
        return this.listeners;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    @Override
    public long getExpireNanoTime() {
        return this.request.getTimeoutAt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean associate(HttpChannel httpChannel) {
        boolean bl2 = false;
        boolean bl3 = false;
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            if (this.requestState == State.PENDING && this.responseState == State.PENDING) {
                boolean bl4 = bl3 = this._channel != null;
                if (!bl3) {
                    this._channel = httpChannel;
                    bl2 = true;
                }
            }
        }
        if (bl3) {
            this.request.abort(new IllegalStateException(this.toString()));
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disassociate(HttpChannel httpChannel) {
        boolean bl2 = false;
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            if (this._channel != httpChannel || this.requestState != State.TERMINATED || this.responseState != State.TERMINATED) {
                bl2 = true;
            }
            this._channel = null;
        }
        if (bl2) {
            this.request.abort(new IllegalStateException(this.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpChannel getHttpChannel() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            return this._channel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestComplete(Throwable throwable) {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            return this.completeRequest(throwable);
        }
    }

    private boolean completeRequest(Throwable throwable) {
        if (this.requestState == State.PENDING) {
            this.requestState = State.COMPLETED;
            this.requestFailure = throwable;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean responseComplete(Throwable throwable) {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            return this.completeResponse(throwable);
        }
    }

    private boolean completeResponse(Throwable throwable) {
        if (this.responseState == State.PENDING) {
            this.responseState = State.COMPLETED;
            this.responseFailure = throwable;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result terminateRequest() {
        Result result = null;
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            if (this.requestState == State.COMPLETED) {
                this.requestState = State.TERMINATED;
            }
            if (this.requestState == State.TERMINATED && this.responseState == State.TERMINATED) {
                result = new Result(this.getRequest(), this.requestFailure, this.getResponse(), this.responseFailure);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Terminated request for {}, result: {}", this, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result terminateResponse() {
        Result result = null;
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            if (this.responseState == State.COMPLETED) {
                this.responseState = State.TERMINATED;
            }
            if (this.requestState == State.TERMINATED && this.responseState == State.TERMINATED) {
                result = new Result(this.getRequest(), this.requestFailure, this.getResponse(), this.responseFailure);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Terminated response for {}, result: {}", this, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean abort(Throwable throwable) {
        boolean bl2;
        boolean bl3;
        CyclicTimeouts.Expirable expirable = this;
        synchronized (expirable) {
            bl3 = this.completeRequest(throwable);
            bl2 = this.completeResponse(throwable);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Failed {}: req={}/rsp={} {}", this, bl3, bl2, throwable);
        }
        if (!bl3 && !bl2) {
            return false;
        }
        if (this.destination.remove(this)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborting while queued {}: {}", this, throwable);
            }
            this.notifyFailureComplete(throwable);
            return true;
        }
        expirable = this.getHttpChannel();
        if (expirable == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborted before association {}: {}", this, throwable);
            }
            this.notifyFailureComplete(throwable);
            return true;
        }
        boolean bl4 = ((HttpChannel)expirable).abort(this, bl3 ? throwable : null, bl2 ? throwable : null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Aborted ({}) while active {}: {}", bl4, this, throwable);
        }
        return bl4;
    }

    private void notifyFailureComplete(Throwable throwable) {
        this.destination.getRequestNotifier().notifyFailure(this.request, throwable);
        List<Response.ResponseListener> list = this.getConversation().getResponseListeners();
        ResponseNotifier responseNotifier = this.destination.getResponseNotifier();
        responseNotifier.notifyFailure(list, (Response)this.response, throwable);
        responseNotifier.notifyComplete(list, new Result(this.request, throwable, this.response, throwable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetResponse() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            this.responseState = State.PENDING;
            this.responseFailure = null;
        }
    }

    public void proceed(Throwable throwable) {
        HttpChannel httpChannel = this.getHttpChannel();
        if (httpChannel != null) {
            httpChannel.proceed(this, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            return String.format("%s@%x{req=%s[%s/%s] res=%s[%s/%s]}", new Object[]{HttpExchange.class.getSimpleName(), this.hashCode(), this.request, this.requestState, this.requestFailure, this.response, this.responseState, this.responseFailure});
        }
    }

    private static enum State {
        PENDING,
        COMPLETED,
        TERMINATED;

    }
}

