/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.AbstractConnection;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.Connection;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.EndPoint;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.FillInterest;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.IdleTimeout;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.WriteFlusher;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Callback;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.Scheduler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractEndPoint
extends IdleTimeout
implements EndPoint {
    private static final Logger LOG = Log.getLogger(AbstractEndPoint.class);
    private final AtomicReference<State> _state = new AtomicReference<State>(State.OPEN);
    private final long _created = System.currentTimeMillis();
    private volatile Connection _connection;
    private final FillInterest _fillInterest = new FillInterest(){

        @Override
        protected void needsFillInterest() throws IOException {
            AbstractEndPoint.this.needsFillInterest();
        }
    };
    private final WriteFlusher _writeFlusher = new WriteFlusher(this){

        @Override
        protected void onIncompleteFlush() {
            AbstractEndPoint.this.onIncompleteFlush();
        }
    };

    protected AbstractEndPoint(Scheduler scheduler) {
        super(scheduler);
    }

    protected final void shutdownInput() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("shutdownInput {}", this);
        }
        block10: while (true) {
            State state = this._state.get();
            switch (state) {
                case OPEN: {
                    if (!this._state.compareAndSet(state, State.ISHUTTING)) continue block10;
                    try {
                        this.doShutdownInput();
                    }
                    finally {
                        if (!this._state.compareAndSet(State.ISHUTTING, State.ISHUT)) {
                            if (this._state.get() == State.CLOSED) {
                                this.doOnClose(null);
                            } else {
                                throw new IllegalStateException();
                            }
                        }
                    }
                    return;
                }
                case ISHUTTING: 
                case ISHUT: {
                    return;
                }
                case OSHUTTING: {
                    if (!this._state.compareAndSet(state, State.CLOSED)) continue block10;
                    return;
                }
                case OSHUT: {
                    if (!this._state.compareAndSet(state, State.CLOSED)) continue block10;
                    this.doOnClose(null);
                    return;
                }
                case CLOSED: {
                    return;
                }
            }
        }
    }

    @Override
    public final void shutdownOutput() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("shutdownOutput {}", this);
        }
        block10: while (true) {
            State state = this._state.get();
            switch (state) {
                case OPEN: {
                    if (!this._state.compareAndSet(state, State.OSHUTTING)) continue block10;
                    try {
                        this.doShutdownOutput();
                    }
                    finally {
                        if (!this._state.compareAndSet(State.OSHUTTING, State.OSHUT)) {
                            if (this._state.get() == State.CLOSED) {
                                this.doOnClose(null);
                            } else {
                                throw new IllegalStateException();
                            }
                        }
                    }
                    return;
                }
                case ISHUTTING: {
                    if (!this._state.compareAndSet(state, State.CLOSED)) continue block10;
                    return;
                }
                case ISHUT: {
                    if (!this._state.compareAndSet(state, State.CLOSED)) continue block10;
                    this.doOnClose(null);
                    return;
                }
                case OSHUTTING: 
                case OSHUT: {
                    return;
                }
                case CLOSED: {
                    return;
                }
            }
        }
    }

    @Override
    public final void close() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("close {}", this);
        }
        this.close(null);
    }

    protected final void close(Throwable throwable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("close({}) {}", throwable, this);
        }
        block5: while (true) {
            State state = this._state.get();
            switch (state) {
                case OPEN: 
                case ISHUT: 
                case OSHUT: {
                    if (!this._state.compareAndSet(state, State.CLOSED)) continue block5;
                    this.doOnClose(throwable);
                    return;
                }
                case ISHUTTING: 
                case OSHUTTING: {
                    if (!this._state.compareAndSet(state, State.CLOSED)) continue block5;
                    return;
                }
                case CLOSED: {
                    return;
                }
            }
        }
    }

    protected void doShutdownInput() {
    }

    protected void doShutdownOutput() {
    }

    private void doOnClose(Throwable throwable) {
        try {
            this.doClose();
        }
        finally {
            if (throwable == null) {
                this.onClose();
            } else {
                this.onClose(throwable);
            }
        }
    }

    protected void doClose() {
    }

    protected void onClose(Throwable throwable) {
        super.onClose();
        this._writeFlusher.onFail(throwable);
        this._fillInterest.onFail(throwable);
    }

    @Override
    public boolean isOutputShutdown() {
        switch (this._state.get()) {
            case OSHUTTING: 
            case OSHUT: 
            case CLOSED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isInputShutdown() {
        switch (this._state.get()) {
            case ISHUTTING: 
            case ISHUT: 
            case CLOSED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isOpen() {
        switch (this._state.get()) {
            case CLOSED: {
                return false;
            }
        }
        return true;
    }

    @Override
    public Connection getConnection() {
        return this._connection;
    }

    @Override
    public void setConnection(Connection connection) {
        this._connection = connection;
    }

    @Override
    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onOpen {}", this);
        }
        if (this._state.get() != State.OPEN) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void onClose() {
        super.onClose();
        this._writeFlusher.onClose();
        this._fillInterest.onClose();
    }

    @Override
    public void fillInterested(Callback callback) {
        this.notIdle();
        this._fillInterest.register(callback);
    }

    @Override
    public boolean tryFillInterested(Callback callback) {
        this.notIdle();
        return this._fillInterest.tryRegister(callback);
    }

    @Override
    public void write(Callback callback, ByteBuffer ... byteBufferArray) throws IllegalStateException {
        this._writeFlusher.write(callback, byteBufferArray);
    }

    protected abstract void onIncompleteFlush();

    protected abstract void needsFillInterest() throws IOException;

    public FillInterest getFillInterest() {
        return this._fillInterest;
    }

    public WriteFlusher getWriteFlusher() {
        return this._writeFlusher;
    }

    @Override
    protected void onIdleExpired(TimeoutException timeoutException) {
        Connection connection = this._connection;
        if (connection != null && !connection.onIdleExpired()) {
            return;
        }
        boolean bl2 = this.isOutputShutdown();
        boolean bl3 = this.isInputShutdown();
        boolean bl4 = this._fillInterest.onFail(timeoutException);
        boolean bl5 = this._writeFlusher.onFail(timeoutException);
        if (this.isOpen() && (bl2 || bl3) && !bl4 && !bl5) {
            this.close();
        } else {
            LOG.debug("Ignored idle endpoint {}", this);
        }
    }

    @Override
    public void upgrade(Connection connection) {
        Connection connection2 = this.getConnection();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} upgrading from {} to {}", this, connection2, connection);
        }
        ByteBuffer byteBuffer = connection2 instanceof Connection.UpgradeFrom ? ((Connection.UpgradeFrom)((Object)connection2)).onUpgradeFrom() : null;
        connection2.onClose();
        connection2.getEndPoint().setConnection(connection);
        if (BufferUtil.hasContent(byteBuffer)) {
            if (connection instanceof Connection.UpgradeTo) {
                ((Connection.UpgradeTo)((Object)connection)).onUpgradeTo(byteBuffer);
            } else {
                throw new IllegalStateException("Cannot upgrade: " + connection + " does not implement " + Connection.UpgradeTo.class.getName());
            }
        }
        connection.onOpen();
    }

    public String toString() {
        return String.format("%s->%s", this.toEndPointString(), this.toConnectionString());
    }

    public String toEndPointString() {
        Class<?> clazz = this.getClass();
        String string = clazz.getSimpleName();
        while (string.length() == 0 && clazz.getSuperclass() != null) {
            clazz = clazz.getSuperclass();
            string = clazz.getSimpleName();
        }
        return String.format("%s@%h{l=%s,r=%s,%s,fill=%s,flush=%s,to=%d/%d}", new Object[]{string, this, this.getLocalAddress(), this.getRemoteAddress(), this._state.get(), this._fillInterest.toStateString(), this._writeFlusher.toStateString(), this.getIdleFor(), this.getIdleTimeout()});
    }

    public String toConnectionString() {
        Connection connection = this.getConnection();
        if (connection == null) {
            return "<null>";
        }
        if (connection instanceof AbstractConnection) {
            return ((AbstractConnection)connection).toConnectionString();
        }
        return String.format("%s@%x", connection.getClass().getSimpleName(), connection.hashCode());
    }

    private static enum State {
        OPEN,
        ISHUTTING,
        ISHUT,
        OSHUTTING,
        OSHUT,
        CLOSED;

    }
}

