/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Promise;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.Scheduler;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public interface SocketAddressResolver {
    public void resolve(String var1, int var2, Promise<List<InetSocketAddress>> var3);

    public static class Async
    implements SocketAddressResolver {
        private static final Logger LOG = Log.getLogger(SocketAddressResolver.class);
        private final Executor executor;
        private final Scheduler scheduler;
        private final long timeout;

        public Async(Executor executor, Scheduler scheduler, long l2) {
            this.executor = executor;
            this.scheduler = scheduler;
            this.timeout = l2;
        }

        public long getTimeout() {
            return this.timeout;
        }

        @Override
        public void resolve(String string, int n2, Promise<List<InetSocketAddress>> promise) {
            this.executor.execute(() -> {
                Scheduler.Task task = null;
                AtomicBoolean atomicBoolean = new AtomicBoolean();
                if (this.timeout > 0L) {
                    Thread thread = Thread.currentThread();
                    task = this.scheduler.schedule(() -> {
                        if (atomicBoolean.compareAndSet(false, true)) {
                            promise.failed(new TimeoutException("DNS timeout " + this.getTimeout() + " ms"));
                            thread.interrupt();
                        }
                    }, this.timeout, TimeUnit.MILLISECONDS);
                }
                try {
                    long l2 = System.nanoTime();
                    InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
                    long l3 = System.nanoTime() - l2;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Resolved {} in {} ms", string, TimeUnit.NANOSECONDS.toMillis(l3));
                    }
                    ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>(inetAddressArray.length);
                    for (InetAddress inetAddress : inetAddressArray) {
                        arrayList.add(new InetSocketAddress(inetAddress, n2));
                    }
                    if (atomicBoolean.compareAndSet(false, true)) {
                        if (arrayList.isEmpty()) {
                            promise.failed(new UnknownHostException());
                        } else {
                            promise.succeeded(arrayList);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (atomicBoolean.compareAndSet(false, true)) {
                        promise.failed(throwable);
                    }
                }
                finally {
                    if (task != null) {
                        task.cancel();
                    }
                }
            });
        }
    }
}

