/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.HostPort;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.StringUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.TypeUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Utf8Appendable;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Utf8StringBuilder;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class URIUtil
implements Cloneable {
    private static final Logger LOG = Log.getLogger(URIUtil.class);
    public static final Charset __CHARSET = StandardCharsets.UTF_8;

    private URIUtil() {
    }

    public static String decodePath(String string) {
        return URIUtil.decodePath(string, 0, string.length());
    }

    public static String decodePath(String string, int n2, int n3) {
        try {
            Utf8StringBuilder utf8StringBuilder = null;
            int n4 = n2 + n3;
            block8: for (int i2 = n2; i2 < n4; ++i2) {
                char c2 = string.charAt(i2);
                switch (c2) {
                    case '%': {
                        if (utf8StringBuilder == null) {
                            utf8StringBuilder = new Utf8StringBuilder(string.length());
                            utf8StringBuilder.append(string, n2, i2 - n2);
                        }
                        if (i2 + 2 < n4) {
                            char c3 = string.charAt(i2 + 1);
                            if (c3 == 'u') {
                                utf8StringBuilder.append((char)(0xFFFF & TypeUtil.parseInt(string, i2 + 2, 4, 16)));
                                i2 += 5;
                                continue block8;
                            }
                            utf8StringBuilder.append((byte)(0xFF & TypeUtil.convertHexDigit(c3) * 16 + TypeUtil.convertHexDigit(string.charAt(i2 + 2))));
                            i2 += 2;
                            continue block8;
                        }
                        throw new IllegalArgumentException("Bad URI % encoding");
                    }
                    case ';': {
                        if (utf8StringBuilder == null) {
                            utf8StringBuilder = new Utf8StringBuilder(string.length());
                            utf8StringBuilder.append(string, n2, i2 - n2);
                        }
                        while (++i2 < n4) {
                            if (string.charAt(i2) != '/') continue;
                            utf8StringBuilder.append('/');
                            continue block8;
                        }
                        continue block8;
                    }
                    default: {
                        if (utf8StringBuilder == null) continue block8;
                        utf8StringBuilder.append(c2);
                    }
                }
            }
            if (utf8StringBuilder != null) {
                return utf8StringBuilder.toString();
            }
            if (n2 == 0 && n3 == string.length()) {
                return string;
            }
            return string.substring(n2, n4);
        }
        catch (Utf8Appendable.NotUtf8Exception notUtf8Exception) {
            LOG.debug(string.substring(n2, n2 + n3) + " " + notUtf8Exception, new Object[0]);
            return URIUtil.decodeISO88591Path(string, n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("cannot decode URI", exception);
        }
    }

    private static String decodeISO88591Path(String string, int n2, int n3) {
        StringBuilder stringBuilder = null;
        int n4 = n2 + n3;
        block4: for (int i2 = n2; i2 < n4; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '%': {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(string.length());
                        stringBuilder.append(string, n2, i2 - n2);
                    }
                    if (i2 + 2 < n4) {
                        char c3 = string.charAt(i2 + 1);
                        if (c3 == 'u') {
                            stringBuilder.append((char)(0xFFFF & TypeUtil.parseInt(string, i2 + 2, 4, 16)));
                            i2 += 5;
                            continue block4;
                        }
                        stringBuilder.append((char)(0xFF & TypeUtil.convertHexDigit(c3) * 16 + TypeUtil.convertHexDigit(string.charAt(i2 + 2))));
                        i2 += 2;
                        continue block4;
                    }
                    throw new IllegalArgumentException();
                }
                case ';': {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(string.length());
                        stringBuilder.append(string, n2, i2 - n2);
                    }
                    while (++i2 < n4) {
                        if (string.charAt(i2) != '/') continue;
                        stringBuilder.append('/');
                        continue block4;
                    }
                    continue block4;
                }
                default: {
                    if (stringBuilder == null) continue block4;
                    stringBuilder.append(c2);
                }
            }
        }
        if (stringBuilder != null) {
            return stringBuilder.toString();
        }
        if (n2 == 0 && n3 == string.length()) {
            return string;
        }
        return string.substring(n2, n4);
    }

    public static String canonicalPath(String string) {
        int n2;
        if (string == null || string.isEmpty()) {
            return string;
        }
        boolean bl2 = true;
        int n3 = string.length();
        block8: for (n2 = 0; n2 < n3; ++n2) {
            char c2 = string.charAt(n2);
            switch (c2) {
                case '/': {
                    bl2 = true;
                    continue block8;
                }
                case '.': {
                    if (bl2) break block8;
                    bl2 = false;
                    continue block8;
                }
                default: {
                    bl2 = false;
                }
            }
        }
        if (n2 == n3) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        stringBuilder.append(string, 0, n2);
        int n4 = 1;
        ++n2;
        while (n2 < n3) {
            char c3 = string.charAt(n2);
            switch (c3) {
                case '/': {
                    if (URIUtil.doDotsSlash(stringBuilder, n4)) {
                        return null;
                    }
                    bl2 = true;
                    n4 = 0;
                    break;
                }
                case '.': {
                    if (n4 > 0) {
                        ++n4;
                    } else if (bl2) {
                        n4 = 1;
                    } else {
                        stringBuilder.append('.');
                    }
                    bl2 = false;
                    break;
                }
                default: {
                    while (n4-- > 0) {
                        stringBuilder.append('.');
                    }
                    stringBuilder.append(c3);
                    n4 = 0;
                    bl2 = false;
                }
            }
            ++n2;
        }
        if (URIUtil.doDots(stringBuilder, n4)) {
            return null;
        }
        return stringBuilder.toString();
    }

    private static boolean doDots(StringBuilder stringBuilder, int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (stringBuilder.length() < 2) {
                    return true;
                }
                stringBuilder.setLength(stringBuilder.length() - 1);
                stringBuilder.setLength(stringBuilder.lastIndexOf("/") + 1);
                break;
            }
            default: {
                while (n2-- > 0) {
                    stringBuilder.append('.');
                }
                break block0;
            }
        }
        return false;
    }

    private static boolean doDotsSlash(StringBuilder stringBuilder, int n2) {
        switch (n2) {
            case 0: {
                stringBuilder.append('/');
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (stringBuilder.length() < 2) {
                    return true;
                }
                stringBuilder.setLength(stringBuilder.length() - 1);
                stringBuilder.setLength(stringBuilder.lastIndexOf("/") + 1);
                break;
            }
            default: {
                while (n2-- > 0) {
                    stringBuilder.append('.');
                }
                stringBuilder.append('/');
            }
        }
        return false;
    }

    public static void appendSchemeHostPort(StringBuilder stringBuilder, String string, String string2, int n2) {
        stringBuilder.append(string).append("://").append(HostPort.normalizeHost(string2));
        if (n2 > 0) {
            switch (string) {
                case "http": {
                    if (n2 == 80) break;
                    stringBuilder.append(':').append(n2);
                    break;
                }
                case "https": {
                    if (n2 == 443) break;
                    stringBuilder.append(':').append(n2);
                    break;
                }
                default: {
                    stringBuilder.append(':').append(n2);
                }
            }
        }
    }

    public static boolean equalsIgnoreEncodings(String string, String string2) {
        int n2 = string.length();
        int n3 = string2.length();
        int n4 = 0;
        int n5 = 0;
        while (n4 < n2 && n5 < n3) {
            int n6;
            int n7;
            int n8;
            int n9;
            if ((n9 = (n8 = string.charAt(n4++))) == 37) {
                n9 = URIUtil.lenientPercentDecode(string, n4);
                if (n9 == -1) {
                    n9 = 37;
                } else {
                    n4 += 2;
                }
            }
            if ((n7 = (n6 = string2.charAt(n5++))) == 37) {
                n7 = URIUtil.lenientPercentDecode(string2, n5);
                if (n7 == -1) {
                    n7 = 37;
                } else {
                    n5 += 2;
                }
            }
            if (n9 == 47 && n8 != n6) {
                return false;
            }
            if (n9 == n7) continue;
            return false;
        }
        return n4 == n2 && n5 == n3;
    }

    private static int lenientPercentDecode(String string, int n2) {
        if (n2 >= string.length()) {
            return -1;
        }
        if (StringUtil.isHex(string, n2, 2)) {
            return TypeUtil.parseInt(string, n2, 2, 16);
        }
        return -1;
    }

    public static boolean equalsIgnoreEncodings(URI uRI, URI uRI2) {
        if (uRI.equals(uRI2)) {
            return true;
        }
        if (uRI.getScheme() == null ? uRI2.getScheme() != null : !uRI.getScheme().equalsIgnoreCase(uRI2.getScheme())) {
            return false;
        }
        if ("jar".equalsIgnoreCase(uRI.getScheme())) {
            URI uRI3 = URI.create(uRI.getSchemeSpecificPart());
            URI uRI4 = URI.create(uRI2.getSchemeSpecificPart());
            return URIUtil.equalsIgnoreEncodings(uRI3, uRI4);
        }
        if (uRI.getAuthority() == null ? uRI2.getAuthority() != null : !uRI.getAuthority().equals(uRI2.getAuthority())) {
            return false;
        }
        return URIUtil.equalsIgnoreEncodings(uRI.getPath(), uRI2.getPath());
    }
}

