/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.AbstractLifeCycle;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.Scheduler;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class Sweeper
extends AbstractLifeCycle
implements Runnable {
    private static final Logger LOG = Log.getLogger(Sweeper.class);
    private final AtomicReference<List<Sweepable>> items;
    private final AtomicReference<Scheduler.Task> task;
    private final Scheduler scheduler;
    private final long period;

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.items.set(new CopyOnWriteArrayList());
        this.activate();
    }

    @Override
    protected void doStop() throws Exception {
        this.deactivate();
        this.items.set(null);
        super.doStop();
    }

    public boolean offer(Sweepable sweepable) {
        List<Sweepable> list = this.items.get();
        if (list == null) {
            return false;
        }
        list.add(sweepable);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resource offered {}", sweepable);
        }
        return true;
    }

    public boolean remove(Sweepable sweepable) {
        List<Sweepable> list = this.items.get();
        return list != null && list.remove(sweepable);
    }

    @Override
    public void run() {
        List<Sweepable> list = this.items.get();
        if (list == null) {
            return;
        }
        for (Sweepable sweepable : list) {
            try {
                if (!sweepable.sweep()) continue;
                list.remove(sweepable);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Resource swept {}", sweepable);
            }
            catch (Throwable throwable) {
                LOG.info("Exception while sweeping " + sweepable, throwable);
            }
        }
        this.activate();
    }

    private void activate() {
        if (this.isRunning()) {
            Scheduler.Task task = this.scheduler.schedule(this, this.period, TimeUnit.MILLISECONDS);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduled in {} ms sweep task {}", this.period, task);
            }
            this.task.set(task);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Skipping sweep task scheduling", new Object[0]);
        }
    }

    private void deactivate() {
        Scheduler.Task task = this.task.getAndSet(null);
        if (task != null) {
            boolean bl2 = task.cancel();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cancelled ({}) sweep task {}", bl2, task);
            }
        }
    }

    public static interface Sweepable {
        public boolean sweep();
    }
}

