/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class QuoteUtil {
    private static final char[] escapes = new char[32];

    public static String dequote(String string) {
        char c2;
        char c3 = string.charAt(0);
        if ((c3 == '\'' || c3 == '\"') && c3 == (c2 = string.charAt(string.length() - 1))) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static void escape(StringBuilder stringBuilder, String string) {
        for (char c2 : string.toCharArray()) {
            if (c2 >= ' ') {
                if (c2 == '\"' || c2 == '\\') {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c2);
                continue;
            }
            char c3 = escapes[c2];
            if (c3 == '\uffff') {
                stringBuilder.append("\\u00");
                if (c2 < '\u0010') {
                    stringBuilder.append('0');
                }
                stringBuilder.append(Integer.toString(c2, 16));
                continue;
            }
            stringBuilder.append('\\').append(c3);
        }
    }

    public static void quote(StringBuilder stringBuilder, String string) {
        stringBuilder.append('\"');
        QuoteUtil.escape(stringBuilder, string);
        stringBuilder.append('\"');
    }

    public static void quoteIfNeeded(StringBuilder stringBuilder, String string, String string2) {
        if (string == null) {
            return;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = string.codePointAt(i2);
            if (string2.indexOf(n3) < 0) continue;
            QuoteUtil.quote(stringBuilder, string);
            return;
        }
        stringBuilder.append(string);
    }

    public static Iterator<String> splitAt(String string, String string2) {
        return new DeQuotingStringIterator(string.trim(), string2);
    }

    static {
        Arrays.fill(escapes, '\uffff');
        QuoteUtil.escapes[8] = 98;
        QuoteUtil.escapes[9] = 116;
        QuoteUtil.escapes[10] = 110;
        QuoteUtil.escapes[12] = 102;
        QuoteUtil.escapes[13] = 114;
    }

    private static class DeQuotingStringIterator
    implements Iterator<String> {
        private final String input;
        private final String delims;
        private StringBuilder token;
        private boolean hasToken = false;
        private int i = 0;

        public DeQuotingStringIterator(String string, String string2) {
            this.input = string;
            this.delims = string2;
            int n2 = string.length();
            this.token = new StringBuilder(n2 > 1024 ? 512 : n2 / 2);
        }

        private void appendToken(char c2) {
            if (this.hasToken) {
                this.token.append(c2);
            } else {
                if (Character.isWhitespace(c2)) {
                    return;
                }
                this.token.append(c2);
                this.hasToken = true;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.hasToken) {
                return true;
            }
            State state = State.START;
            boolean bl2 = false;
            int n2 = this.input.length();
            while (this.i < n2) {
                char c2 = this.input.charAt(this.i++);
                switch (state) {
                    case START: {
                        if (c2 == '\'') {
                            state = State.QUOTE_SINGLE;
                            this.appendToken(c2);
                            break;
                        }
                        if (c2 == '\"') {
                            state = State.QUOTE_DOUBLE;
                            this.appendToken(c2);
                            break;
                        }
                        this.appendToken(c2);
                        state = State.TOKEN;
                        break;
                    }
                    case TOKEN: {
                        if (this.delims.indexOf(c2) >= 0) {
                            return this.hasToken;
                        }
                        if (c2 == '\'') {
                            state = State.QUOTE_SINGLE;
                        } else if (c2 == '\"') {
                            state = State.QUOTE_DOUBLE;
                        }
                        this.appendToken(c2);
                        break;
                    }
                    case QUOTE_SINGLE: {
                        if (bl2) {
                            bl2 = false;
                            this.appendToken(c2);
                            break;
                        }
                        if (c2 == '\'') {
                            this.appendToken(c2);
                            state = State.TOKEN;
                            break;
                        }
                        if (c2 == '\\') {
                            bl2 = true;
                            break;
                        }
                        this.appendToken(c2);
                        break;
                    }
                    case QUOTE_DOUBLE: {
                        if (bl2) {
                            bl2 = false;
                            this.appendToken(c2);
                            break;
                        }
                        if (c2 == '\"') {
                            this.appendToken(c2);
                            state = State.TOKEN;
                            break;
                        }
                        if (c2 == '\\') {
                            bl2 = true;
                            break;
                        }
                        this.appendToken(c2);
                    }
                }
            }
            return this.hasToken;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String string = this.token.toString();
            this.token.setLength(0);
            this.hasToken = false;
            return QuoteUtil.dequote(string.trim());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported with this iterator");
        }

        private static enum State {
            START,
            TOKEN,
            QUOTE_SINGLE,
            QUOTE_DOUBLE;

        }
    }
}

