/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events.annotated;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.util.ReflectUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;

public class CallableMethod {
    private static final Logger LOG = Log.getLogger(CallableMethod.class);
    protected final Class<?> pojo;
    protected final Method method;
    protected Class<?>[] paramTypes;

    public CallableMethod(Class<?> clazz, Method method) {
        Objects.requireNonNull(clazz, "Pojo cannot be null");
        Objects.requireNonNull(method, "Method cannot be null");
        this.pojo = clazz;
        this.method = method;
        this.paramTypes = method.getParameterTypes();
    }

    public Object call(Object object, Object ... objectArray) {
        if (this.pojo == null || this.method == null) {
            LOG.warn("Cannot execute call: pojo={}, method={}", this.pojo, this.method);
            return null;
        }
        if (object == null) {
            String string = String.format("Cannot call %s on null object", this.method);
            LOG.warn(new RuntimeException(string));
            return null;
        }
        if (objectArray.length < this.paramTypes.length) {
            throw new IllegalArgumentException("Call arguments length [" + objectArray.length + "] must always be greater than or equal to captured args length [" + this.paramTypes.length + "]");
        }
        try {
            return this.method.invoke(object, objectArray);
        }
        catch (Throwable throwable) {
            String string = this.formatMethodCallError(objectArray);
            throw this.unwrapRuntimeException(string, throwable);
        }
    }

    private RuntimeException unwrapRuntimeException(String string, Throwable throwable) {
        Throwable throwable2 = throwable;
        while (throwable2 instanceof InvocationTargetException) {
            throwable2 = throwable2.getCause();
        }
        if (throwable2 instanceof RuntimeException) {
            return (RuntimeException)throwable2;
        }
        return new RuntimeException(string, throwable2);
    }

    public String formatMethodCallError(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot call method ");
        stringBuilder.append(ReflectUtils.toString(this.pojo, this.method));
        stringBuilder.append(" with args: [");
        boolean bl2 = false;
        for (Object object : objectArray) {
            if (bl2) {
                stringBuilder.append(", ");
            }
            if (object == null) {
                stringBuilder.append("<null>");
            } else {
                stringBuilder.append(object.getClass().getName());
            }
            bl2 = true;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        return String.format("%s[pojo=%s,method=%s]", this.getClass().getSimpleName(), this.pojo.getName(), this.method.toGenericString());
    }
}

