/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.extensions;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.AbstractLifeCycle;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.BatchMode;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.WriteCallback;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.extensions.Extension;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.extensions.Frame;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;

public abstract class AbstractExtension
extends AbstractLifeCycle
implements Extension {
    private final Logger log = Log.getLogger(this.getClass());
    private WebSocketPolicy policy;
    private ByteBufferPool bufferPool;
    private ExtensionConfig config;
    private OutgoingFrames nextOutgoing;
    private IncomingFrames nextIncoming;

    @Deprecated
    public void init(WebSocketContainerScope webSocketContainerScope) {
        this.init(webSocketContainerScope.getPolicy(), webSocketContainerScope.getBufferPool());
    }

    public void init(WebSocketPolicy webSocketPolicy, ByteBufferPool byteBufferPool) {
        this.policy = webSocketPolicy;
        this.bufferPool = byteBufferPool;
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    @Override
    public boolean isRsv1User() {
        return false;
    }

    @Override
    public boolean isRsv2User() {
        return false;
    }

    @Override
    public boolean isRsv3User() {
        return false;
    }

    protected void nextOutgoingFrame(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("nextOutgoingFrame({})", frame);
            }
            this.nextOutgoing.outgoingFrame(frame, writeCallback, batchMode);
        }
        catch (Throwable throwable) {
            if (writeCallback != null) {
                writeCallback.writeFailed(throwable);
            }
            this.log.warn(throwable);
        }
    }

    public void setConfig(ExtensionConfig extensionConfig) {
        this.config = extensionConfig;
    }

    @Override
    public void setNextIncomingFrames(IncomingFrames incomingFrames) {
        this.nextIncoming = incomingFrames;
    }

    @Override
    public void setNextOutgoingFrames(OutgoingFrames outgoingFrames) {
        this.nextOutgoing = outgoingFrames;
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.config.getParameterizedName());
    }
}

