/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.archivers.zip;

import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.archivers.zip.ZipEncoding;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

class NioZipEncoding
implements ZipEncoding {
    private static final byte[] REPLACEMENT_BYTES = new byte[]{63};
    private static final String REPLACEMENT_STRING = String.valueOf('?');
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final Charset charset;
    private final boolean useReplacement;

    private static ByteBuffer encodeFully(CharsetEncoder charsetEncoder, CharBuffer charBuffer, ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer;
        while (charBuffer.hasRemaining()) {
            CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer2, false);
            if (!coderResult.isOverflow()) continue;
            int n2 = NioZipEncoding.estimateIncrementalEncodingSize(charsetEncoder, charBuffer.remaining());
            byteBuffer2 = ZipEncodingHelper.growBufferBy(byteBuffer2, n2);
        }
        return byteBuffer2;
    }

    private static CharBuffer encodeSurrogate(CharBuffer charBuffer, char c2) {
        charBuffer.position(0).limit(6);
        charBuffer.put('%');
        charBuffer.put('U');
        charBuffer.put(HEX_CHARS[c2 >> 12 & 0xF]);
        charBuffer.put(HEX_CHARS[c2 >> 8 & 0xF]);
        charBuffer.put(HEX_CHARS[c2 >> 4 & 0xF]);
        charBuffer.put(HEX_CHARS[c2 & 0xF]);
        charBuffer.flip();
        return charBuffer;
    }

    private static int estimateIncrementalEncodingSize(CharsetEncoder charsetEncoder, int n2) {
        return (int)Math.ceil((float)n2 * charsetEncoder.averageBytesPerChar());
    }

    private static int estimateInitialBufferSize(CharsetEncoder charsetEncoder, int n2) {
        float f2 = charsetEncoder.maxBytesPerChar();
        float f3 = (float)(n2 - 1) * charsetEncoder.averageBytesPerChar();
        return (int)Math.ceil(f2 + f3);
    }

    NioZipEncoding(Charset charset, boolean bl2) {
        this.charset = charset;
        this.useReplacement = bl2;
    }

    @Override
    public boolean canEncode(String string) {
        CharsetEncoder charsetEncoder = this.newEncoder();
        return charsetEncoder.canEncode(string);
    }

    @Override
    public String decode(byte[] byArray) throws IOException {
        return this.newDecoder().decode(ByteBuffer.wrap(byArray)).toString();
    }

    @Override
    public ByteBuffer encode(String string) {
        CharsetEncoder charsetEncoder = this.newEncoder();
        CharBuffer charBuffer = CharBuffer.wrap(string);
        CharBuffer charBuffer2 = null;
        ByteBuffer byteBuffer = ByteBuffer.allocate(NioZipEncoding.estimateInitialBufferSize(charsetEncoder, charBuffer.remaining()));
        while (charBuffer.hasRemaining()) {
            int n2;
            CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, false);
            if (coderResult.isUnmappable() || coderResult.isMalformed()) {
                int n3;
                n2 = NioZipEncoding.estimateIncrementalEncodingSize(charsetEncoder, 6 * coderResult.length());
                if (n2 > byteBuffer.remaining()) {
                    int n4;
                    n3 = 0;
                    for (n4 = charBuffer.position(); n4 < charBuffer.limit(); ++n4) {
                        n3 += !charsetEncoder.canEncode(charBuffer.get(n4)) ? 6 : 1;
                    }
                    n4 = NioZipEncoding.estimateIncrementalEncodingSize(charsetEncoder, n3);
                    byteBuffer = ZipEncodingHelper.growBufferBy(byteBuffer, n4 - byteBuffer.remaining());
                }
                if (charBuffer2 == null) {
                    charBuffer2 = CharBuffer.allocate(6);
                }
                for (n3 = 0; n3 < coderResult.length(); ++n3) {
                    byteBuffer = NioZipEncoding.encodeFully(charsetEncoder, NioZipEncoding.encodeSurrogate(charBuffer2, charBuffer.get()), byteBuffer);
                }
                continue;
            }
            if (coderResult.isOverflow()) {
                n2 = NioZipEncoding.estimateIncrementalEncodingSize(charsetEncoder, charBuffer.remaining());
                byteBuffer = ZipEncodingHelper.growBufferBy(byteBuffer, n2);
                continue;
            }
            if (!coderResult.isUnderflow() && !coderResult.isError()) continue;
            break;
        }
        charsetEncoder.encode(charBuffer, byteBuffer, true);
        byteBuffer.limit(byteBuffer.position());
        byteBuffer.rewind();
        return byteBuffer;
    }

    private CharsetDecoder newDecoder() {
        if (!this.useReplacement) {
            return this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(REPLACEMENT_STRING);
    }

    private CharsetEncoder newEncoder() {
        if (this.useReplacement) {
            return this.charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(REPLACEMENT_BYTES);
        }
        return this.charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }
}

