/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.BadMessageException;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpFields;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpHeaderValue;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpMethod;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpStatus;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpTokens;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpVersion;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.MetaData;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.PreEncodedHttpField;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.ArrayTrie;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.StringUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Trie;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HttpGenerator {
    private static final Logger LOG = Log.getLogger(HttpGenerator.class);
    public static final boolean __STRICT = Boolean.getBoolean("com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpGenerator.STRICT");
    private static final byte[] __colon_space = new byte[]{58, 32};
    public static final MetaData.Response CONTINUE_100_INFO = new MetaData.Response(HttpVersion.HTTP_1_1, 100, null, null, -1L);
    public static final MetaData.Response PROGRESS_102_INFO = new MetaData.Response(HttpVersion.HTTP_1_1, 102, null, null, -1L);
    public static final MetaData.Response RESPONSE_500_INFO = new MetaData.Response(HttpVersion.HTTP_1_1, 500, null, new HttpFields(){
        {
            this.put(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
        }
    }, 0L);
    private State _state = State.START;
    private HttpTokens.EndOfContent _endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
    private long _contentPrepared = 0L;
    private boolean _noContentResponse = false;
    private Boolean _persistent = null;
    private Supplier<HttpFields> _trailers = null;
    private final int _send;
    private static final Trie<Boolean> ASSUMED_CONTENT_METHODS = new ArrayTrie<Boolean>(8);
    private boolean _needCRLF = false;
    private static final byte[] ZERO_CHUNK;
    private static final byte[] LAST_CHUNK;
    private static final byte[] CONTENT_LENGTH_0;
    private static final byte[] CONNECTION_CLOSE;
    private static final byte[] HTTP_1_1_SPACE;
    private static final byte[] TRANSFER_ENCODING_CHUNKED;
    private static final byte[][] SEND;
    private static final PreparedResponse[] __preprepared;

    public HttpGenerator() {
        this(false, false);
    }

    public HttpGenerator(boolean bl2, boolean bl3) {
        this._send = (bl2 ? 1 : 0) | (bl3 ? 2 : 0);
    }

    public void reset() {
        this._state = State.START;
        this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
        this._noContentResponse = false;
        this._persistent = null;
        this._contentPrepared = 0L;
        this._needCRLF = false;
        this._trailers = null;
    }

    public boolean isChunking() {
        return this._endOfContent == HttpTokens.EndOfContent.CHUNKED_CONTENT;
    }

    public void abort() {
        this._persistent = false;
        this._state = State.END;
        this._endOfContent = null;
    }

    public Result generateRequest(MetaData.Request request, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, boolean bl2) throws IOException {
        switch (this._state) {
            case START: {
                if (request == null) {
                    return Result.NEED_INFO;
                }
                if (byteBuffer == null) {
                    return Result.NEED_HEADER;
                }
                int n2 = BufferUtil.flipToFill(byteBuffer);
                try {
                    this.generateRequestLine(request, byteBuffer);
                    if (request.getHttpVersion() == HttpVersion.HTTP_0_9) {
                        throw new BadMessageException(500, "HTTP/0.9 not supported");
                    }
                    this.generateHeaders(request, byteBuffer, byteBuffer3, bl2);
                    boolean bl3 = request.getFields().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
                    if (bl3) {
                        this._state = State.COMMITTED;
                    } else {
                        int n3 = BufferUtil.length(byteBuffer3);
                        if (n3 > 0) {
                            this._contentPrepared += (long)n3;
                            if (this.isChunking()) {
                                this.prepareChunk(byteBuffer, n3);
                            }
                        }
                        this._state = bl2 ? State.COMPLETING : State.COMMITTED;
                    }
                    Result result = Result.FLUSH;
                    return result;
                }
                catch (BadMessageException badMessageException) {
                    throw badMessageException;
                }
                catch (BufferOverflowException bufferOverflowException) {
                    LOG.ignore(bufferOverflowException);
                    Result result = Result.HEADER_OVERFLOW;
                    return result;
                }
                catch (Exception exception) {
                    throw new BadMessageException(500, exception.getMessage(), exception);
                }
                finally {
                    BufferUtil.flipToFlush(byteBuffer, n2);
                }
            }
            case COMMITTED: {
                return this.committed(byteBuffer2, byteBuffer3, bl2);
            }
            case COMPLETING: {
                return this.completing(byteBuffer2, byteBuffer3);
            }
            case END: {
                if (BufferUtil.hasContent(byteBuffer3)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("discarding content in COMPLETING", new Object[0]);
                    }
                    BufferUtil.clear(byteBuffer3);
                }
                return Result.DONE;
            }
        }
        throw new IllegalStateException();
    }

    private Result committed(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl2) {
        int n2 = BufferUtil.length(byteBuffer2);
        if (n2 > 0) {
            if (this.isChunking()) {
                if (byteBuffer == null) {
                    return Result.NEED_CHUNK;
                }
                BufferUtil.clearToFill(byteBuffer);
                this.prepareChunk(byteBuffer, n2);
                BufferUtil.flipToFlush(byteBuffer, 0);
            }
            this._contentPrepared += (long)n2;
        }
        if (bl2) {
            this._state = State.COMPLETING;
            return n2 > 0 ? Result.FLUSH : Result.CONTINUE;
        }
        return n2 > 0 ? Result.FLUSH : Result.DONE;
    }

    private Result completing(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (BufferUtil.hasContent(byteBuffer2)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("discarding content in COMPLETING", new Object[0]);
            }
            BufferUtil.clear(byteBuffer2);
        }
        if (this.isChunking()) {
            if (this._trailers != null) {
                if (byteBuffer == null || byteBuffer.capacity() <= 12) {
                    return Result.NEED_CHUNK_TRAILER;
                }
                HttpFields httpFields = this._trailers.get();
                if (httpFields != null) {
                    BufferUtil.clearToFill(byteBuffer);
                    this.generateTrailers(byteBuffer, httpFields);
                    BufferUtil.flipToFlush(byteBuffer, 0);
                    this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
                    return Result.FLUSH;
                }
            }
            if (byteBuffer == null) {
                return Result.NEED_CHUNK;
            }
            BufferUtil.clearToFill(byteBuffer);
            this.prepareChunk(byteBuffer, 0);
            BufferUtil.flipToFlush(byteBuffer, 0);
            this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
            return Result.FLUSH;
        }
        this._state = State.END;
        return Boolean.TRUE.equals(this._persistent) ? Result.DONE : Result.SHUTDOWN_OUT;
    }

    private void prepareChunk(ByteBuffer byteBuffer, int n2) {
        if (this._needCRLF) {
            BufferUtil.putCRLF(byteBuffer);
        }
        if (n2 > 0) {
            BufferUtil.putHexInt(byteBuffer, n2);
            BufferUtil.putCRLF(byteBuffer);
            this._needCRLF = true;
        } else {
            byteBuffer.put(LAST_CHUNK);
            this._needCRLF = false;
        }
    }

    private void generateTrailers(ByteBuffer byteBuffer, HttpFields httpFields) {
        if (this._needCRLF) {
            BufferUtil.putCRLF(byteBuffer);
        }
        byteBuffer.put(ZERO_CHUNK);
        int n2 = httpFields.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            HttpField httpField = httpFields.getField(i2);
            HttpGenerator.putTo(httpField, byteBuffer);
        }
        BufferUtil.putCRLF(byteBuffer);
    }

    private void generateRequestLine(MetaData.Request request, ByteBuffer byteBuffer) {
        byteBuffer.put(StringUtil.getBytes(request.getMethod()));
        byteBuffer.put((byte)32);
        byteBuffer.put(StringUtil.getBytes(request.getURIString()));
        byteBuffer.put((byte)32);
        byteBuffer.put(request.getHttpVersion().toBytes());
        byteBuffer.put(HttpTokens.CRLF);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateHeaders(MetaData metaData, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl2) {
        int n2;
        boolean bl3;
        int n3;
        int n4;
        int n5;
        MetaData.Response response;
        MetaData.Request request = metaData instanceof MetaData.Request ? (MetaData.Request)metaData : null;
        MetaData.Response response2 = response = metaData instanceof MetaData.Response ? (MetaData.Response)metaData : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("generateHeaders {} last={} content={}", metaData, bl2, BufferUtil.toDetailString(byteBuffer2));
            LOG.debug(metaData.getFields().toString(), new Object[0]);
        }
        int n6 = this._send;
        HttpField httpField = null;
        boolean bl4 = metaData.getHttpVersion() == HttpVersion.HTTP_1_1;
        boolean bl5 = false;
        this._trailers = bl4 ? metaData.getTrailerSupplier() : null;
        boolean bl6 = this._trailers != null;
        boolean bl7 = false;
        long l2 = metaData.getContentLength();
        boolean bl8 = false;
        HttpFields httpFields = metaData.getFields();
        if (httpFields != null) {
            n5 = httpFields.size();
            block7: for (n4 = 0; n4 < n5; ++n4) {
                HttpField httpField2 = httpFields.getField(n4);
                HttpHeader httpHeader = httpField2.getHeader();
                if (httpHeader == null) {
                    HttpGenerator.putTo(httpField2, byteBuffer);
                    continue;
                }
                switch (httpHeader) {
                    case CONTENT_LENGTH: {
                        if (l2 < 0L) {
                            l2 = httpField2.getLongValue();
                        } else if (l2 != httpField2.getLongValue()) {
                            throw new BadMessageException(500, String.format("Incorrect Content-Length %d!=%d", l2, httpField2.getLongValue()));
                        }
                        bl8 = true;
                        continue block7;
                    }
                    case CONTENT_TYPE: {
                        bl7 = true;
                        HttpGenerator.putTo(httpField2, byteBuffer);
                        continue block7;
                    }
                    case TRANSFER_ENCODING: {
                        if (!bl4) continue block7;
                        httpField = httpField2;
                        bl6 = httpField2.contains(HttpHeaderValue.CHUNKED.asString());
                        continue block7;
                    }
                    case CONNECTION: {
                        n3 = httpField2.contains(HttpHeaderValue.KEEP_ALIVE.asString());
                        if (n3 != 0 && metaData.getHttpVersion() == HttpVersion.HTTP_1_0 && this._persistent == null) {
                            this._persistent = true;
                        }
                        if (httpField2.contains(HttpHeaderValue.CLOSE.asString())) {
                            bl5 = true;
                            this._persistent = false;
                        }
                        if (n3 != 0 && Boolean.FALSE.equals(this._persistent)) {
                            httpField2 = new HttpField(HttpHeader.CONNECTION, Stream.of(httpField2.getValues()).filter(string -> !HttpHeaderValue.KEEP_ALIVE.is((String)string)).collect(Collectors.joining(", ")));
                        }
                        HttpGenerator.putTo(httpField2, byteBuffer);
                        continue block7;
                    }
                    case SERVER: {
                        n6 &= 0xFFFFFFFE;
                        HttpGenerator.putTo(httpField2, byteBuffer);
                        continue block7;
                    }
                    default: {
                        HttpGenerator.putTo(httpField2, byteBuffer);
                    }
                }
            }
        }
        if (bl2 && l2 < 0L && this._trailers == null) {
            l2 = this._contentPrepared + (long)BufferUtil.length(byteBuffer2);
        }
        n5 = request != null && Boolean.TRUE.equals(ASSUMED_CONTENT_METHODS.get(request.getMethod())) ? 1 : 0;
        n4 = n5 != 0 || bl7 || bl6 ? 1 : 0;
        boolean bl9 = bl3 = request != null && l2 <= 0L && n4 == 0;
        if (this._persistent == null) {
            this._persistent = bl4 || request != null && HttpMethod.CONNECT.is(request.getMethod());
        }
        if (this._noContentResponse || bl3) {
            this._endOfContent = HttpTokens.EndOfContent.NO_CONTENT;
            if (this._contentPrepared > 0L) {
                throw new BadMessageException(500, "Content for no content response");
            }
            if (bl8) {
                if (response != null && response.getStatus() == 304) {
                    HttpGenerator.putContentLength(byteBuffer, l2);
                } else if (l2 > 0L) {
                    if (this._contentPrepared != 0L || !bl2) throw new BadMessageException(500, "Content for no content response");
                    byteBuffer2.clear();
                }
            }
        } else if (bl4 && (bl6 || l2 < 0L && (this._persistent.booleanValue() || n5 != 0))) {
            this._endOfContent = HttpTokens.EndOfContent.CHUNKED_CONTENT;
            if (httpField == null) {
                byteBuffer.put(TRANSFER_ENCODING_CHUNKED);
            } else if (httpField.toString().endsWith(HttpHeaderValue.CHUNKED.toString())) {
                HttpGenerator.putTo(httpField, byteBuffer);
                httpField = null;
            } else {
                if (bl6) throw new BadMessageException(500, "Bad Transfer-Encoding");
                HttpGenerator.putTo(new HttpField(HttpHeader.TRANSFER_ENCODING, httpField.getValue() + ",chunked"), byteBuffer);
                httpField = null;
            }
        } else if (l2 >= 0L && (request != null || this._persistent.booleanValue())) {
            this._endOfContent = HttpTokens.EndOfContent.CONTENT_LENGTH;
            HttpGenerator.putContentLength(byteBuffer, l2);
        } else {
            if (response == null) throw new BadMessageException(500, "Unknown content length for request");
            this._endOfContent = HttpTokens.EndOfContent.EOF_CONTENT;
            this._persistent = false;
            if (l2 >= 0L && (l2 > 0L || n4 != 0 || bl8)) {
                HttpGenerator.putContentLength(byteBuffer, l2);
            }
            if (bl4 && !bl5) {
                byteBuffer.put(CONNECTION_CLOSE);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this._endOfContent.toString(), new Object[0]);
        }
        if (httpField != null) {
            if (bl6) {
                String string2 = httpField.getValue();
                n3 = string2.lastIndexOf(44);
                if (n3 > 0 && string2.lastIndexOf(HttpHeaderValue.CHUNKED.toString(), n3) > n3) {
                    HttpGenerator.putTo(new HttpField(HttpHeader.TRANSFER_ENCODING, string2.substring(0, n3).trim()), byteBuffer);
                }
            } else {
                HttpGenerator.putTo(httpField, byteBuffer);
            }
        }
        int n7 = n2 = response != null ? response.getStatus() : -1;
        if (n2 > 199) {
            byteBuffer.put(SEND[n6]);
        }
        byteBuffer.put(HttpTokens.CRLF);
    }

    private static void putContentLength(ByteBuffer byteBuffer, long l2) {
        if (l2 == 0L) {
            byteBuffer.put(CONTENT_LENGTH_0);
        } else {
            byteBuffer.put(HttpHeader.CONTENT_LENGTH.getBytesColonSpace());
            BufferUtil.putDecLong(byteBuffer, l2);
            byteBuffer.put(HttpTokens.CRLF);
        }
    }

    public String toString() {
        return String.format("%s@%x{s=%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state});
    }

    private static void putSanitisedName(String string, ByteBuffer byteBuffer) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '\u0000' || c2 > '\u00ff' || c2 == '\r' || c2 == '\n' || c2 == ':') {
                byteBuffer.put((byte)63);
                continue;
            }
            byteBuffer.put((byte)(0xFF & c2));
        }
    }

    private static void putSanitisedValue(String string, ByteBuffer byteBuffer) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '\u0000' || c2 > '\u00ff' || c2 == '\r' || c2 == '\n') {
                byteBuffer.put((byte)32);
                continue;
            }
            byteBuffer.put((byte)(0xFF & c2));
        }
    }

    public static void putTo(HttpField httpField, ByteBuffer byteBuffer) {
        if (httpField instanceof PreEncodedHttpField) {
            ((PreEncodedHttpField)httpField).putTo(byteBuffer, HttpVersion.HTTP_1_0);
        } else {
            HttpHeader httpHeader = httpField.getHeader();
            if (httpHeader != null) {
                byteBuffer.put(httpHeader.getBytesColonSpace());
                HttpGenerator.putSanitisedValue(httpField.getValue(), byteBuffer);
            } else {
                HttpGenerator.putSanitisedName(httpField.getName(), byteBuffer);
                byteBuffer.put(__colon_space);
                HttpGenerator.putSanitisedValue(httpField.getValue(), byteBuffer);
            }
            BufferUtil.putCRLF(byteBuffer);
        }
    }

    static {
        ASSUMED_CONTENT_METHODS.put(HttpMethod.POST.asString(), Boolean.TRUE);
        ASSUMED_CONTENT_METHODS.put(HttpMethod.PUT.asString(), Boolean.TRUE);
        ZERO_CHUNK = new byte[]{48, 13, 10};
        LAST_CHUNK = new byte[]{48, 13, 10, 13, 10};
        CONTENT_LENGTH_0 = StringUtil.getBytes("Content-Length: 0\r\n");
        CONNECTION_CLOSE = StringUtil.getBytes("Connection: close\r\n");
        HTTP_1_1_SPACE = StringUtil.getBytes((Object)((Object)HttpVersion.HTTP_1_1) + " ");
        TRANSFER_ENCODING_CHUNKED = StringUtil.getBytes("Transfer-Encoding: chunked\r\n");
        SEND = new byte[][]{new byte[0], StringUtil.getBytes("Server: Jetty(9.x.x)\r\n"), StringUtil.getBytes("X-Powered-By: Jetty(9.x.x)\r\n"), StringUtil.getBytes("Server: Jetty(9.x.x)\r\nX-Powered-By: Jetty(9.x.x)\r\n")};
        __preprepared = new PreparedResponse[512];
        int n2 = HttpVersion.HTTP_1_1.toString().length();
        for (int i2 = 0; i2 < __preprepared.length; ++i2) {
            HttpStatus.Code code = HttpStatus.getCode(i2);
            if (code == null) continue;
            String string = code.getMessage();
            byte[] byArray = new byte[n2 + 5 + string.length() + 2];
            HttpVersion.HTTP_1_1.toBuffer().get(byArray, 0, n2);
            byArray[n2 + 0] = 32;
            byArray[n2 + 1] = (byte)(48 + i2 / 100);
            byArray[n2 + 2] = (byte)(48 + i2 % 100 / 10);
            byArray[n2 + 3] = (byte)(48 + i2 % 10);
            byArray[n2 + 4] = 32;
            for (int i3 = 0; i3 < string.length(); ++i3) {
                byArray[n2 + 5 + i3] = (byte)string.charAt(i3);
            }
            byArray[n2 + 5 + string.length()] = 13;
            byArray[n2 + 6 + string.length()] = 10;
            HttpGenerator.__preprepared[i2] = new PreparedResponse();
            HttpGenerator.__preprepared[i2]._schemeCode = Arrays.copyOfRange(byArray, 0, n2 + 5);
            HttpGenerator.__preprepared[i2]._reason = Arrays.copyOfRange(byArray, n2 + 5, byArray.length - 2);
            HttpGenerator.__preprepared[i2]._responseLine = byArray;
        }
    }

    private static class PreparedResponse {
        byte[] _reason;
        byte[] _schemeCode;
        byte[] _responseLine;

        private PreparedResponse() {
        }
    }

    public static enum Result {
        NEED_CHUNK,
        NEED_INFO,
        NEED_HEADER,
        HEADER_OVERFLOW,
        NEED_CHUNK_TRAILER,
        FLUSH,
        CONTINUE,
        SHUTDOWN_OUT,
        DONE;

    }

    public static enum State {
        START,
        COMMITTED,
        COMPLETING,
        COMPLETING_1XX,
        END;

    }
}

