/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util;

import java.util.ArrayList;
import java.util.List;

public class MultiException
extends Exception {
    private List<Throwable> nested;

    public MultiException() {
        super("Multiple exceptions", null, false, false);
        this.nested = new ArrayList<Throwable>();
    }

    private MultiException(List<Throwable> list) {
        super("Multiple exceptions");
        this.nested = new ArrayList<Throwable>(list);
        if (list.size() > 0) {
            this.initCause(list.get(0));
        }
        for (Throwable throwable : list) {
            if (throwable == this) continue;
            this.addSuppressed(throwable);
        }
    }

    public void add(Throwable throwable) {
        if (throwable instanceof MultiException) {
            MultiException multiException = (MultiException)throwable;
            this.nested.addAll(multiException.nested);
        } else {
            this.nested.add(throwable);
        }
    }

    public void ifExceptionThrow() throws Exception {
        if (this.nested == null) {
            return;
        }
        switch (this.nested.size()) {
            case 0: {
                break;
            }
            case 1: {
                Throwable throwable = this.nested.get(0);
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new MultiException(this.nested);
            }
            default: {
                throw new MultiException(this.nested);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(MultiException.class.getSimpleName());
        if (this.nested == null || this.nested.size() <= 0) {
            stringBuilder.append("[]");
        } else {
            stringBuilder.append(this.nested);
        }
        return stringBuilder.toString();
    }
}

