/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.testsreader.TestsReader;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.AnnotationVisitor;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.MethodVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class SpockParameterClassVisitor
extends TestsReader.Visitor<Map<String, List<String>>> {
    private final Set<String> failedTestNames;
    private final TestsReader testsReader;
    private final SpockParameterMethodVisitor spockMethodVisitor = new SpockParameterMethodVisitor();
    private boolean isSpec;

    public SpockParameterClassVisitor(Set<String> set, TestsReader testsReader) {
        this.failedTestNames = set;
        this.testsReader = testsReader;
    }

    @Override
    public Map<String, List<String>> getResult() {
        if (!this.isSpec) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        this.spockMethodVisitor.annotationVisitor.testMethodPatterns.forEach(string -> {
            String string2 = Arrays.stream(string.split("#[\\p{L}\\d$_.()&&[^#\\s]]+")).map(Pattern::quote).collect(Collectors.joining(".*")) + ".*";
            this.failedTestNames.forEach(string4 -> {
                List list = hashMap.computeIfAbsent((String)string4, string -> new ArrayList());
                if (string.equals(string4) || string4.matches(string2)) {
                    list.add(string);
                }
            });
        });
        return hashMap;
    }

    @Override
    public void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        super.visit(n2, n3, string, string2, string3, stringArray);
        if (string3 != null) {
            if (string3.equals("spock/lang/Specification")) {
                this.isSpec = true;
            } else if (!string3.equals("java/lang/Object")) {
                this.testsReader.readClass(string3.replace('/', '.'), () -> this);
            }
        }
    }

    @Override
    public MethodVisitor visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
        return this.isSpec ? this.spockMethodVisitor : null;
    }

    private static final class SpockParameterMethodVisitor
    extends MethodVisitor {
        private final SpockFeatureMetadataAnnotationVisitor annotationVisitor = new SpockFeatureMetadataAnnotationVisitor();

        public SpockParameterMethodVisitor() {
            super(458752);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String string, boolean bl2) {
            if (string.contains("org/spockframework/runtime/model/FeatureMetadata")) {
                return this.annotationVisitor;
            }
            return null;
        }

        private static final class SpockFeatureMetadataAnnotationVisitor
        extends AnnotationVisitor {
            private final List<String> testMethodPatterns = new ArrayList<String>();

            public SpockFeatureMetadataAnnotationVisitor() {
                super(458752);
            }

            @Override
            public void visit(String string, Object object) {
                if ("name".equals(string)) {
                    this.testMethodPatterns.add((String)object);
                }
            }
        }
    }
}

