/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

@JacksonStdImpl
public class CollectionDeserializer
extends ContainerDeserializerBase<Collection<Object>>
implements ContextualDeserializer {
    protected final JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected final JsonDeserializer<Object> _delegateDeserializer;

    public CollectionDeserializer(JavaType javaType, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, ValueInstantiator valueInstantiator) {
        this(javaType, jsonDeserializer, typeDeserializer, valueInstantiator, null, null, null);
    }

    protected CollectionDeserializer(JavaType javaType, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, ValueInstantiator valueInstantiator, JsonDeserializer<Object> jsonDeserializer2, NullValueProvider nullValueProvider, Boolean bl2) {
        super(javaType, nullValueProvider, bl2);
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._valueInstantiator = valueInstantiator;
        this._delegateDeserializer = jsonDeserializer2;
    }

    protected CollectionDeserializer withResolved(JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, TypeDeserializer typeDeserializer, NullValueProvider nullValueProvider, Boolean bl2) {
        return new CollectionDeserializer(this._containerType, jsonDeserializer2, typeDeserializer, this._valueInstantiator, jsonDeserializer, nullValueProvider, bl2);
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._valueTypeDeserializer == null && this._delegateDeserializer == null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Collection;
    }

    public CollectionDeserializer createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        Serializable serializable;
        JsonDeserializer<Object> jsonDeserializer = null;
        if (this._valueInstantiator != null) {
            if (this._valueInstantiator.canCreateUsingDelegate()) {
                serializable = this._valueInstantiator.getDelegateType(deserializationContext.getConfig());
                if (serializable == null) {
                    deserializationContext.reportBadDefinition(this._containerType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingDelegate()', but null for 'getDelegateType()'", this._containerType, this._valueInstantiator.getClass().getName()));
                }
                jsonDeserializer = this.findDeserializer(deserializationContext, (JavaType)serializable, beanProperty);
            } else if (this._valueInstantiator.canCreateUsingArrayDelegate()) {
                serializable = this._valueInstantiator.getArrayDelegateType(deserializationContext.getConfig());
                if (serializable == null) {
                    deserializationContext.reportBadDefinition(this._containerType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingArrayDelegate()', but null for 'getArrayDelegateType()'", this._containerType, this._valueInstantiator.getClass().getName()));
                }
                jsonDeserializer = this.findDeserializer(deserializationContext, (JavaType)serializable, beanProperty);
            }
        }
        serializable = this.findFormatFeature(deserializationContext, beanProperty, Collection.class, JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        JsonDeserializer<Object> jsonDeserializer2 = this._valueDeserializer;
        jsonDeserializer2 = this.findConvertingContentDeserializer(deserializationContext, beanProperty, jsonDeserializer2);
        JavaType javaType = this._containerType.getContentType();
        jsonDeserializer2 = jsonDeserializer2 == null ? deserializationContext.findContextualValueDeserializer(javaType, beanProperty) : deserializationContext.handleSecondaryContextualization(jsonDeserializer2, beanProperty, javaType);
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        if (typeDeserializer != null) {
            typeDeserializer = typeDeserializer.forProperty(beanProperty);
        }
        NullValueProvider nullValueProvider = this.findContentNullProvider(deserializationContext, beanProperty, jsonDeserializer2);
        if (!Objects.equals(serializable, this._unwrapSingle) || nullValueProvider != this._nullProvider || jsonDeserializer != this._delegateDeserializer || jsonDeserializer2 != this._valueDeserializer || typeDeserializer != this._valueTypeDeserializer) {
            return this.withResolved(jsonDeserializer, jsonDeserializer2, typeDeserializer, nullValueProvider, (Boolean)serializable);
        }
        return this;
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public Collection<Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this._delegateDeserializer != null) {
            return (Collection)this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (jsonParser.isExpectedStartArrayToken()) {
            return this._deserializeFromArray(jsonParser, deserializationContext, this.createDefaultInstance(deserializationContext));
        }
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return this._deserializeFromString(jsonParser, deserializationContext, jsonParser.getText());
        }
        return this.handleNonArray(jsonParser, deserializationContext, this.createDefaultInstance(deserializationContext));
    }

    protected Collection<Object> createDefaultInstance(DeserializationContext deserializationContext) throws IOException {
        return (Collection)this._valueInstantiator.createUsingDefault(deserializationContext);
    }

    @Override
    public Collection<Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<Object> collection) throws IOException {
        if (jsonParser.isExpectedStartArrayToken()) {
            return this._deserializeFromArray(jsonParser, deserializationContext, collection);
        }
        return this.handleNonArray(jsonParser, deserializationContext, collection);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    protected Collection<Object> _deserializeFromString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        CoercionAction coercionAction;
        Class<?> clazz = this.handledType();
        if (string.isEmpty()) {
            CoercionAction coercionAction2 = deserializationContext.findCoercionAction(this.logicalType(), clazz, CoercionInputShape.EmptyString);
            if (coercionAction2 != null && coercionAction2 != CoercionAction.Fail) {
                return (Collection)this._deserializeFromEmptyString(jsonParser, deserializationContext, coercionAction2, clazz, "empty String (\"\")");
            }
        } else if (CollectionDeserializer._isBlank(string) && (coercionAction = deserializationContext.findCoercionFromBlankString(this.logicalType(), clazz, CoercionAction.Fail)) != CoercionAction.Fail) {
            return (Collection)this._deserializeFromEmptyString(jsonParser, deserializationContext, coercionAction, clazz, "blank String (all whitespace)");
        }
        return this.handleNonArray(jsonParser, deserializationContext, this.createDefaultInstance(deserializationContext));
    }

    protected Collection<Object> _deserializeFromArray(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<Object> collection) throws IOException {
        JsonToken jsonToken;
        jsonParser.setCurrentValue(collection);
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        if (jsonDeserializer.getObjectIdReader() != null) {
            return this._deserializeWithObjectId(jsonParser, deserializationContext, collection);
        }
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
            try {
                Object object;
                if (jsonToken == JsonToken.VALUE_NULL) {
                    if (this._skipNullValues) continue;
                    object = this._nullProvider.getNullValue(deserializationContext);
                } else {
                    object = typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
                }
                collection.add(object);
            }
            catch (Exception exception) {
                boolean bl2;
                boolean bl3 = bl2 = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
                if (!bl2) {
                    ClassUtil.throwIfRTE(exception);
                }
                throw JsonMappingException.wrapWithPath((Throwable)exception, collection, collection.size());
            }
        }
        return collection;
    }

    protected final Collection<Object> handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<Object> collection) throws IOException {
        Object object;
        boolean bl2;
        boolean bl3 = bl2 = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (!bl2) {
            return (Collection)deserializationContext.handleUnexpectedToken(this._containerType, jsonParser);
        }
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        try {
            if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                if (this._skipNullValues) {
                    return collection;
                }
                object = this._nullProvider.getNullValue(deserializationContext);
            } else {
                object = typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
            }
        }
        catch (Exception exception) {
            boolean bl4 = deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
            if (!bl4) {
                ClassUtil.throwIfRTE(exception);
            }
            throw JsonMappingException.wrapWithPath((Throwable)exception, Object.class, collection.size());
        }
        collection.add(object);
        return collection;
    }

    protected Collection<Object> _deserializeWithObjectId(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<Object> collection) throws IOException {
        JsonToken jsonToken;
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext, collection);
        }
        jsonParser.setCurrentValue(collection);
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        CollectionReferringAccumulator collectionReferringAccumulator = new CollectionReferringAccumulator(this._containerType.getContentType().getRawClass(), collection);
        while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
            try {
                Object object;
                if (jsonToken == JsonToken.VALUE_NULL) {
                    if (this._skipNullValues) continue;
                    object = this._nullProvider.getNullValue(deserializationContext);
                } else {
                    object = typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
                }
                collectionReferringAccumulator.add(object);
            }
            catch (UnresolvedForwardReference unresolvedForwardReference) {
                ReadableObjectId.Referring referring = collectionReferringAccumulator.handleUnresolvedReference(unresolvedForwardReference);
                unresolvedForwardReference.getRoid().appendReferring(referring);
            }
            catch (Exception exception) {
                boolean bl2;
                boolean bl3 = bl2 = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
                if (!bl2) {
                    ClassUtil.throwIfRTE(exception);
                }
                throw JsonMappingException.wrapWithPath((Throwable)exception, collection, collection.size());
            }
        }
        return collection;
    }

    private static final class CollectionReferring
    extends ReadableObjectId.Referring {
        private final CollectionReferringAccumulator _parent;
        public final List<Object> next = new ArrayList<Object>();

        CollectionReferring(CollectionReferringAccumulator collectionReferringAccumulator, UnresolvedForwardReference unresolvedForwardReference, Class<?> clazz) {
            super(unresolvedForwardReference, clazz);
            this._parent = collectionReferringAccumulator;
        }

        @Override
        public void handleResolvedForwardReference(Object object, Object object2) throws IOException {
            this._parent.resolveForwardReference(object, object2);
        }
    }

    public static class CollectionReferringAccumulator {
        private final Class<?> _elementType;
        private final Collection<Object> _result;
        private List<CollectionReferring> _accumulator = new ArrayList<CollectionReferring>();

        public CollectionReferringAccumulator(Class<?> clazz, Collection<Object> collection) {
            this._elementType = clazz;
            this._result = collection;
        }

        public void add(Object object) {
            if (this._accumulator.isEmpty()) {
                this._result.add(object);
            } else {
                CollectionReferring collectionReferring = this._accumulator.get(this._accumulator.size() - 1);
                collectionReferring.next.add(object);
            }
        }

        public ReadableObjectId.Referring handleUnresolvedReference(UnresolvedForwardReference unresolvedForwardReference) {
            CollectionReferring collectionReferring = new CollectionReferring(this, unresolvedForwardReference, this._elementType);
            this._accumulator.add(collectionReferring);
            return collectionReferring;
        }

        public void resolveForwardReference(Object object, Object object2) throws IOException {
            Iterator<CollectionReferring> iterator = this._accumulator.iterator();
            Collection<Object> collection = this._result;
            while (iterator.hasNext()) {
                CollectionReferring collectionReferring = iterator.next();
                if (collectionReferring.hasId(object)) {
                    iterator.remove();
                    collection.add(object2);
                    collection.addAll(collectionReferring.next);
                    return;
                }
                collection = collectionReferring.next;
            }
            throw new IllegalArgumentException("Trying to resolve a forward reference with id [" + object + "] that wasn't previously seen as unresolved.");
        }
    }
}

