/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.compressors.gzip;

import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.compressors.CompressorOutputStream;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.compressors.gzip.GzipParameters;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.compressors.gzip.GzipUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class GzipCompressorOutputStream
extends CompressorOutputStream {
    private final OutputStream out;
    private final Deflater deflater;
    private final byte[] deflateBuffer;
    private boolean closed;
    private final CRC32 crc = new CRC32();

    public GzipCompressorOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, new GzipParameters());
    }

    public GzipCompressorOutputStream(OutputStream outputStream, GzipParameters gzipParameters) throws IOException {
        this.out = outputStream;
        this.deflater = new Deflater(gzipParameters.getCompressionLevel(), true);
        this.deflater.setStrategy(gzipParameters.getDeflateStrategy());
        this.deflateBuffer = new byte[gzipParameters.getBufferSize()];
        this.writeHeader(gzipParameters);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.finish();
            }
            finally {
                this.deflater.end();
                this.out.close();
                this.closed = true;
            }
        }
    }

    private void deflate() throws IOException {
        int n2 = this.deflater.deflate(this.deflateBuffer, 0, this.deflateBuffer.length);
        if (n2 > 0) {
            this.out.write(this.deflateBuffer, 0, n2);
        }
    }

    public void finish() throws IOException {
        if (!this.deflater.finished()) {
            this.deflater.finish();
            while (!this.deflater.finished()) {
                this.deflate();
            }
            this.writeTrailer();
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    private byte[] getBytes(String string) throws IOException {
        if (GzipUtils.GZIP_ENCODING.newEncoder().canEncode(string)) {
            return string.getBytes(GzipUtils.GZIP_ENCODING);
        }
        try {
            return new URI(null, null, string, null).toASCIIString().getBytes(StandardCharsets.US_ASCII);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException(string, uRISyntaxException);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (this.deflater.finished()) {
            throw new IOException("Cannot write more data, the end of the compressed data stream has been reached");
        }
        if (n3 > 0) {
            this.deflater.setInput(byArray, n2, n3);
            while (!this.deflater.needsInput()) {
                this.deflate();
            }
            this.crc.update(byArray, n2, n3);
        }
    }

    @Override
    public void write(int n2) throws IOException {
        this.write(new byte[]{(byte)(n2 & 0xFF)}, 0, 1);
    }

    private void writeHeader(GzipParameters gzipParameters) throws IOException {
        String string = gzipParameters.getFilename();
        String string2 = gzipParameters.getComment();
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putShort((short)-29921);
        byteBuffer.put((byte)8);
        byteBuffer.put((byte)((string != null ? 8 : 0) | (string2 != null ? 16 : 0)));
        byteBuffer.putInt((int)(gzipParameters.getModificationTime() / 1000L));
        int n2 = gzipParameters.getCompressionLevel();
        if (n2 == 9) {
            byteBuffer.put((byte)2);
        } else if (n2 == 1) {
            byteBuffer.put((byte)4);
        } else {
            byteBuffer.put((byte)0);
        }
        byteBuffer.put((byte)gzipParameters.getOperatingSystem());
        this.out.write(byteBuffer.array());
        if (string != null) {
            this.out.write(this.getBytes(string));
            this.out.write(0);
        }
        if (string2 != null) {
            this.out.write(this.getBytes(string2));
            this.out.write(0);
        }
    }

    private void writeTrailer() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt((int)this.crc.getValue());
        byteBuffer.putInt(this.deflater.getTotalIn());
        this.out.write(byteBuffer.array());
    }
}

