/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.client.protocol;

import com.gradle.scan.plugin.internal.dep.org.apache.commons.logging.Log;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.logging.LogFactory;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpException;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpHost;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpRequest;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpRequestInterceptor;
import com.gradle.scan.plugin.internal.dep.org.apache.http.auth.AuthProtocolState;
import com.gradle.scan.plugin.internal.dep.org.apache.http.auth.AuthScheme;
import com.gradle.scan.plugin.internal.dep.org.apache.http.auth.AuthScope;
import com.gradle.scan.plugin.internal.dep.org.apache.http.auth.AuthState;
import com.gradle.scan.plugin.internal.dep.org.apache.http.auth.Credentials;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.AuthCache;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.CredentialsProvider;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.protocol.HttpClientContext;
import com.gradle.scan.plugin.internal.dep.org.apache.http.conn.routing.RouteInfo;
import com.gradle.scan.plugin.internal.dep.org.apache.http.protocol.HttpContext;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Args;
import java.io.IOException;

public class RequestAuthCache
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        AuthScheme authScheme;
        Object object;
        AuthState authState;
        Args.notNull(httpRequest, "HTTP request");
        Args.notNull(httpContext, "HTTP context");
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        AuthCache authCache = httpClientContext.getAuthCache();
        if (authCache == null) {
            this.log.debug("Auth cache not set in the context");
            return;
        }
        CredentialsProvider credentialsProvider = httpClientContext.getCredentialsProvider();
        if (credentialsProvider == null) {
            this.log.debug("Credentials provider not set in the context");
            return;
        }
        RouteInfo routeInfo = httpClientContext.getHttpRoute();
        if (routeInfo == null) {
            this.log.debug("Route info not set in the context");
            return;
        }
        HttpHost httpHost = httpClientContext.getTargetHost();
        if (httpHost == null) {
            this.log.debug("Target host not set in the context");
            return;
        }
        if (httpHost.getPort() < 0) {
            httpHost = new HttpHost(httpHost.getHostName(), routeInfo.getTargetHost().getPort(), httpHost.getSchemeName());
        }
        if ((authState = httpClientContext.getTargetAuthState()) != null && authState.getState() == AuthProtocolState.UNCHALLENGED && (object = authCache.get(httpHost)) != null) {
            this.doPreemptiveAuth(httpHost, (AuthScheme)object, authState, credentialsProvider);
        }
        object = routeInfo.getProxyHost();
        AuthState authState2 = httpClientContext.getProxyAuthState();
        if (object != null && authState2 != null && authState2.getState() == AuthProtocolState.UNCHALLENGED && (authScheme = authCache.get((HttpHost)object)) != null) {
            this.doPreemptiveAuth((HttpHost)object, authScheme, authState2, credentialsProvider);
        }
    }

    private void doPreemptiveAuth(HttpHost httpHost, AuthScheme authScheme, AuthState authState, CredentialsProvider credentialsProvider) {
        AuthScope authScope;
        Credentials credentials;
        String string = authScheme.getSchemeName();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Re-using cached '" + string + "' auth scheme for " + httpHost);
        }
        if ((credentials = credentialsProvider.getCredentials(authScope = new AuthScope(httpHost, AuthScope.ANY_REALM, string))) != null) {
            authState.update(authScheme, credentials);
        } else {
            this.log.debug("No credentials for preemptive authentication");
        }
    }
}

