/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.impl.io;

import com.gradle.scan.plugin.internal.dep.org.apache.http.Header;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpException;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpMessage;
import com.gradle.scan.plugin.internal.dep.org.apache.http.MessageConstraintException;
import com.gradle.scan.plugin.internal.dep.org.apache.http.ParseException;
import com.gradle.scan.plugin.internal.dep.org.apache.http.ProtocolException;
import com.gradle.scan.plugin.internal.dep.org.apache.http.config.MessageConstraints;
import com.gradle.scan.plugin.internal.dep.org.apache.http.io.HttpMessageParser;
import com.gradle.scan.plugin.internal.dep.org.apache.http.io.SessionInputBuffer;
import com.gradle.scan.plugin.internal.dep.org.apache.http.message.BasicLineParser;
import com.gradle.scan.plugin.internal.dep.org.apache.http.message.LineParser;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Args;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.CharArrayBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMessageParser<T extends HttpMessage>
implements HttpMessageParser<T> {
    private final SessionInputBuffer sessionBuffer;
    private final MessageConstraints messageConstraints;
    private final List<CharArrayBuffer> headerLines;
    protected final LineParser lineParser;
    private int state;
    private T message;

    public AbstractMessageParser(SessionInputBuffer sessionInputBuffer, LineParser lineParser, MessageConstraints messageConstraints) {
        this.sessionBuffer = Args.notNull(sessionInputBuffer, "Session input buffer");
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.messageConstraints = messageConstraints != null ? messageConstraints : MessageConstraints.DEFAULT;
        this.headerLines = new ArrayList<CharArrayBuffer>();
        this.state = 0;
    }

    public static Header[] parseHeaders(SessionInputBuffer sessionInputBuffer, int n2, int n3, LineParser lineParser) throws HttpException, IOException {
        ArrayList<CharArrayBuffer> arrayList = new ArrayList<CharArrayBuffer>();
        return AbstractMessageParser.parseHeaders(sessionInputBuffer, n2, n3, lineParser != null ? lineParser : BasicLineParser.INSTANCE, arrayList);
    }

    public static Header[] parseHeaders(SessionInputBuffer sessionInputBuffer, int n2, int n3, LineParser lineParser, List<CharArrayBuffer> list) throws HttpException, IOException {
        int n4;
        block9: {
            Args.notNull(sessionInputBuffer, "Session input buffer");
            Args.notNull(lineParser, "Line parser");
            Args.notNull(list, "Header line list");
            CharArrayBuffer charArrayBuffer = null;
            CharArrayBuffer charArrayBuffer2 = null;
            do {
                if (charArrayBuffer == null) {
                    charArrayBuffer = new CharArrayBuffer(64);
                } else {
                    charArrayBuffer.clear();
                }
                int n5 = sessionInputBuffer.readLine(charArrayBuffer);
                if (n5 == -1 || charArrayBuffer.length() < 1) break block9;
                if ((charArrayBuffer.charAt(0) == ' ' || charArrayBuffer.charAt(0) == '\t') && charArrayBuffer2 != null) {
                    char c2;
                    for (n4 = 0; n4 < charArrayBuffer.length() && ((c2 = charArrayBuffer.charAt(n4)) == ' ' || c2 == '\t'); ++n4) {
                    }
                    if (n3 > 0 && charArrayBuffer2.length() + 1 + charArrayBuffer.length() - n4 > n3) {
                        throw new MessageConstraintException("Maximum line length limit exceeded");
                    }
                    charArrayBuffer2.append(' ');
                    charArrayBuffer2.append(charArrayBuffer, n4, charArrayBuffer.length() - n4);
                    continue;
                }
                list.add(charArrayBuffer);
                charArrayBuffer2 = charArrayBuffer;
                charArrayBuffer = null;
            } while (n2 <= 0 || list.size() < n2);
            throw new MessageConstraintException("Maximum header count exceeded");
        }
        Header[] headerArray = new Header[list.size()];
        for (n4 = 0; n4 < list.size(); ++n4) {
            CharArrayBuffer charArrayBuffer = list.get(n4);
            try {
                headerArray[n4] = lineParser.parseHeader(charArrayBuffer);
                continue;
            }
            catch (ParseException parseException) {
                throw new ProtocolException(parseException.getMessage());
            }
        }
        return headerArray;
    }

    protected abstract T parseHead(SessionInputBuffer var1) throws IOException, HttpException, ParseException;

    @Override
    public T parse() throws IOException, HttpException {
        int n2 = this.state;
        switch (n2) {
            case 0: {
                try {
                    this.message = this.parseHead(this.sessionBuffer);
                }
                catch (ParseException parseException) {
                    throw new ProtocolException(parseException.getMessage(), parseException);
                }
                this.state = 1;
            }
            case 1: {
                Header[] headerArray = AbstractMessageParser.parseHeaders(this.sessionBuffer, this.messageConstraints.getMaxHeaderCount(), this.messageConstraints.getMaxLineLength(), this.lineParser, this.headerLines);
                this.message.setHeaders(headerArray);
                T t2 = this.message;
                this.message = null;
                this.headerLines.clear();
                this.state = 0;
                return t2;
            }
        }
        throw new IllegalStateException("Inconsistent parser state");
    }
}

