/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.AsyncContentProvider;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpChannel;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpContent;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpConversation;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpDestination;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpExchange;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpRequest;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpRequestException;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.RequestNotifier;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.ContentProvider;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Request;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Result;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpHeaderValue;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Callback;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.IteratingCallback;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;

public abstract class HttpSender
implements AsyncContentProvider.Listener {
    protected static final Logger LOG = Log.getLogger(HttpSender.class);
    private final AtomicReference<RequestState> requestState = new AtomicReference<RequestState>(RequestState.QUEUED);
    private final AtomicReference<SenderState> senderState = new AtomicReference<SenderState>(SenderState.IDLE);
    private final Callback commitCallback = new CommitCallback();
    private final IteratingCallback contentCallback = new ContentCallback();
    private final Callback lastCallback = new LastCallback();
    private final HttpChannel channel;
    private HttpContent content;
    private Throwable failure;

    protected HttpSender(HttpChannel httpChannel) {
        this.channel = httpChannel;
    }

    protected HttpChannel getHttpChannel() {
        return this.channel;
    }

    protected HttpExchange getHttpExchange() {
        return this.channel.getHttpExchange();
    }

    public void send(HttpExchange httpExchange) {
        if (!this.queuedToBegin(httpExchange)) {
            return;
        }
        HttpRequest httpRequest = httpExchange.getRequest();
        ContentProvider contentProvider = httpRequest.getContent();
        HttpContent httpContent = this.content = new HttpContent(contentProvider);
        SenderState senderState = SenderState.SENDING;
        if (this.expects100Continue(httpRequest)) {
            senderState = httpContent.hasContent() ? SenderState.EXPECTING_WITH_CONTENT : SenderState.EXPECTING;
        }
        block3: while (true) {
            SenderState senderState2 = this.senderState.get();
            switch (senderState2) {
                case IDLE: 
                case COMPLETED: {
                    if (!this.updateSenderState(senderState2, senderState)) continue block3;
                    break block3;
                }
                default: {
                    this.illegalSenderState(senderState2);
                    return;
                }
            }
            break;
        }
        if (contentProvider instanceof AsyncContentProvider) {
            ((AsyncContentProvider)contentProvider).setListener(this);
        }
        if (!this.beginToHeaders(httpExchange)) {
            return;
        }
        this.sendHeaders(httpExchange, httpContent, this.commitCallback);
    }

    protected boolean expects100Continue(Request request) {
        return request.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
    }

    protected boolean queuedToBegin(HttpExchange httpExchange) {
        if (!this.updateRequestState(RequestState.QUEUED, RequestState.TRANSIENT)) {
            return false;
        }
        HttpRequest httpRequest = httpExchange.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request begin {}", httpRequest);
        }
        RequestNotifier requestNotifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        requestNotifier.notifyBegin(httpRequest);
        if (this.updateRequestState(RequestState.TRANSIENT, RequestState.BEGIN)) {
            return true;
        }
        this.terminateRequest(httpExchange);
        return false;
    }

    protected boolean beginToHeaders(HttpExchange httpExchange) {
        if (!this.updateRequestState(RequestState.BEGIN, RequestState.TRANSIENT)) {
            return false;
        }
        HttpRequest httpRequest = httpExchange.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request headers {}{}{}", httpRequest, System.lineSeparator(), httpRequest.getHeaders().toString().trim());
        }
        RequestNotifier requestNotifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        requestNotifier.notifyHeaders(httpRequest);
        if (this.updateRequestState(RequestState.TRANSIENT, RequestState.HEADERS)) {
            return true;
        }
        this.terminateRequest(httpExchange);
        return false;
    }

    protected boolean headersToCommit(HttpExchange httpExchange) {
        if (!this.updateRequestState(RequestState.HEADERS, RequestState.TRANSIENT)) {
            return false;
        }
        HttpRequest httpRequest = httpExchange.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request committed {}", httpRequest);
        }
        RequestNotifier requestNotifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        requestNotifier.notifyCommit(httpRequest);
        if (this.updateRequestState(RequestState.TRANSIENT, RequestState.COMMIT)) {
            return true;
        }
        this.terminateRequest(httpExchange);
        return false;
    }

    protected boolean someToContent(HttpExchange httpExchange, ByteBuffer byteBuffer) {
        RequestState requestState = this.requestState.get();
        switch (requestState) {
            case COMMIT: 
            case CONTENT: {
                if (!this.updateRequestState(requestState, RequestState.TRANSIENT)) {
                    return false;
                }
                HttpRequest httpRequest = httpExchange.getRequest();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request content {}{}{}", httpRequest, System.lineSeparator(), BufferUtil.toDetailString(byteBuffer));
                }
                RequestNotifier requestNotifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
                requestNotifier.notifyContent(httpRequest, byteBuffer);
                if (this.updateRequestState(RequestState.TRANSIENT, RequestState.CONTENT)) {
                    return true;
                }
                this.terminateRequest(httpExchange);
                return false;
            }
        }
        return false;
    }

    protected boolean someToSuccess(HttpExchange httpExchange) {
        RequestState requestState = this.requestState.get();
        switch (requestState) {
            case COMMIT: 
            case CONTENT: {
                if (!httpExchange.requestComplete(null)) {
                    return false;
                }
                this.requestState.set(RequestState.QUEUED);
                this.reset();
                HttpRequest httpRequest = httpExchange.getRequest();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request success {}", httpRequest);
                }
                HttpDestination httpDestination = this.getHttpChannel().getHttpDestination();
                httpDestination.getRequestNotifier().notifySuccess(httpExchange.getRequest());
                Result result = httpExchange.terminateRequest();
                this.terminateRequest(httpExchange, null, result);
                return true;
            }
        }
        return false;
    }

    private void anyToFailure(Throwable throwable) {
        HttpExchange httpExchange = this.getHttpExchange();
        if (httpExchange == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request failure " + httpExchange.getRequest(), throwable);
        }
        if (httpExchange.requestComplete(throwable)) {
            this.executeAbort(httpExchange, throwable);
        }
    }

    private void executeAbort(HttpExchange httpExchange, Throwable throwable) {
        try {
            Executor executor = this.getHttpChannel().getHttpDestination().getHttpClient().getExecutor();
            executor.execute(() -> this.abort(httpExchange, throwable));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(rejectedExecutionException);
            }
            this.abort(httpExchange, throwable);
        }
    }

    private void terminateRequest(HttpExchange httpExchange) {
        Throwable throwable = this.failure;
        if (throwable == null) {
            throwable = new HttpRequestException("Concurrent failure", httpExchange.getRequest());
        }
        Result result = httpExchange.terminateRequest();
        this.terminateRequest(httpExchange, throwable, result);
    }

    private void terminateRequest(HttpExchange httpExchange, Throwable throwable, Result result) {
        HttpRequest httpRequest = httpExchange.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Terminating request {}", httpRequest);
        }
        if (result == null) {
            if (throwable != null && httpExchange.responseComplete(throwable)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response failure from request {} {}", httpRequest, httpExchange);
                }
                this.getHttpChannel().abortResponse(httpExchange, throwable);
            }
        } else {
            result = this.channel.exchangeTerminating(httpExchange, result);
            HttpDestination httpDestination = this.getHttpChannel().getHttpDestination();
            boolean bl2 = httpDestination.getHttpClient().isStrictEventOrdering();
            if (!bl2) {
                this.channel.exchangeTerminated(httpExchange, result);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request/Response {}: {}", throwable == null ? "succeeded" : "failed", result);
            }
            HttpConversation httpConversation = httpExchange.getConversation();
            httpDestination.getResponseNotifier().notifyComplete(httpConversation.getResponseListeners(), result);
            if (bl2) {
                this.channel.exchangeTerminated(httpExchange, result);
            }
        }
    }

    protected abstract void sendHeaders(HttpExchange var1, HttpContent var2, Callback var3);

    protected abstract void sendContent(HttpExchange var1, HttpContent var2, Callback var3);

    protected void reset() {
        HttpContent httpContent = this.content;
        this.content = null;
        httpContent.close();
        this.senderState.set(SenderState.COMPLETED);
    }

    protected void dispose() {
        HttpContent httpContent = this.content;
        this.content = null;
        if (httpContent != null) {
            httpContent.close();
        }
        this.senderState.set(SenderState.FAILED);
    }

    /*
     * Unable to fully structure code
     */
    public void proceed(HttpExchange var1_1, Throwable var2_2) {
        if (!this.expects100Continue(var1_1.getRequest())) {
            return;
        }
        if (var2_2 != null) {
            this.anyToFailure(var2_2);
            return;
        }
        block6: while (true) {
            var3_3 = this.senderState.get();
            switch (1.$SwitchMap$org$eclipse$jetty$client$HttpSender$SenderState[var3_3.ordinal()]) {
                case 3: {
                    if (!this.updateSenderState(var3_3, SenderState.PROCEEDING)) continue block6;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Proceeding while expecting", new Object[0]);
                    }
                    return;
                }
                case 6: {
                    if (!this.updateSenderState(var3_3, SenderState.PROCEEDING_WITH_CONTENT)) continue block6;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Proceeding while scheduled", new Object[0]);
                    }
                    return;
                }
                case 8: {
                    if (this.updateSenderState(var3_3, SenderState.SENDING)) ** break;
                    continue block6;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Proceeding while waiting", new Object[0]);
                    }
                    this.contentCallback.iterate();
                    return;
                }
                case 10: {
                    return;
                }
            }
            break;
        }
        this.illegalSenderState(var3_3);
    }

    public boolean abort(HttpExchange httpExchange, Throwable throwable) {
        Object object;
        do {
            object = this.requestState.get();
            switch (object) {
                case FAILURE: {
                    return false;
                }
            }
        } while (!this.updateRequestState((RequestState)((Object)object), RequestState.FAILURE));
        boolean bl2 = object != RequestState.TRANSIENT;
        this.failure = throwable;
        this.dispose();
        object = httpExchange.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request abort {} {} on {}: {}", object, httpExchange, this.getHttpChannel(), throwable);
        }
        HttpDestination httpDestination = this.getHttpChannel().getHttpDestination();
        httpDestination.getRequestNotifier().notifyFailure((Request)object, throwable);
        if (bl2) {
            Result result = httpExchange.terminateRequest();
            this.terminateRequest(httpExchange, throwable, result);
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Concurrent failure: request termination skipped, performed by helpers", new Object[0]);
        }
        return false;
    }

    private boolean updateRequestState(RequestState requestState, RequestState requestState2) {
        boolean bl2 = this.requestState.compareAndSet(requestState, requestState2);
        if (!bl2 && LOG.isDebugEnabled()) {
            LOG.debug("RequestState update failed: {} -> {}: {}", new Object[]{requestState, requestState2, this.requestState.get()});
        }
        return bl2;
    }

    private boolean updateSenderState(SenderState senderState, SenderState senderState2) {
        boolean bl2 = this.senderState.compareAndSet(senderState, senderState2);
        if (!bl2 && LOG.isDebugEnabled()) {
            LOG.debug("SenderState update failed: {} -> {}: {}", new Object[]{senderState, senderState2, this.senderState.get()});
        }
        return bl2;
    }

    private void illegalSenderState(SenderState senderState) {
        this.anyToFailure(new IllegalStateException("Expected " + (Object)((Object)senderState) + " found " + (Object)((Object)this.senderState.get()) + " instead"));
    }

    public String toString() {
        return String.format("%s@%x(req=%s,snd=%s,failure=%s)", this.getClass().getSimpleName(), this.hashCode(), this.requestState, this.senderState, this.failure);
    }

    private class LastCallback
    implements Callback {
        private LastCallback() {
        }

        @Override
        public void succeeded() {
            HttpExchange httpExchange = HttpSender.this.getHttpExchange();
            if (httpExchange == null) {
                return;
            }
            HttpContent httpContent = HttpSender.this.content;
            if (httpContent == null) {
                return;
            }
            httpContent.succeeded();
            HttpSender.this.someToSuccess(httpExchange);
        }

        @Override
        public void failed(Throwable throwable) {
            HttpContent httpContent = HttpSender.this.content;
            if (httpContent == null) {
                return;
            }
            httpContent.failed(throwable);
            HttpSender.this.anyToFailure(throwable);
        }
    }

    private class ContentCallback
    extends IteratingCallback {
        private ContentCallback() {
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            SenderState senderState;
            HttpExchange httpExchange = HttpSender.this.getHttpExchange();
            if (httpExchange == null) {
                return IteratingCallback.Action.IDLE;
            }
            HttpContent httpContent = HttpSender.this.content;
            if (httpContent == null) {
                return IteratingCallback.Action.IDLE;
            }
            block4: while (true) {
                boolean bl2 = httpContent.advance();
                boolean bl3 = httpContent.isLast();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content present {}, last {}, consumed {} for {}", bl2, bl3, httpContent.isConsumed(), httpExchange.getRequest());
                }
                if (bl2) {
                    HttpSender.this.sendContent(httpExchange, httpContent, this);
                    return IteratingCallback.Action.SCHEDULED;
                }
                if (bl3) {
                    HttpSender.this.sendContent(httpExchange, httpContent, HttpSender.this.lastCallback);
                    return IteratingCallback.Action.IDLE;
                }
                senderState = (SenderState)((Object)HttpSender.this.senderState.get());
                switch (senderState) {
                    case SENDING: {
                        if (!HttpSender.this.updateSenderState(senderState, SenderState.IDLE)) continue block4;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Content is deferred for {}", httpExchange.getRequest());
                        }
                        return IteratingCallback.Action.IDLE;
                    }
                    case SENDING_WITH_CONTENT: {
                        HttpSender.this.updateSenderState(senderState, SenderState.SENDING);
                        continue block4;
                    }
                }
                break;
            }
            HttpSender.this.illegalSenderState(senderState);
            return IteratingCallback.Action.IDLE;
        }

        @Override
        public void succeeded() {
            HttpExchange httpExchange = HttpSender.this.getHttpExchange();
            if (httpExchange == null) {
                return;
            }
            HttpContent httpContent = HttpSender.this.content;
            if (httpContent == null) {
                return;
            }
            httpContent.succeeded();
            ByteBuffer byteBuffer = httpContent.getContent();
            HttpSender.this.someToContent(httpExchange, byteBuffer);
            super.succeeded();
        }

        @Override
        public void onCompleteFailure(Throwable throwable) {
            HttpContent httpContent = HttpSender.this.content;
            if (httpContent == null) {
                return;
            }
            httpContent.failed(throwable);
            HttpSender.this.anyToFailure(throwable);
        }

        @Override
        protected void onCompleteSuccess() {
        }
    }

    private class CommitCallback
    implements Callback {
        private CommitCallback() {
        }

        @Override
        public void succeeded() {
            try {
                HttpContent httpContent = HttpSender.this.content;
                if (httpContent == null) {
                    return;
                }
                httpContent.succeeded();
                this.process();
            }
            catch (Throwable throwable) {
                HttpSender.this.anyToFailure(throwable);
            }
        }

        @Override
        public void failed(Throwable throwable) {
            HttpContent httpContent = HttpSender.this.content;
            if (httpContent == null) {
                return;
            }
            httpContent.failed(throwable);
            HttpSender.this.anyToFailure(throwable);
        }

        private void process() throws Exception {
            HttpExchange httpExchange = HttpSender.this.getHttpExchange();
            if (httpExchange == null) {
                return;
            }
            if (!HttpSender.this.headersToCommit(httpExchange)) {
                return;
            }
            HttpContent httpContent = HttpSender.this.content;
            if (httpContent == null) {
                return;
            }
            if (httpContent.hasContent()) {
                SenderState senderState;
                ByteBuffer byteBuffer = httpContent.getContent();
                if (byteBuffer != null && !HttpSender.this.someToContent(httpExchange, byteBuffer)) {
                    return;
                }
                block9: while (true) {
                    senderState = (SenderState)((Object)HttpSender.this.senderState.get());
                    switch (senderState) {
                        case SENDING: {
                            HttpSender.this.contentCallback.iterate();
                            return;
                        }
                        case SENDING_WITH_CONTENT: {
                            HttpSender.this.updateSenderState(senderState, SenderState.SENDING);
                            continue block9;
                        }
                        case EXPECTING: {
                            if (!HttpSender.this.updateSenderState(senderState, SenderState.WAITING)) continue block9;
                            return;
                        }
                        case EXPECTING_WITH_CONTENT: {
                            if (!HttpSender.this.updateSenderState(senderState, SenderState.WAITING)) continue block9;
                            return;
                        }
                        case PROCEEDING: {
                            if (!HttpSender.this.updateSenderState(senderState, SenderState.IDLE)) continue block9;
                            return;
                        }
                        case PROCEEDING_WITH_CONTENT: {
                            HttpSender.this.updateSenderState(senderState, SenderState.SENDING);
                            continue block9;
                        }
                        case FAILED: {
                            return;
                        }
                    }
                    break;
                }
                HttpSender.this.illegalSenderState(senderState);
                return;
            }
            HttpSender.this.someToSuccess(httpExchange);
        }
    }

    private static enum SenderState {
        IDLE,
        SENDING,
        SENDING_WITH_CONTENT,
        EXPECTING,
        EXPECTING_WITH_CONTENT,
        WAITING,
        PROCEEDING,
        PROCEEDING_WITH_CONTENT,
        COMPLETED,
        FAILED;

    }

    private static enum RequestState {
        TRANSIENT,
        QUEUED,
        BEGIN,
        HEADERS,
        COMMIT,
        CONTENT,
        FAILURE;

    }
}

