/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.TypeUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class Utf8Appendable {
    protected static final Logger LOG = Log.getLogger(Utf8Appendable.class);
    public static final byte[] REPLACEMENT_UTF8 = new byte[]{-17, -65, -67};
    protected final Appendable _appendable;
    protected int _state = 0;
    private static final byte[] BYTE_TABLE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 11, 6, 6, 6, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final byte[] TRANS_TABLE = new byte[]{0, 12, 24, 36, 60, 96, 84, 12, 12, 12, 48, 72, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 0, 12, 12, 12, 12, 12, 0, 12, 0, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    private int _codep;

    public Utf8Appendable(Appendable appendable) {
        this._appendable = appendable;
    }

    protected void reset() {
        this._state = 0;
    }

    private void checkCharAppend() throws IOException {
        if (this._state != 0) {
            this._appendable.append('\ufffd');
            int n2 = this._state;
            this._state = 0;
            throw new NotUtf8Exception("char appended in state " + n2);
        }
    }

    public void append(char c2) {
        try {
            this.checkCharAppend();
            this._appendable.append(c2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void append(String string, int n2, int n3) {
        try {
            this.checkCharAppend();
            this._appendable.append(string, n2, n2 + n3);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void append(byte by2) {
        try {
            this.appendByte(by2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void append(ByteBuffer byteBuffer) {
        try {
            while (byteBuffer.remaining() > 0) {
                this.appendByte(byteBuffer.get());
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void append(byte[] byArray, int n2, int n3) {
        try {
            int n4 = n2 + n3;
            for (int i2 = n2; i2 < n4; ++i2) {
                this.appendByte(byArray[i2]);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected void appendByte(byte by2) throws IOException {
        if (by2 > 0 && this._state == 0) {
            this._appendable.append((char)(by2 & 0xFF));
        } else {
            int n2 = by2 & 0xFF;
            byte by3 = BYTE_TABLE[n2];
            this._codep = this._state == 0 ? 255 >> by3 & n2 : n2 & 0x3F | this._codep << 6;
            int n3 = TRANS_TABLE[this._state + by3];
            switch (n3) {
                case 0: {
                    this._state = n3;
                    if (this._codep < 55296) {
                        this._appendable.append((char)this._codep);
                        break;
                    }
                    for (char c2 : Character.toChars(this._codep)) {
                        this._appendable.append(c2);
                    }
                    break;
                }
                case 12: {
                    String string = "byte " + TypeUtil.toHexString(by2) + " in state " + this._state / 12;
                    this._codep = 0;
                    this._state = 0;
                    this._appendable.append('\ufffd');
                    throw new NotUtf8Exception(string);
                }
                default: {
                    this._state = n3;
                }
            }
        }
    }

    public boolean isUtf8SequenceComplete() {
        return this._state == 0;
    }

    protected void checkState() {
        if (!this.isUtf8SequenceComplete()) {
            this._codep = 0;
            this._state = 0;
            try {
                this._appendable.append('\ufffd');
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            throw new NotUtf8Exception("incomplete UTF8 sequence");
        }
    }

    public abstract String getPartialString();

    public String takePartialString() {
        String string = this.getPartialString();
        int n2 = this._state;
        this.reset();
        this._state = n2;
        return string;
    }

    public String toReplacedString() {
        if (!this.isUtf8SequenceComplete()) {
            this._codep = 0;
            this._state = 0;
            try {
                this._appendable.append('\ufffd');
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            NotUtf8Exception notUtf8Exception = new NotUtf8Exception("incomplete UTF8 sequence");
            LOG.warn(notUtf8Exception.toString(), new Object[0]);
            LOG.debug(notUtf8Exception);
        }
        return this._appendable.toString();
    }

    public static class NotUtf8Exception
    extends IllegalArgumentException {
        public NotUtf8Exception(String string) {
            super("Not valid UTF8! " + string);
        }
    }
}

