/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.statistic;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;

public class SampleStatistic {
    private final LongAccumulator _max = new LongAccumulator(Math::max, 0L);
    private final AtomicLong _total = new AtomicLong();
    private final AtomicLong _count = new AtomicLong();
    private final LongAdder _totalVariance100 = new LongAdder();

    public void record(long l2) {
        long l3 = this._total.addAndGet(l2);
        long l4 = this._count.incrementAndGet();
        if (l4 > 1L) {
            long l5 = l3 * 10L / l4;
            long l6 = l2 * 10L - l5;
            this._totalVariance100.add(l6 * l6);
        }
        this._max.accumulate(l2);
    }

    public long getMax() {
        return this._max.get();
    }

    public long getTotal() {
        return this._total.get();
    }

    public long getCount() {
        return this._count.get();
    }

    public double getVariance() {
        long l2 = this._totalVariance100.sum();
        long l3 = this.getCount();
        return l3 > 1L ? (double)l2 / 100.0 / (double)(l3 - 1L) : 0.0;
    }

    public double getStdDev() {
        return Math.sqrt(this.getVariance());
    }

    public String toString() {
        return String.format("%s@%x{count=%d,mean=%d,total=%d,stddev=%f}", this.getClass().getSimpleName(), this.hashCode(), this.getCount(), this.getMax(), this.getTotal(), this.getStdDev());
    }
}

