/*
 * Copyright 2022 Netflix, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.netflix.gradle.jakartaee.specifications

import com.netflix.gradle.jakartaee.artifacts.ArtifactCoordinate
import com.netflix.gradle.jakartaee.artifacts.ArtifactVersion

internal class Cdi : BasicSpecification(
    JAVAX,
    JAKARTA,
    SPECIFICATION_TO_CDI_VERSION
) {
    companion object {
        private val JAVAX = ArtifactCoordinate("javax.enterprise", "cdi-api") // 1.0 through 2.0
        private val JAKARTA_ORPHANED = ArtifactCoordinate("jakarta.enterprise", "cdi-api") // 3.0.0-M3
        private val JAKARTA = ArtifactCoordinate("jakarta.enterprise", "jakarta.enterprise.cdi-api") // 2.0.1 and later

        private val SPECIFICATION_TO_CDI_VERSION = mapOf(
            SpecificationVersion.EE7 to ArtifactVersion("1.1"),
            SpecificationVersion.EE8 to ArtifactVersion("2.0"),
            SpecificationVersion.EE9 to ArtifactVersion("3.0"),
            SpecificationVersion.EE9_1 to ArtifactVersion("3.0"),
            SpecificationVersion.EE10 to ArtifactVersion("4.0"),
        )
    }

    override val name: String
        get() = "enterprise.cdi-api"

    override val coordinates: List<ArtifactCoordinate>
        get() = listOf(
            JAVAX,
            JAKARTA_ORPHANED,
            JAKARTA,
        )
}
