/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.gradle.jakartaee;

import com.netflix.gradle.jakartaee.artifacts.ArtifactCoordinate;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.tomcat.jakartaee.EESpecProfile;
import org.apache.tomcat.jakartaee.EESpecProfiles;
import org.apache.tomcat.jakartaee.Migration;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisableCachingByDefault(because="Transform is fast enough not to benefit from caching")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b!\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0012\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH'J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/netflix/gradle/jakartaee/JakartaEeMigrationTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/netflix/gradle/jakartaee/JakartaEeMigrationTransform$Parameters;", "()V", "excludedPaths", "", "", "getExcludedPaths", "()Ljava/util/List;", "excludedPaths$delegate", "Lkotlin/Lazy;", "getInputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "transform", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "Companion", "Parameters", "TransformHandler", "gradle-jakartaee-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJakartaEeMigrationTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JakartaEeMigrationTransform.kt\ncom/netflix/gradle/jakartaee/JakartaEeMigrationTransform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1747#2,3:137\n*S KotlinDebug\n*F\n+ 1 JakartaEeMigrationTransform.kt\ncom/netflix/gradle/jakartaee/JakartaEeMigrationTransform\n*L\n91#1:137,3\n*E\n"})
public abstract class JakartaEeMigrationTransform
implements TransformAction<Parameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy excludedPaths$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends String>>(this){
        final /* synthetic */ JakartaEeMigrationTransform this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> invoke() {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = ((Parameters)this.this$0.getParameters()).getExcludedArtifacts();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList<E>();
            boolean $i$f$flatMapTo = false;
            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                ArtifactCoordinate it = (ArtifactCoordinate)element$iv$iv;
                boolean bl = false;
                Object[] objectArray = new String[]{'/' + it.getGroup() + '/' + it.getName() + '/', '/' + StringsKt.replace$default((String)it.getGroup(), (String)".", (String)"/", (boolean)false, (int)4, null) + '/' + it.getName() + '/'};
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }
    }));
    private static final Logger LOGGER = LoggerFactory.getLogger(JakartaEeMigrationTransform.class);

    private final List<String> getExcludedPaths() {
        Lazy lazy = this.excludedPaths$delegate;
        return (List)lazy.getValue();
    }

    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(@NotNull TransformOutputs outputs) {
        boolean bl;
        File inputFile;
        block7: {
            Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
            inputFile = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
            if (!inputFile.exists()) {
                LOGGER.debug("Skipping JakartaEE transform for {}, input file does not exist", (Object)inputFile);
                return;
            }
            Iterable $this$any$iv = this.getExcludedPaths();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = inputFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"inputFile.path");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            LOGGER.debug("Skipping JakartaEE transform for {}, path is excluded", (Object)inputFile);
            outputs.file((Object)inputFile);
            return;
        }
        Migration migration = new Migration();
        migration.setSource(inputFile);
        Path tempFilePath = Files.createTempFile("jakartaee", "transform", new FileAttribute[0]);
        migration.setDestination(tempFilePath.toFile());
        migration.setEESpecProfile((EESpecProfile)EESpecProfiles.EE);
        migration.setEnableDefaultExcludes(false);
        migration.execute();
        if (migration.hasConverted()) {
            StringBuilder stringBuilder = new StringBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)inputFile, (String)"inputFile");
            File outputFile = outputs.file((Object)stringBuilder.append(FilesKt.getNameWithoutExtension((File)inputFile)).append("-jakartaee.jar").toString());
            Files.move(tempFilePath, outputFile.toPath(), new CopyOption[0]);
            LOGGER.info("Transformed {} to JakartaEE {}", (Object)inputFile.getName(), (Object)outputFile.getName());
            outputs.file((Object)outputFile);
        } else {
            LOGGER.info("No JakartaEE transformation required for {}", (Object)inputFile.getName());
            Files.delete(tempFilePath);
            outputs.file((Object)inputFile);
        }
    }

    static {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(Migration.class.getCanonicalName());
        logger.setUseParentHandlers(false);
        Handler[] handlerArray = logger.getHandlers();
        Intrinsics.checkNotNullExpressionValue((Object)handlerArray, (String)"logger.handlers");
        for (Handler handler : handlerArray) {
            logger.removeHandler(handler);
        }
        Logger logger2 = LOGGER;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOGGER");
        logger.addHandler(new TransformHandler(logger2));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H'J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&\u00a8\u0006\b"}, d2={"Lcom/netflix/gradle/jakartaee/JakartaEeMigrationTransform$Parameters;", "Lorg/gradle/api/artifacts/transform/TransformParameters;", "getExcludedArtifacts", "", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;", "setExcludedArtifacts", "", "excludedArtifact", "gradle-jakartaee-migration-plugin"})
    public static interface Parameters
    extends TransformParameters {
        @Input
        @NotNull
        public List<ArtifactCoordinate> getExcludedArtifacts();

        public void setExcludedArtifacts(@NotNull List<ArtifactCoordinate> var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/gradle/jakartaee/JakartaEeMigrationTransform$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "gradle-jakartaee-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/netflix/gradle/jakartaee/JakartaEeMigrationTransform$TransformHandler;", "Ljava/util/logging/Handler;", "logger", "Lorg/slf4j/Logger;", "(Lorg/slf4j/Logger;)V", "getLogger", "()Lorg/slf4j/Logger;", "close", "", "flush", "publish", "record", "Ljava/util/logging/LogRecord;", "gradle-jakartaee-migration-plugin"})
    private static final class TransformHandler
    extends Handler {
        @NotNull
        private final Logger logger;

        public TransformHandler(@NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.logger = logger;
        }

        @NotNull
        public final Logger getLogger() {
            return this.logger;
        }

        @Override
        public void publish(@NotNull LogRecord record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            if (record.getLevel().intValue() < Level.INFO.intValue()) {
                this.logger.debug(record.getMessage());
            } else {
                this.logger.info(record.getMessage());
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

