/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.gradle.jakartaee.artifacts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0080\b\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u0002J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0013\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0019\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersion;", "", "source", "", "(Ljava/lang/String;)V", "numericParts", "", "", "getNumericParts", "()Ljava/util/List;", "parts", "getParts", "parts$delegate", "Lkotlin/Lazy;", "getSource", "()Ljava/lang/String;", "buildParts", "compareTo", "", "other", "component1", "copy", "equals", "", "", "hashCode", "toString", "Companion", "gradle-jakartaee-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nArtifactVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtifactVersion.kt\ncom/netflix/gradle/jakartaee/artifacts/ArtifactVersion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1549#2:136\n1620#2,3:137\n*S KotlinDebug\n*F\n+ 1 ArtifactVersion.kt\ncom/netflix/gradle/jakartaee/artifacts/ArtifactVersion\n*L\n40#1:136\n40#1:137,3\n*E\n"})
public final class ArtifactVersion
implements Comparable<ArtifactVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String source;
    @NotNull
    private final Lazy parts$delegate;
    @NotNull
    private final List<Long> numericParts;
    @NotNull
    private static final Map<String, Integer> SPECIAL_MEANINGS;

    /*
     * WARNING - void declaration
     */
    public ArtifactVersion(@NotNull String source) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.parts$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends String>>(this){
            final /* synthetic */ ArtifactVersion this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<String> invoke() {
                return ArtifactVersion.access$buildParts(this.this$0);
            }
        }));
        Iterable iterable = this.getParts();
        ArtifactVersion artifactVersion = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.toLongOrNull((String)it));
        }
        artifactVersion.numericParts = (List)destination$iv$iv;
    }

    @NotNull
    public final String getSource() {
        return this.source;
    }

    @NotNull
    public final List<String> getParts() {
        Lazy lazy = this.parts$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<Long> getNumericParts() {
        return this.numericParts;
    }

    @Override
    public int compareTo(@NotNull ArtifactVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)this, (Object)other)) {
            return 0;
        }
        List<String> parts1 = this.getParts();
        List<String> parts2 = other.getParts();
        List<Long> numericParts1 = this.numericParts;
        List<Long> numericParts2 = other.numericParts;
        int i = 0;
        while (i < parts1.size() && i < parts2.size()) {
            boolean is2Number;
            String part1 = parts1.get(i);
            String part2 = parts2.get(i);
            Long numericPart1 = numericParts1.get(i);
            Long numericPart2 = numericParts2.get(i);
            boolean is1Number = numericPart1 != null;
            boolean bl = is2Number = numericPart2 != null;
            if (Intrinsics.areEqual((Object)part1, (Object)part2)) {
                ++i;
                continue;
            }
            if (is1Number && !is2Number) {
                return 1;
            }
            if (is2Number && !is1Number) {
                return -1;
            }
            if (is1Number && is2Number) {
                Long l = numericPart1;
                Intrinsics.checkNotNull((Object)l);
                long l2 = l;
                Long l3 = numericPart2;
                Intrinsics.checkNotNull((Object)l3);
                int result = Intrinsics.compare((long)l2, (long)l3);
                if (result == 0) {
                    ++i;
                    continue;
                }
                return result;
            }
            String string = part1;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            Integer sm1 = SPECIAL_MEANINGS.get(string2);
            String string3 = part2;
            Locale locale2 = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"US");
            String string4 = string3.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
            Integer sm2 = SPECIAL_MEANINGS.get(string4);
            if (sm1 != null) {
                Integer n = sm2;
                if (n == null) {
                    n = 0;
                }
                sm2 = n;
                return sm1 - sm2;
            }
            return sm2 != null ? -sm2.intValue() : part1.compareTo(part2);
        }
        if (i < parts1.size()) {
            return numericParts1.get(i) == null ? -1 : 1;
        }
        return i < parts2.size() ? (numericParts2.get(i) == null ? 1 : -1) : this.source.compareTo(other.source);
    }

    private final List<String> buildParts() {
        int pos;
        List parts2 = new ArrayList();
        boolean digit = false;
        int startPart = 0;
        for (pos = 0; pos < this.source.length(); ++pos) {
            char c = this.source.charAt(pos);
            if ((((c == '.' ? true : c == '_') ? true : c == '-') ? true : c == '+') ? true : c == '~') {
                String string = this.source.substring(startPart, pos);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                parts2.add(string);
                startPart = pos + 1;
                digit = false;
                continue;
            }
            boolean bl = '0' <= c ? c < ':' : false;
            if (bl) {
                if (!digit && pos > startPart) {
                    String string = this.source.substring(startPart, pos);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    parts2.add(string);
                    startPart = pos;
                }
                digit = true;
                continue;
            }
            if (digit) {
                String string = this.source.substring(startPart, pos);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                parts2.add(string);
                startPart = pos;
            }
            digit = false;
        }
        if (pos > startPart) {
            String string = this.source.substring(startPart, pos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            parts2.add(string);
        }
        return parts2;
    }

    @NotNull
    public final String component1() {
        return this.source;
    }

    @NotNull
    public final ArtifactVersion copy(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return new ArtifactVersion(source);
    }

    public static /* synthetic */ ArtifactVersion copy$default(ArtifactVersion artifactVersion, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = artifactVersion.source;
        }
        return artifactVersion.copy(string);
    }

    @NotNull
    public String toString() {
        return "ArtifactVersion(source=" + this.source + ')';
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArtifactVersion)) {
            return false;
        }
        ArtifactVersion artifactVersion = (ArtifactVersion)other;
        return Intrinsics.areEqual((Object)this.source, (Object)artifactVersion.source);
    }

    public static final /* synthetic */ List access$buildParts(ArtifactVersion $this) {
        return $this.buildParts();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"dev", (Object)-1), TuplesKt.to((Object)"b", (Object)1), TuplesKt.to((Object)"beta", (Object)1), TuplesKt.to((Object)"m", (Object)2), TuplesKt.to((Object)"milestone", (Object)2), TuplesKt.to((Object)"rc", (Object)3), TuplesKt.to((Object)"final", (Object)4), TuplesKt.to((Object)"release", (Object)5), TuplesKt.to((Object)"sources", (Object)6)};
        SPECIAL_MEANINGS = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersion$Companion;", "", "()V", "SPECIAL_MEANINGS", "", "", "", "gradle-jakartaee-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

