/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.gradle.jakartaee.specifications;

import com.netflix.gradle.jakartaee.artifacts.ArtifactCoordinate;
import com.netflix.gradle.jakartaee.artifacts.ArtifactType;
import com.netflix.gradle.jakartaee.artifacts.ArtifactVersion;
import com.netflix.gradle.jakartaee.artifacts.ArtifactVersionCoordinate;
import com.netflix.gradle.jakartaee.artifacts.ExtensionsKt;
import com.netflix.gradle.jakartaee.specifications.Specification;
import com.netflix.gradle.jakartaee.specifications.SpecificationVersion;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\bH\u0016R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/netflix/gradle/jakartaee/specifications/BasicSpecification;", "Lcom/netflix/gradle/jakartaee/specifications/Specification;", "javaxCoordinate", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;", "jakartaCoordinate", "specificationToImplementationVersion", "", "Lcom/netflix/gradle/jakartaee/specifications/SpecificationVersion;", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersion;", "(Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;Ljava/util/Map;)V", "implementationToSpecificationVersion", "artifactType", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactType;", "artifactCoordinate", "implementationVersionFor", "artifactVersion", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersionCoordinate;", "implementationsForSpecification", "", "specificationVersion", "specificationForImplementation", "version", "gradle-jakartaee-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nBasicSpecification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicSpecification.kt\ncom/netflix/gradle/jakartaee/specifications/BasicSpecification\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1208#2,2:54\n1238#2,4:56\n*S KotlinDebug\n*F\n+ 1 BasicSpecification.kt\ncom/netflix/gradle/jakartaee/specifications/BasicSpecification\n*L\n28#1:54,2\n28#1:56,4\n*E\n"})
public abstract class BasicSpecification
implements Specification {
    @NotNull
    private final ArtifactCoordinate javaxCoordinate;
    @NotNull
    private final ArtifactCoordinate jakartaCoordinate;
    @NotNull
    private final Map<SpecificationVersion, ArtifactVersion> specificationToImplementationVersion;
    @NotNull
    private final Map<ArtifactVersion, SpecificationVersion> implementationToSpecificationVersion;

    /*
     * WARNING - void declaration
     */
    public BasicSpecification(@NotNull ArtifactCoordinate javaxCoordinate, @NotNull ArtifactCoordinate jakartaCoordinate, @NotNull Map<SpecificationVersion, ArtifactVersion> specificationToImplementationVersion) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)javaxCoordinate, (String)"javaxCoordinate");
        Intrinsics.checkNotNullParameter((Object)jakartaCoordinate, (String)"jakartaCoordinate");
        Intrinsics.checkNotNullParameter(specificationToImplementationVersion, (String)"specificationToImplementationVersion");
        this.javaxCoordinate = javaxCoordinate;
        this.jakartaCoordinate = jakartaCoordinate;
        this.specificationToImplementationVersion = specificationToImplementationVersion;
        Iterable iterable = this.specificationToImplementationVersion.entrySet();
        BasicSpecification basicSpecification = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var7_8 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            ArtifactVersion artifactVersion = (ArtifactVersion)it.getValue();
            boolean bl2 = false;
            SpecificationVersion specificationVersion = (SpecificationVersion)((Object)it.getKey());
            map.put(artifactVersion, specificationVersion);
        }
        basicSpecification.implementationToSpecificationVersion = destination$iv$iv;
    }

    @Override
    @NotNull
    public List<ArtifactVersionCoordinate> implementationsForSpecification(@NotNull SpecificationVersion specificationVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)specificationVersion), (String)"specificationVersion");
        ArtifactCoordinate defaultImplementation = specificationVersion.compareTo((Enum)SpecificationVersion.EE8) <= 0 ? this.javaxCoordinate : this.jakartaCoordinate;
        ArtifactVersion artifactVersion = this.specificationToImplementationVersion.get((Object)specificationVersion);
        Intrinsics.checkNotNull((Object)artifactVersion);
        String version = artifactVersion.toString();
        return CollectionsKt.listOf((Object)defaultImplementation.withVersion(version));
    }

    @Override
    @NotNull
    public ArtifactVersion implementationVersionFor(@NotNull ArtifactVersionCoordinate artifactVersion) {
        Intrinsics.checkNotNullParameter((Object)artifactVersion, (String)"artifactVersion");
        if (Intrinsics.areEqual((Object)artifactVersion.getModule().getGroup(), (Object)"org.glassfish")) {
            ArtifactVersion artifactVersion2 = this.specificationToImplementationVersion.get((Object)SpecificationVersion.EE7);
            Intrinsics.checkNotNull((Object)artifactVersion2);
            return artifactVersion2;
        }
        return ExtensionsKt.getMinorVersion(artifactVersion.getVersion());
    }

    @Override
    @NotNull
    public SpecificationVersion specificationForImplementation(@NotNull ArtifactVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        ArtifactVersion minorVersion = ExtensionsKt.getMinorVersion(version);
        SpecificationVersion specificationVersion = this.implementationToSpecificationVersion.get(minorVersion);
        if (specificationVersion == null) {
            specificationVersion = SpecificationVersion.EE7;
        }
        return specificationVersion;
    }

    @Override
    @NotNull
    public ArtifactType artifactType(@NotNull ArtifactCoordinate artifactCoordinate) {
        Intrinsics.checkNotNullParameter((Object)artifactCoordinate, (String)"artifactCoordinate");
        return ArtifactType.API;
    }

    @Override
    public void configureCapabilities(@NotNull DependencyHandler dependencies) {
        Specification.DefaultImpls.configureCapabilities(this, dependencies);
    }

    @Override
    public void execute(@NotNull ComponentMetadataContext context) {
        Specification.DefaultImpls.execute(this, context);
    }

    @Override
    public void configureCapabilitiesResolution(@NotNull Configuration configuration) {
        Specification.DefaultImpls.configureCapabilitiesResolution(this, configuration);
    }
}

