/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.gradle.jakartaee.specifications;

import com.netflix.gradle.jakartaee.artifacts.ArtifactCoordinate;
import com.netflix.gradle.jakartaee.artifacts.ArtifactType;
import com.netflix.gradle.jakartaee.artifacts.ArtifactVersion;
import com.netflix.gradle.jakartaee.artifacts.ArtifactVersionCoordinate;
import com.netflix.gradle.jakartaee.specifications.BasicSpecification;
import com.netflix.gradle.jakartaee.specifications.SpecificationVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\u0006\u0010\u0013\u001a\u00020\tH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/netflix/gradle/jakartaee/specifications/ContainerProvidedSpecification;", "Lcom/netflix/gradle/jakartaee/specifications/BasicSpecification;", "javaxCoordinate", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;", "jakartaCoordinate", "tomcatCoordinates", "", "specificationToImplementationVersion", "", "Lcom/netflix/gradle/jakartaee/specifications/SpecificationVersion;", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersion;", "(Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;Ljava/util/List;Ljava/util/Map;)V", "artifactType", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactType;", "artifactCoordinate", "implementationVersionFor", "artifactVersion", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersionCoordinate;", "implementationsForSpecification", "specificationVersion", "Companion", "gradle-jakartaee-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nContainerProvidedSpecification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContainerProvidedSpecification.kt\ncom/netflix/gradle/jakartaee/specifications/ContainerProvidedSpecification\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1549#2:69\n1620#2,3:70\n1208#2,2:73\n1238#2,4:75\n*S KotlinDebug\n*F\n+ 1 ContainerProvidedSpecification.kt\ncom/netflix/gradle/jakartaee/specifications/ContainerProvidedSpecification\n*L\n48#1:69\n48#1:70,3\n39#1:73,2\n39#1:75,4\n*E\n"})
public abstract class ContainerProvidedSpecification
extends BasicSpecification {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final List<ArtifactCoordinate> tomcatCoordinates;
    @NotNull
    private final Map<SpecificationVersion, ArtifactVersion> specificationToImplementationVersion;
    @NotNull
    private static final Map<ArtifactVersion, SpecificationVersion> TOMCAT_TO_EE_VERSION;
    @NotNull
    private static final Map<SpecificationVersion, ArtifactVersion> EE_TO_TOMCAT_VERSION;
    @NotNull
    private static final ArtifactCoordinate TOMCAT_EMBED;

    public ContainerProvidedSpecification(@NotNull ArtifactCoordinate javaxCoordinate, @NotNull ArtifactCoordinate jakartaCoordinate, @NotNull List<ArtifactCoordinate> tomcatCoordinates, @NotNull Map<SpecificationVersion, ArtifactVersion> specificationToImplementationVersion) {
        Intrinsics.checkNotNullParameter((Object)javaxCoordinate, (String)"javaxCoordinate");
        Intrinsics.checkNotNullParameter((Object)jakartaCoordinate, (String)"jakartaCoordinate");
        Intrinsics.checkNotNullParameter(tomcatCoordinates, (String)"tomcatCoordinates");
        Intrinsics.checkNotNullParameter(specificationToImplementationVersion, (String)"specificationToImplementationVersion");
        super(javaxCoordinate, jakartaCoordinate, specificationToImplementationVersion);
        this.tomcatCoordinates = tomcatCoordinates;
        this.specificationToImplementationVersion = specificationToImplementationVersion;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ArtifactVersionCoordinate> implementationsForSpecification(@NotNull SpecificationVersion specificationVersion) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)specificationVersion), (String)"specificationVersion");
        ArtifactVersion artifactVersion = EE_TO_TOMCAT_VERSION.get((Object)specificationVersion);
        Intrinsics.checkNotNull((Object)artifactVersion);
        ArtifactVersion tomcatVersion = artifactVersion;
        Iterable iterable = this.tomcatCoordinates;
        Collection collection = super.implementationsForSpecification(specificationVersion);
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ArtifactCoordinate artifactCoordinate = (ArtifactCoordinate)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.withVersion(tomcatVersion.getSource()));
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public ArtifactVersion implementationVersionFor(@NotNull ArtifactVersionCoordinate artifactVersion) {
        Intrinsics.checkNotNullParameter((Object)artifactVersion, (String)"artifactVersion");
        ArtifactVersion implementationVersion = super.implementationVersionFor(artifactVersion);
        String group = artifactVersion.getModule().getGroup();
        if (StringsKt.startsWith$default((String)group, (String)"tomcat", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)group, (String)"org.apache.tomcat", (boolean)false, (int)2, null)) {
            SpecificationVersion specificationVersion = TOMCAT_TO_EE_VERSION.get(implementationVersion);
            if (specificationVersion == null) {
                specificationVersion = SpecificationVersion.EE7;
            }
            SpecificationVersion specificationVersion2 = specificationVersion;
            ArtifactVersion artifactVersion2 = this.specificationToImplementationVersion.get((Object)specificationVersion2);
            Intrinsics.checkNotNull((Object)artifactVersion2);
            implementationVersion = artifactVersion2;
        }
        return implementationVersion;
    }

    @Override
    @NotNull
    public ArtifactType artifactType(@NotNull ArtifactCoordinate artifactCoordinate) {
        Intrinsics.checkNotNullParameter((Object)artifactCoordinate, (String)"artifactCoordinate");
        return Intrinsics.areEqual((Object)artifactCoordinate.getGroup(), (Object)"org.apache.tomcat.embed") ? ArtifactType.BUNDLE : ArtifactType.API;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)new ArtifactVersion("8.0"), (Object)((Object)SpecificationVersion.EE7)), TuplesKt.to((Object)new ArtifactVersion("8.5"), (Object)((Object)SpecificationVersion.EE7)), TuplesKt.to((Object)new ArtifactVersion("9.0"), (Object)((Object)SpecificationVersion.EE8)), TuplesKt.to((Object)new ArtifactVersion("10.0"), (Object)((Object)SpecificationVersion.EE9)), TuplesKt.to((Object)new ArtifactVersion("10.1"), (Object)((Object)SpecificationVersion.EE10))};
        TOMCAT_TO_EE_VERSION = MapsKt.mapOf((Pair[])pairArray);
        Iterable $this$associateBy$iv = TOMCAT_TO_EE_VERSION.entrySet();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            SpecificationVersion specificationVersion = (SpecificationVersion)((Object)it.getValue());
            boolean bl2 = false;
            ArtifactVersion artifactVersion = (ArtifactVersion)it.getKey();
            map.put(specificationVersion, artifactVersion);
        }
        EE_TO_TOMCAT_VERSION = destination$iv$iv;
        TOMCAT_EMBED = new ArtifactCoordinate("org.apache.tomcat.embed", "tomcat-embed-core");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/netflix/gradle/jakartaee/specifications/ContainerProvidedSpecification$Companion;", "", "()V", "EE_TO_TOMCAT_VERSION", "", "Lcom/netflix/gradle/jakartaee/specifications/SpecificationVersion;", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersion;", "TOMCAT_EMBED", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;", "getTOMCAT_EMBED$gradle_jakartaee_migration_plugin", "()Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;", "TOMCAT_TO_EE_VERSION", "getTOMCAT_TO_EE_VERSION$gradle_jakartaee_migration_plugin", "()Ljava/util/Map;", "gradle-jakartaee-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<ArtifactVersion, SpecificationVersion> getTOMCAT_TO_EE_VERSION$gradle_jakartaee_migration_plugin() {
            return TOMCAT_TO_EE_VERSION;
        }

        @NotNull
        public final ArtifactCoordinate getTOMCAT_EMBED$gradle_jakartaee_migration_plugin() {
            return TOMCAT_EMBED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

