/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.compiler.ast;

import com.netflix.nebula.lint.jdt.internal.compiler.ASTVisitor;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.EmptyStatement;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Statement;
import com.netflix.nebula.lint.jdt.internal.compiler.codegen.CodeStream;
import com.netflix.nebula.lint.jdt.internal.compiler.codegen.Label;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowContext;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowInfo;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.LoopingFlowContext;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import com.netflix.nebula.lint.jdt.internal.compiler.impl.Constant;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BlockScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding;

public class WhileStatement
extends Statement {
    public Expression condition;
    public Statement action;
    private Label breakLabel;
    private Label continueLabel;
    int preCondInitStateIndex = -1;
    int condIfTrueInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public WhileStatement(Expression condition, Statement action, int s, int e) {
        this.condition = condition;
        this.action = action;
        if (action instanceof EmptyStatement) {
            action.bits |= 1;
        }
        this.sourceStart = s;
        this.sourceEnd = e;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo actionInfo;
        this.breakLabel = new Label();
        this.continueLabel = new Label();
        Constant cst = this.condition.constant;
        boolean isConditionTrue = cst != NotAConstant && cst.booleanValue();
        boolean isConditionFalse = cst != NotAConstant && !cst.booleanValue();
        cst = this.condition.optimizedBooleanConstant();
        boolean isConditionOptimizedTrue = cst != NotAConstant && cst.booleanValue();
        boolean isConditionOptimizedFalse = cst != NotAConstant && !cst.booleanValue();
        this.preCondInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
        FlowInfo condInfo = flowInfo.copy().unconditionalInits().discardNullRelatedInitializations();
        LoopingFlowContext condLoopContext = new LoopingFlowContext(flowContext, this, null, null, currentScope);
        condInfo = this.condition.analyseCode(currentScope, condLoopContext, condInfo);
        if (this.action == null || this.action.isEmptyBlock() && currentScope.compilerOptions().complianceLevel <= 0x2F0000L) {
            condLoopContext.complainOnDeferredChecks(currentScope, condInfo);
            if (isConditionTrue) {
                return FlowInfo.DEAD_END;
            }
            UnconditionalFlowInfo mergedInfo = condInfo.initsWhenFalse().unconditionalInits();
            if (isConditionOptimizedTrue) {
                ((FlowInfo)mergedInfo).setReachMode(1);
            }
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
            return mergedInfo;
        }
        LoopingFlowContext loopingContext = new LoopingFlowContext(flowContext, this, this.breakLabel, this.continueLabel, currentScope);
        if (isConditionFalse) {
            actionInfo = FlowInfo.DEAD_END;
        } else {
            actionInfo = condInfo.initsWhenTrue().copy();
            if (isConditionOptimizedFalse) {
                actionInfo.setReachMode(1);
            }
        }
        this.condIfTrueInitStateIndex = currentScope.methodScope().recordInitializationStates(condInfo.initsWhenTrue());
        if (!this.action.complainIfUnreachable(actionInfo, currentScope, false)) {
            actionInfo = this.action.analyseCode(currentScope, loopingContext, actionInfo);
        }
        FlowInfo exitBranch = condInfo.initsWhenFalse();
        exitBranch.addInitializationsFrom(flowInfo);
        if (!actionInfo.isReachable() && !loopingContext.initsOnContinue.isReachable()) {
            this.continueLabel = null;
        } else {
            condLoopContext.complainOnDeferredChecks(currentScope, condInfo);
            actionInfo = actionInfo.mergedWith(loopingContext.initsOnContinue.unconditionalInits());
            loopingContext.complainOnDeferredChecks(currentScope, actionInfo);
            exitBranch.addPotentialInitializationsFrom(actionInfo.unconditionalInits());
        }
        FlowInfo mergedInfo = FlowInfo.mergedOptimizedBranches(loopingContext.initsOnBreak, isConditionOptimizedTrue, exitBranch, isConditionOptimizedFalse, !isConditionTrue);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        this.breakLabel.initialize(codeStream);
        if (this.continueLabel == null) {
            if (this.condition.constant == NotAConstant) {
                this.condition.generateOptimizedBoolean(currentScope, codeStream, null, this.breakLabel, true);
            }
        } else {
            this.continueLabel.initialize(codeStream);
            if (!(this.condition.constant != NotAConstant && this.condition.constant.booleanValue() || this.action == null || this.action.isEmptyBlock())) {
                int jumpPC = codeStream.position;
                codeStream.goto_(this.continueLabel);
                codeStream.recordPositionsFrom(jumpPC, this.condition.sourceStart);
            }
        }
        Label actionLabel = new Label(codeStream);
        actionLabel.place();
        if (this.action != null) {
            if (this.condIfTrueInitStateIndex != -1) {
                codeStream.addDefinitelyAssignedVariables(currentScope, this.condIfTrueInitStateIndex);
            }
            this.action.generateCode(currentScope, codeStream);
            if (this.preCondInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preCondInitStateIndex);
            }
        }
        if (this.continueLabel != null) {
            this.continueLabel.place();
            this.condition.generateOptimizedBoolean(currentScope, codeStream, actionLabel, null, true);
        }
        this.breakLabel.place();
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void resolve(BlockScope scope) {
        TypeBinding type = this.condition.resolveTypeExpecting(scope, BooleanBinding);
        this.condition.computeConversion(scope, type, type);
        if (this.action != null) {
            this.action.resolve(scope);
        }
    }

    public StringBuffer printStatement(int tab, StringBuffer output) {
        WhileStatement.printIndent(tab, output).append("while (");
        this.condition.printExpression(0, output).append(')');
        if (this.action == null) {
            output.append(';');
        } else {
            this.action.printStatement(tab + 1, output);
        }
        return output;
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.condition.traverse(visitor, blockScope);
            if (this.action != null) {
                this.action.traverse(visitor, blockScope);
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

