/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.IJavaElement;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.internal.core.JarPackageFragment;
import com.netflix.nebula.lint.jdt.internal.core.JarPackageFragmentRoot;
import com.netflix.nebula.lint.jdt.internal.core.Openable;
import com.netflix.nebula.lint.jdt.internal.core.OverflowingLRUCache;
import com.netflix.nebula.lint.jdt.internal.core.util.LRUCache;

public class ElementCache
extends OverflowingLRUCache {
    IJavaElement spaceLimitParent = null;

    public ElementCache(int size) {
        super(size);
    }

    public ElementCache(int size, int overflow) {
        super(size, overflow);
    }

    protected boolean close(LRUCache.LRUCacheEntry entry) {
        Openable element = (Openable)entry._fKey;
        try {
            if (!element.canBeRemovedFromCache()) {
                return false;
            }
            if (element instanceof JarPackageFragment) {
                JarPackageFragment packageFragment = (JarPackageFragment)element;
                JarPackageFragmentRoot root = (JarPackageFragmentRoot)packageFragment.getParent();
                root.close();
            } else {
                element.close();
            }
            return true;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    protected void ensureSpaceLimit(int childrenSize, IJavaElement parent) {
        int spaceNeeded = 1 + (int)((1.0 + this.fLoadFactor) * (double)(childrenSize + this.fOverflow));
        if (this.fSpaceLimit < spaceNeeded) {
            this.shrink();
            this.setSpaceLimit(spaceNeeded);
            this.spaceLimitParent = parent;
        }
    }

    protected void resetSpaceLimit(int defaultLimit, IJavaElement parent) {
        if (parent.equals(this.spaceLimitParent)) {
            this.setSpaceLimit(defaultLimit);
            this.spaceLimitParent = null;
        }
    }

    protected LRUCache newInstance(int size, int overflow) {
        return new ElementCache(size, overflow);
    }
}

