/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core.hierarchy;

import com.netflix.nebula.lint.jdt.core.IType;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.internal.compiler.classfmt.ClassFileReader;
import com.netflix.nebula.lint.jdt.internal.compiler.classfmt.ClassFormatException;
import com.netflix.nebula.lint.jdt.internal.compiler.env.IBinaryType;
import com.netflix.nebula.lint.jdt.internal.compiler.env.ICompilationUnit;
import com.netflix.nebula.lint.jdt.internal.compiler.env.IGenericType;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ReferenceBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.problem.DefaultProblemFactory;
import com.netflix.nebula.lint.jdt.internal.core.BasicCompilationUnit;
import com.netflix.nebula.lint.jdt.internal.core.ClassFile;
import com.netflix.nebula.lint.jdt.internal.core.JarPackageFragmentRoot;
import com.netflix.nebula.lint.jdt.internal.core.JavaElement;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelManager;
import com.netflix.nebula.lint.jdt.internal.core.JavaProject;
import com.netflix.nebula.lint.jdt.internal.core.NameLookup;
import com.netflix.nebula.lint.jdt.internal.core.Openable;
import com.netflix.nebula.lint.jdt.internal.core.PackageFragment;
import com.netflix.nebula.lint.jdt.internal.core.ResolvedBinaryType;
import com.netflix.nebula.lint.jdt.internal.core.SearchableEnvironment;
import com.netflix.nebula.lint.jdt.internal.core.SourceTypeElementInfo;
import com.netflix.nebula.lint.jdt.internal.core.hierarchy.HierarchyResolver;
import com.netflix.nebula.lint.jdt.internal.core.hierarchy.HierarchyType;
import com.netflix.nebula.lint.jdt.internal.core.hierarchy.TypeHierarchy;
import com.netflix.nebula.lint.jdt.internal.core.util.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public abstract class HierarchyBuilder {
    protected TypeHierarchy hierarchy;
    protected NameLookup nameLookup;
    protected HierarchyResolver hierarchyResolver;
    protected Map infoToHandle;
    protected String focusQualifiedName;

    public HierarchyBuilder(TypeHierarchy hierarchy) throws JavaModelException {
        com.netflix.nebula.lint.jdt.core.ICompilationUnit[] unitsToLookInside;
        this.hierarchy = hierarchy;
        JavaProject project = (JavaProject)hierarchy.javaProject();
        IType focusType = hierarchy.getType();
        com.netflix.nebula.lint.jdt.core.ICompilationUnit unitToLookInside = focusType == null ? null : focusType.getCompilationUnit();
        com.netflix.nebula.lint.jdt.core.ICompilationUnit[] workingCopies = this.hierarchy.workingCopies;
        if (unitToLookInside != null) {
            int wcLength;
            int n = wcLength = workingCopies == null ? 0 : workingCopies.length;
            if (wcLength == 0) {
                unitsToLookInside = new com.netflix.nebula.lint.jdt.core.ICompilationUnit[]{unitToLookInside};
            } else {
                unitsToLookInside = new com.netflix.nebula.lint.jdt.core.ICompilationUnit[wcLength + 1];
                unitsToLookInside[0] = unitToLookInside;
                System.arraycopy(workingCopies, 0, unitsToLookInside, 1, wcLength);
            }
        } else {
            unitsToLookInside = workingCopies;
        }
        SearchableEnvironment searchableEnvironment = project.newSearchableNameEnvironment(unitsToLookInside);
        this.nameLookup = searchableEnvironment.nameLookup;
        this.hierarchyResolver = new HierarchyResolver(searchableEnvironment, project.getOptions(true), this, new DefaultProblemFactory());
        this.infoToHandle = new HashMap(5);
        this.focusQualifiedName = focusType == null ? null : focusType.getFullyQualifiedName();
    }

    public abstract void build(boolean var1) throws JavaModelException, CoreException;

    protected void buildSupertypes() {
        IGenericType type;
        IType focusType = this.getType();
        if (focusType == null) {
            return;
        }
        try {
            type = (IGenericType)((JavaElement)((Object)focusType)).getElementInfo();
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        this.hierarchyResolver.resolve(type);
        if (!this.hierarchy.contains(focusType)) {
            this.hierarchy.addRootClass(focusType);
        }
    }

    public void connect(IGenericType type, IType typeHandle, IType superclassHandle, IType[] superinterfaceHandles) {
        if (typeHandle == null) {
            return;
        }
        if (TypeHierarchy.DEBUG) {
            System.out.println("Connecting: " + ((JavaElement)((Object)typeHandle)).toStringWithAncestors());
            System.out.println("  to superclass: " + (superclassHandle == null ? "<None>" : ((JavaElement)((Object)superclassHandle)).toStringWithAncestors()));
            System.out.print("  and superinterfaces:");
            if (superinterfaceHandles == null || superinterfaceHandles.length == 0) {
                System.out.println(" <None>");
            } else {
                System.out.println();
                int i = 0;
                int length = superinterfaceHandles.length;
                while (i < length) {
                    if (superinterfaceHandles[i] != null) {
                        System.out.println("    " + ((JavaElement)((Object)superinterfaceHandles[i])).toStringWithAncestors());
                    }
                    ++i;
                }
            }
        }
        switch (type.getKind()) {
            case 1: 
            case 3: {
                if (superclassHandle == null) {
                    this.hierarchy.addRootClass(typeHandle);
                    break;
                }
                this.hierarchy.cacheSuperclass(typeHandle, superclassHandle);
                break;
            }
            case 2: 
            case 4: {
                this.hierarchy.addInterface(typeHandle);
            }
        }
        if (superinterfaceHandles == null) {
            superinterfaceHandles = TypeHierarchy.NO_TYPE;
        }
        this.hierarchy.cacheSuperInterfaces(typeHandle, superinterfaceHandles);
        this.hierarchy.cacheFlags(typeHandle, type.getModifiers());
    }

    protected IType getHandle(IGenericType genericType, ReferenceBinding binding) {
        if (genericType == null) {
            return null;
        }
        if (genericType instanceof HierarchyType) {
            IType handle = (IType)this.infoToHandle.get(genericType);
            if (handle == null) {
                handle = ((HierarchyType)genericType).typeHandle;
                handle = (IType)((Object)((JavaElement)((Object)handle)).resolved(binding));
                this.infoToHandle.put(genericType, handle);
            }
            return handle;
        }
        if (genericType.isBinaryType()) {
            ClassFile classFile = (ClassFile)this.infoToHandle.get(genericType);
            if (classFile == null) {
                IType handle = this.lookupBinaryHandle((IBinaryType)genericType);
                if (handle == null) {
                    return null;
                }
                classFile = (ClassFile)handle.getParent();
                this.infoToHandle.put(genericType, classFile);
            }
            return new ResolvedBinaryType(classFile, classFile.getTypeName(), new String(binding.computeUniqueKey()));
        }
        if (genericType instanceof SourceTypeElementInfo) {
            IType handle = ((SourceTypeElementInfo)genericType).getHandle();
            return (IType)((Object)((JavaElement)((Object)handle)).resolved(binding));
        }
        return null;
    }

    protected IType getType() {
        return this.hierarchy.getType();
    }

    protected IType lookupBinaryHandle(IBinaryType typeInfo) {
        int flag;
        switch (typeInfo.getKind()) {
            case 1: {
                flag = 2;
                break;
            }
            case 2: {
                flag = 4;
                break;
            }
            case 3: {
                flag = 8;
                break;
            }
            default: {
                flag = 16;
            }
        }
        char[] bName = typeInfo.getName();
        String qualifiedName = new String(ClassFile.translatedName(bName));
        if (qualifiedName.equals(this.focusQualifiedName)) {
            return this.getType();
        }
        return this.nameLookup.findType(qualifiedName, false, flag);
    }

    protected void worked(IProgressMonitor monitor, int work) {
        if (monitor != null) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(work);
        }
    }

    protected ICompilationUnit createCompilationUnitFromPath(Openable handle, String osPath) {
        final char[] elementName = handle.getElementName().toCharArray();
        return new BasicCompilationUnit(null, null, osPath, handle){

            public char[] getFileName() {
                return elementName;
            }
        };
    }

    protected IBinaryType createInfoFromClassFile(Openable handle, String osPath) {
        ClassFileReader info = null;
        try {
            info = ClassFileReader.read(osPath);
        }
        catch (ClassFormatException e) {
            if (TypeHierarchy.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        catch (IOException e) {
            if (TypeHierarchy.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        this.infoToHandle.put(info, handle);
        return info;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IBinaryType createInfoFromClassFileInJar(Openable classFile) {
        PackageFragment pkg = (PackageFragment)classFile.getParent();
        String classFilePath = Util.concatWith(pkg.names, classFile.getElementName(), '/');
        ClassFileReader info = null;
        ZipFile zipFile = null;
        try {
            try {
                zipFile = ((JarPackageFragmentRoot)pkg.getParent()).getJar();
                info = ClassFileReader.read(zipFile, classFilePath);
            }
            catch (ClassFormatException e) {
                if (TypeHierarchy.DEBUG) {
                    e.printStackTrace();
                }
                IBinaryType iBinaryType = null;
                Object var7_12 = null;
                JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                return iBinaryType;
            }
            catch (IOException e) {
                if (TypeHierarchy.DEBUG) {
                    e.printStackTrace();
                }
                IBinaryType iBinaryType = null;
                Object var7_13 = null;
                JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                return iBinaryType;
            }
            catch (CoreException e) {
                if (TypeHierarchy.DEBUG) {
                    e.printStackTrace();
                }
                IBinaryType iBinaryType = null;
                Object var7_14 = null;
                JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                return iBinaryType;
            }
        }
        catch (Throwable throwable) {
            Object var7_15 = null;
            JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
            throw throwable;
        }
        {
            Object var7_16 = null;
            JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
            this.infoToHandle.put(info, classFile);
        }
        return info;
    }
}

