/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core.search;

import com.netflix.nebula.lint.jdt.core.search.IJavaSearchScope;
import com.netflix.nebula.lint.jdt.core.search.SearchDocument;
import com.netflix.nebula.lint.jdt.core.search.SearchParticipant;
import com.netflix.nebula.lint.jdt.core.search.SearchPattern;
import com.netflix.nebula.lint.jdt.core.search.SearchRequestor;
import com.netflix.nebula.lint.jdt.internal.compiler.util.Util;
import com.netflix.nebula.lint.jdt.internal.core.search.IndexSelector;
import com.netflix.nebula.lint.jdt.internal.core.search.JavaSearchDocument;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.BinaryIndexer;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.SourceIndexer;
import com.netflix.nebula.lint.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;

public class JavaSearchParticipant
extends SearchParticipant {
    IndexSelector indexSelector;

    public void beginSearching() {
        super.beginSearching();
        this.indexSelector = null;
    }

    public void doneSearching() {
        this.indexSelector = null;
        super.doneSearching();
    }

    public String getDescription() {
        return "Java";
    }

    public SearchDocument getDocument(String documentPath) {
        return new JavaSearchDocument(documentPath, this);
    }

    public void indexDocument(SearchDocument document, IPath indexPath) {
        document.removeAllIndexEntries();
        String documentPath = document.getPath();
        if (com.netflix.nebula.lint.jdt.internal.core.util.Util.isJavaLikeFileName(documentPath)) {
            new SourceIndexer(document).indexDocument();
        } else if (Util.isClassFileName(documentPath)) {
            new BinaryIndexer(document).indexDocument();
        }
    }

    public void locateMatches(SearchDocument[] indexMatches, SearchPattern pattern, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        MatchLocator matchLocator = new MatchLocator(pattern, requestor, scope, (IProgressMonitor)(monitor == null ? null : new SubProgressMonitor(monitor, 95)));
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        matchLocator.locateMatches(indexMatches);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        matchLocator.locatePackageDeclarations(this);
    }

    public IPath[] selectIndexes(SearchPattern pattern, IJavaSearchScope scope) {
        if (this.indexSelector == null) {
            this.indexSelector = new IndexSelector(scope, pattern);
        }
        return this.indexSelector.getIndexLocations();
    }
}

