/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.api;

import com.netflix.nebula.lint.jgit.api.GitCommand;
import com.netflix.nebula.lint.jgit.api.errors.GitAPIException;
import com.netflix.nebula.lint.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.lint.jgit.errors.ConfigInvalidException;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.lib.StoredConfig;
import com.netflix.nebula.lint.jgit.submodule.SubmoduleWalk;
import com.netflix.nebula.lint.jgit.treewalk.filter.PathFilterGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SubmoduleSyncCommand
extends GitCommand<Map<String, String>> {
    private final Collection<String> paths = new ArrayList<String>();

    public SubmoduleSyncCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleSyncCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    protected String getHeadBranch(Repository subRepo) throws IOException {
        Ref head = subRepo.exactRef("HEAD");
        if (head != null && head.isSymbolic()) {
            return Repository.shortenRefName(head.getLeaf().getName());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, String> call() throws GitAPIException {
        this.checkCallable();
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
                if (!this.paths.isEmpty()) {
                    generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
                }
                HashMap<String, String> synced = new HashMap<String, String>();
                StoredConfig config = this.repo.getConfig();
                while (generator.next()) {
                    String remoteUrl = generator.getRemoteUrl();
                    if (remoteUrl == null) continue;
                    String path = generator.getPath();
                    config.setString("submodule", path, "url", remoteUrl);
                    synced.put(path, remoteUrl);
                    Throwable throwable2 = null;
                    Object var9_14 = null;
                    try {
                        Repository subRepo = generator.getRepository();
                        try {
                            if (subRepo == null) {
                                if (subRepo == null) continue;
                                subRepo.close();
                                continue;
                            }
                            StoredConfig subConfig = subRepo.getConfig();
                            String branch = this.getHeadBranch(subRepo);
                            String remote = null;
                            if (branch != null) {
                                remote = subConfig.getString("branch", branch, "remote");
                            }
                            if (remote == null) {
                                remote = "origin";
                            }
                            subConfig.setString("remote", remote, "url", remoteUrl);
                            subConfig.save();
                            if (subRepo == null) continue;
                            subRepo.close();
                        }
                        catch (Throwable throwable3) {
                            if (subRepo == null) throw throwable3;
                            subRepo.close();
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                            throw throwable2;
                        }
                        if (throwable2 == throwable4) throw throwable2;
                        throwable2.addSuppressed(throwable4);
                        throw throwable2;
                    }
                }
                if (!synced.isEmpty()) {
                    config.save();
                }
                return synced;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

