/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.ketch;

import com.netflix.nebula.lint.jgit.internal.ketch.KetchLeader;
import com.netflix.nebula.lint.jgit.internal.ketch.KetchSystem;
import com.netflix.nebula.lint.jgit.internal.ketch.LogIndex;
import com.netflix.nebula.lint.jgit.lib.AnyObjectId;
import com.netflix.nebula.lint.jgit.transport.ReceiveCommand;
import java.io.IOException;
import java.util.List;

abstract class Round {
    final KetchLeader leader;
    final LogIndex acceptedOldIndex;
    LogIndex acceptedNewIndex;
    List<ReceiveCommand> stageCommands;

    Round(KetchLeader leader, LogIndex head) {
        this.leader = leader;
        this.acceptedOldIndex = head;
    }

    KetchSystem getSystem() {
        return this.leader.getSystem();
    }

    abstract void start() throws IOException;

    void runAsync(AnyObjectId newId) {
        this.acceptedNewIndex = this.acceptedOldIndex.nextIndex(newId);
        this.leader.runAsync(this);
    }

    abstract void success();
}

