/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.ketch;

import com.netflix.nebula.lint.jgit.annotations.Nullable;
import com.netflix.nebula.lint.jgit.lib.AnyObjectId;
import com.netflix.nebula.lint.jgit.lib.CommitBuilder;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectInserter;
import com.netflix.nebula.lint.jgit.lib.PersonIdent;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import com.netflix.nebula.lint.jgit.revwalk.RevObject;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import com.netflix.nebula.lint.jgit.transport.ReceiveCommand;
import com.netflix.nebula.lint.jgit.treewalk.EmptyTreeIterator;
import com.netflix.nebula.lint.jgit.treewalk.TreeWalk;
import com.netflix.nebula.lint.jgit.treewalk.filter.TreeFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class StageBuilder {
    private static final int SMALL_BATCH_SIZE = 5;
    private static final int TEMP_PARENT_BATCH_SIZE = 128;
    private static final byte[] PEEL = new byte[]{32, 94};
    private final String txnStage;
    private final String txnId;

    public StageBuilder(String txnStageNamespace, ObjectId txnId) {
        this.txnStage = txnStageNamespace;
        this.txnId = txnId.name();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ReceiveCommand> makeStageList(Repository git, ObjectId oldTree, ObjectId newTree) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            List<ReceiveCommand> list;
            RevWalk rw = new RevWalk(git);
            try {
                TreeWalk tw = new TreeWalk(rw.getObjectReader());
                try {
                    block25: {
                        ObjectInserter ins = git.newObjectInserter();
                        try {
                            if (AnyObjectId.equals(oldTree, ObjectId.zeroId())) {
                                tw.addTree(new EmptyTreeIterator());
                            } else {
                                tw.addTree(rw.parseTree(oldTree));
                            }
                            tw.addTree(rw.parseTree(newTree));
                            tw.setFilter(TreeFilter.ANY_DIFF);
                            tw.setRecursive(true);
                            HashSet<ObjectId> newObjs = new HashSet<ObjectId>();
                            while (true) {
                                if (!tw.next()) {
                                    List<ReceiveCommand> cmds = this.makeStageList(newObjs, git, ins);
                                    ins.flush();
                                    list = cmds;
                                    return list;
                                }
                                if (tw.getRawMode(1) != 57344 || tw.isPathSuffix(PEEL, 2)) continue;
                                newObjs.add(tw.getObjectId(1));
                            }
                        }
                        finally {
                            if (ins == null) break block25;
                            ins.close();
                        }
                    }
                    if (tw != null) {
                        tw.close();
                    }
                    if (rw != null) {
                        rw.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (tw == null) throw throwable;
                    tw.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (rw == null) throw throwable;
                rw.close();
                throw throwable;
            }
            {
                return list;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    public List<ReceiveCommand> makeStageList(Set<ObjectId> newObjs, @Nullable Repository git, @Nullable ObjectInserter inserter) throws IOException {
        if (git == null || newObjs.size() <= 5) {
            ArrayList<ReceiveCommand> cmds = new ArrayList<ReceiveCommand>(newObjs.size());
            for (ObjectId id : newObjs) {
                this.stage(cmds, id);
            }
            return cmds;
        }
        ArrayList<ReceiveCommand> cmds = new ArrayList<ReceiveCommand>();
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        this.reduceObjects(cmds, commits, git, newObjs);
        if (inserter == null || commits.size() <= 1 || cmds.size() + commits.size() <= 5) {
            for (RevCommit c : commits) {
                this.stage(cmds, c.copy());
            }
            return cmds;
        }
        ObjectId tip = null;
        int end = commits.size();
        while (end > 0) {
            int start = Math.max(0, end - 128);
            List<RevCommit> batch = commits.subList(start, end);
            ArrayList<ObjectId> parents = new ArrayList<ObjectId>(1 + batch.size());
            if (tip != null) {
                parents.add(tip);
            }
            parents.addAll(batch);
            CommitBuilder b = new CommitBuilder();
            b.setTreeId(((RevCommit)batch.get(0)).getTree());
            b.setParentIds(parents);
            b.setAuthor(StageBuilder.tmpAuthor(batch));
            b.setCommitter(b.getAuthor());
            tip = inserter.insert(b);
            end = start;
        }
        this.stage(cmds, tip);
        return cmds;
    }

    private static PersonIdent tmpAuthor(List<RevCommit> commits) {
        int t = 0;
        int i = 0;
        while (i < commits.size()) {
            t = Math.max(t, commits.get(i).getCommitTime());
        }
        String name = "Ketch Stage";
        String email = "tmp@tmp";
        return new PersonIdent(name, email, (long)t * 1000L, 0);
    }

    private void reduceObjects(List<ReceiveCommand> cmds, List<RevCommit> commits, Repository git, Set<ObjectId> newObjs) throws IOException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (RevWalk rw = new RevWalk(git);){
            RevCommit c;
            rw.setRetainBody(false);
            for (ObjectId id : newObjs) {
                RevObject obj = rw.parseAny(id);
                if (obj instanceof RevCommit) {
                    rw.markStart((RevCommit)obj);
                    continue;
                }
                this.stage(cmds, id);
            }
            while ((c = rw.next()) != null) {
                commits.add(c);
                rw.markUninteresting(c);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void stage(List<ReceiveCommand> cmds, ObjectId id) {
        int estLen = this.txnStage.length() + this.txnId.length() + 5;
        StringBuilder n = new StringBuilder(estLen);
        n.append(this.txnStage).append(this.txnId).append('.');
        n.append(Integer.toHexString(cmds.size()));
        cmds.add(new ReceiveCommand(ObjectId.zeroId(), id, n.toString()));
    }
}

