/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.storage.dfs;

import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsReader;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsReftable;
import com.netflix.nebula.lint.jgit.internal.storage.reftable.Reftable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReftableStack
implements AutoCloseable {
    private final List<DfsReftable> files;
    private final List<Reftable> tables;

    public static ReftableStack open(DfsReader ctx, List<DfsReftable> files) throws IOException {
        ReftableStack stack = new ReftableStack(files.size());
        boolean close = true;
        try {
            for (DfsReftable t : files) {
                stack.files.add(t);
                stack.tables.add(t.open(ctx));
            }
            close = false;
            ReftableStack reftableStack = stack;
            return reftableStack;
        }
        finally {
            if (close) {
                stack.close();
            }
        }
    }

    private ReftableStack(int tableCnt) {
        this.files = new ArrayList<DfsReftable>(tableCnt);
        this.tables = new ArrayList<Reftable>(tableCnt);
    }

    public List<DfsReftable> files() {
        return Collections.unmodifiableList(this.files);
    }

    public List<Reftable> readers() {
        return Collections.unmodifiableList(this.tables);
    }

    @Override
    public void close() {
        for (Reftable t : this.tables) {
            try {
                t.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

