/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.storage.file;

import com.netflix.nebula.lint.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.internal.storage.file.FileRepository;
import com.netflix.nebula.lint.jgit.internal.storage.file.LockFile;
import com.netflix.nebula.lint.jgit.lib.Constants;
import com.netflix.nebula.lint.jgit.util.FileUtils;
import com.netflix.nebula.lint.jgit.util.GitDateParser;
import com.netflix.nebula.lint.jgit.util.SystemReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.FileTime;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.Instant;

class GcLog {
    private final FileRepository repo;
    private final File logFile;
    private final LockFile lock;
    private Instant gcLogExpire;
    private static final String LOG_EXPIRY_DEFAULT = "1.day.ago";
    private boolean nonEmpty = false;

    GcLog(FileRepository repo) {
        this.repo = repo;
        this.logFile = new File(repo.getDirectory(), "gc.log");
        this.lock = new LockFile(this.logFile);
    }

    private Instant getLogExpiry() throws ParseException {
        if (this.gcLogExpire == null) {
            String logExpiryStr = this.repo.getConfig().getString("gc", null, "logExpiry");
            if (logExpiryStr == null) {
                logExpiryStr = LOG_EXPIRY_DEFAULT;
            }
            this.gcLogExpire = GitDateParser.parse(logExpiryStr, null, SystemReader.getInstance().getLocale()).toInstant();
        }
        return this.gcLogExpire;
    }

    private boolean autoGcBlockedByOldLockFile(boolean background) {
        try {
            FileTime lastModified = Files.getLastModifiedTime(FileUtils.toPath(this.logFile), new LinkOption[0]);
            if (lastModified.toInstant().compareTo(this.getLogExpiry()) > 0) {
                if (!background) {
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try {
                        BufferedReader reader = Files.newBufferedReader(FileUtils.toPath(this.logFile));
                        try {
                            char[] buf = new char[1000];
                            int len = reader.read(buf, 0, 1000);
                            String oldError = new String(buf, 0, len);
                            throw new JGitInternalException(MessageFormat.format(JGitText.get().gcLogExists, oldError, this.logFile));
                        }
                        catch (Throwable throwable2) {
                            if (reader != null) {
                                reader.close();
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                return true;
            }
        }
        catch (NoSuchFileException lastModified) {
        }
        catch (IOException | ParseException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        return false;
    }

    boolean lock(boolean background) {
        try {
            if (!this.lock.lock()) {
                return false;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        if (this.autoGcBlockedByOldLockFile(background)) {
            this.lock.unlock();
            return false;
        }
        return true;
    }

    void unlock() {
        this.lock.unlock();
    }

    boolean commit() {
        if (this.nonEmpty) {
            return this.lock.commit();
        }
        this.logFile.delete();
        this.lock.unlock();
        return true;
    }

    void write(String content) throws IOException {
        if (content.length() > 0) {
            this.nonEmpty = true;
        }
        this.lock.write(content.getBytes(Constants.CHARSET));
    }
}

