/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.lib;

import com.netflix.nebula.lint.jgit.dircache.DirCache;
import com.netflix.nebula.lint.jgit.dircache.DirCacheEntry;
import com.netflix.nebula.lint.jgit.dircache.DirCacheIterator;
import com.netflix.nebula.lint.jgit.errors.ConfigInvalidException;
import com.netflix.nebula.lint.jgit.errors.IncorrectObjectTypeException;
import com.netflix.nebula.lint.jgit.errors.MissingObjectException;
import com.netflix.nebula.lint.jgit.errors.StopWalkException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.AnyObjectId;
import com.netflix.nebula.lint.jgit.lib.FileMode;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.ProgressMonitor;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import com.netflix.nebula.lint.jgit.submodule.SubmoduleWalk;
import com.netflix.nebula.lint.jgit.treewalk.AbstractTreeIterator;
import com.netflix.nebula.lint.jgit.treewalk.EmptyTreeIterator;
import com.netflix.nebula.lint.jgit.treewalk.FileTreeIterator;
import com.netflix.nebula.lint.jgit.treewalk.TreeWalk;
import com.netflix.nebula.lint.jgit.treewalk.WorkingTreeIterator;
import com.netflix.nebula.lint.jgit.treewalk.filter.AndTreeFilter;
import com.netflix.nebula.lint.jgit.treewalk.filter.IndexDiffFilter;
import com.netflix.nebula.lint.jgit.treewalk.filter.SkipWorkTreeFilter;
import com.netflix.nebula.lint.jgit.treewalk.filter.TreeFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IndexDiff {
    private static final int TREE = 0;
    private static final int INDEX = 1;
    private static final int WORKDIR = 2;
    private final Repository repository;
    private final AnyObjectId tree;
    private TreeFilter filter;
    private final WorkingTreeIterator initialWorkingTreeIterator;
    private Set<String> added;
    private Set<String> changed;
    private Set<String> removed;
    private Set<String> missing;
    private Set<String> modified;
    private Set<String> untracked;
    private Map<String, StageState> conflicts;
    private Set<String> ignored;
    private Set<String> assumeUnchanged;
    private DirCache dirCache;
    private IndexDiffFilter indexDiffFilter;
    private Map<String, IndexDiff> submoduleIndexDiffs;
    private SubmoduleWalk.IgnoreSubmoduleMode ignoreSubmoduleMode;
    private Map<FileMode, Set<String>> fileModes;
    private WorkingTreeIteratorFactory wTreeIt;

    public IndexDiff(Repository repository, String revstr, WorkingTreeIterator workingTreeIterator) throws IOException {
        this(repository, repository.resolve(revstr), workingTreeIterator);
    }

    public IndexDiff(Repository repository, ObjectId objectId, WorkingTreeIterator workingTreeIterator) throws IOException {
        block10: {
            this.filter = null;
            this.added = new HashSet<String>();
            this.changed = new HashSet<String>();
            this.removed = new HashSet<String>();
            this.missing = new HashSet<String>();
            this.modified = new HashSet<String>();
            this.untracked = new HashSet<String>();
            this.conflicts = new HashMap<String, StageState>();
            this.submoduleIndexDiffs = new HashMap<String, IndexDiff>();
            this.ignoreSubmoduleMode = null;
            this.fileModes = new HashMap<FileMode, Set<String>>();
            this.wTreeIt = new WorkingTreeIteratorFactory(){

                @Override
                public WorkingTreeIterator getWorkingTreeIterator(Repository repo) {
                    return new FileTreeIterator(repo);
                }
            };
            this.repository = repository;
            if (objectId != null) {
                Throwable throwable = null;
                Object var5_6 = null;
                try (RevWalk rw = new RevWalk(repository);){
                    this.tree = rw.parseTree(objectId);
                    break block10;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.tree = null;
        }
        this.initialWorkingTreeIterator = workingTreeIterator;
    }

    public void setIgnoreSubmoduleMode(SubmoduleWalk.IgnoreSubmoduleMode mode) {
        this.ignoreSubmoduleMode = mode;
    }

    public void setWorkingTreeItFactory(WorkingTreeIteratorFactory wTreeIt) {
        this.wTreeIt = wTreeIt;
    }

    public void setFilter(TreeFilter filter) {
        this.filter = filter;
    }

    public boolean diff() throws IOException {
        return this.diff(null, 0, 0, "");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean diff(ProgressMonitor monitor, int estWorkTreeSize, int estIndexSize, String title) throws IOException {
        this.dirCache = this.repository.readDirCache();
        Throwable throwable = null;
        Object var6_7 = null;
        try (TreeWalk treeWalk = new TreeWalk(this.repository);){
            treeWalk.setOperationType(TreeWalk.OperationType.CHECKIN_OP);
            treeWalk.setRecursive(true);
            if (this.tree != null) {
                treeWalk.addTree(this.tree);
            } else {
                treeWalk.addTree(new EmptyTreeIterator());
            }
            treeWalk.addTree(new DirCacheIterator(this.dirCache));
            treeWalk.addTree(this.initialWorkingTreeIterator);
            this.initialWorkingTreeIterator.setDirCacheIterator(treeWalk, 1);
            ArrayList<TreeFilter> filters = new ArrayList<TreeFilter>(4);
            if (monitor != null) {
                if (estIndexSize == 0) {
                    estIndexSize = this.dirCache.getEntryCount();
                }
                int total = Math.max(estIndexSize * 10 / 9, estWorkTreeSize * 10 / 9);
                monitor.beginTask(title, total);
                filters.add(new ProgressReportingFilter(monitor, total));
            }
            if (this.filter != null) {
                filters.add(this.filter);
            }
            filters.add(new SkipWorkTreeFilter(1));
            this.indexDiffFilter = new IndexDiffFilter(1, 2);
            filters.add(this.indexDiffFilter);
            treeWalk.setFilter(AndTreeFilter.create(filters));
            this.fileModes.clear();
            while (treeWalk.next()) {
                String path;
                WorkingTreeIterator workingTreeIterator;
                DirCacheIterator dirCacheIterator;
                block48: {
                    block47: {
                        int stage;
                        DirCacheEntry dirCacheEntry;
                        AbstractTreeIterator treeIterator = treeWalk.getTree(0, AbstractTreeIterator.class);
                        dirCacheIterator = treeWalk.getTree(1, DirCacheIterator.class);
                        workingTreeIterator = treeWalk.getTree(2, WorkingTreeIterator.class);
                        if (dirCacheIterator != null && (dirCacheEntry = dirCacheIterator.getDirCacheEntry()) != null && (stage = dirCacheEntry.getStage()) > 0) {
                            String path2 = treeWalk.getPathString();
                            this.addConflict(path2, stage);
                            continue;
                        }
                        if (treeIterator == null) break block47;
                        if (dirCacheIterator != null) {
                            if (!(treeIterator.idEqual(dirCacheIterator) && treeIterator.getEntryRawMode() == dirCacheIterator.getEntryRawMode() || this.isEntryGitLink(treeIterator) && this.isEntryGitLink(dirCacheIterator) && this.ignoreSubmoduleMode == SubmoduleWalk.IgnoreSubmoduleMode.ALL)) {
                                this.changed.add(treeWalk.getPathString());
                            }
                            break block48;
                        } else {
                            if (!this.isEntryGitLink(treeIterator) || this.ignoreSubmoduleMode != SubmoduleWalk.IgnoreSubmoduleMode.ALL) {
                                this.removed.add(treeWalk.getPathString());
                            }
                            if (workingTreeIterator != null) {
                                this.untracked.add(treeWalk.getPathString());
                            }
                        }
                        break block48;
                    }
                    if (dirCacheIterator != null) {
                        if (!this.isEntryGitLink(dirCacheIterator) || this.ignoreSubmoduleMode != SubmoduleWalk.IgnoreSubmoduleMode.ALL) {
                            this.added.add(treeWalk.getPathString());
                        }
                    } else if (workingTreeIterator != null && !workingTreeIterator.isEntryIgnored()) {
                        this.untracked.add(treeWalk.getPathString());
                    }
                }
                if (dirCacheIterator != null) {
                    if (workingTreeIterator == null) {
                        if (!this.isEntryGitLink(dirCacheIterator) || this.ignoreSubmoduleMode != SubmoduleWalk.IgnoreSubmoduleMode.ALL) {
                            this.missing.add(treeWalk.getPathString());
                        }
                    } else if (workingTreeIterator.isModified(dirCacheIterator.getDirCacheEntry(), true, treeWalk.getObjectReader()) && (!this.isEntryGitLink(dirCacheIterator) || !this.isEntryGitLink(workingTreeIterator) || this.ignoreSubmoduleMode != SubmoduleWalk.IgnoreSubmoduleMode.ALL && this.ignoreSubmoduleMode != SubmoduleWalk.IgnoreSubmoduleMode.DIRTY)) {
                        this.modified.add(treeWalk.getPathString());
                    }
                }
                if ((path = treeWalk.getPathString()) == null) continue;
                int i = 0;
                while (i < treeWalk.getTreeCount()) {
                    this.recordFileMode(path, treeWalk.getFileMode(i));
                    ++i;
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
        if (this.ignoreSubmoduleMode != SubmoduleWalk.IgnoreSubmoduleMode.ALL) {
            SubmoduleWalk.IgnoreSubmoduleMode localIgnoreSubmoduleMode = this.ignoreSubmoduleMode;
            SubmoduleWalk smw = SubmoduleWalk.forIndex(this.repository);
            while (smw.next()) {
                try {
                    if (localIgnoreSubmoduleMode == null) {
                        localIgnoreSubmoduleMode = smw.getModulesIgnore();
                    }
                    if (SubmoduleWalk.IgnoreSubmoduleMode.ALL.equals((Object)localIgnoreSubmoduleMode)) {
                        continue;
                    }
                }
                catch (ConfigInvalidException e) {
                    throw new IOException(MessageFormat.format(JGitText.get().invalidIgnoreParamSubmodule, smw.getPath()), e);
                }
                Throwable throwable3 = null;
                Object var8_12 = null;
                try {
                    Repository subRepo;
                    block46: {
                        String subRepoPath;
                        subRepo = smw.getRepository();
                        try {
                            if (subRepo == null) break block46;
                            subRepoPath = smw.getPath();
                            ObjectId subHead = subRepo.resolve("HEAD");
                            if (subHead != null && !subHead.equals(smw.getObjectId())) {
                                this.modified.add(subRepoPath);
                                this.recordFileMode(subRepoPath, FileMode.GITLINK);
                                break block46;
                            }
                            if (this.ignoreSubmoduleMode == SubmoduleWalk.IgnoreSubmoduleMode.DIRTY) break block46;
                            IndexDiff smid = this.submoduleIndexDiffs.get(smw.getPath());
                            if (smid == null) {
                                smid = new IndexDiff(subRepo, smw.getObjectId(), this.wTreeIt.getWorkingTreeIterator(subRepo));
                                this.submoduleIndexDiffs.put(subRepoPath, smid);
                            }
                            if (!smid.diff()) break block46;
                            if (this.ignoreSubmoduleMode == SubmoduleWalk.IgnoreSubmoduleMode.UNTRACKED && smid.getAdded().isEmpty() && smid.getChanged().isEmpty() && smid.getConflicting().isEmpty() && smid.getMissing().isEmpty() && smid.getModified().isEmpty() && smid.getRemoved().isEmpty()) {
                                if (subRepo == null) continue;
                                subRepo.close();
                                continue;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (subRepo == null) throw throwable4;
                            subRepo.close();
                            throw throwable4;
                        }
                        {
                            this.modified.add(subRepoPath);
                            this.recordFileMode(subRepoPath, FileMode.GITLINK);
                        }
                    }
                    if (subRepo == null) continue;
                    subRepo.close();
                }
                catch (Throwable throwable5) {
                    if (throwable3 == null) {
                        throwable3 = throwable5;
                        throw throwable3;
                    }
                    if (throwable3 == throwable5) throw throwable3;
                    throwable3.addSuppressed(throwable5);
                    throw throwable3;
                }
            }
        }
        if (monitor != null) {
            monitor.endTask();
        }
        this.ignored = this.indexDiffFilter.getIgnoredPaths();
        if (!this.added.isEmpty()) return true;
        if (!this.changed.isEmpty()) return true;
        if (!this.removed.isEmpty()) return true;
        if (!this.missing.isEmpty()) return true;
        if (!this.modified.isEmpty()) return true;
        if (!this.untracked.isEmpty()) return true;
        return false;
    }

    private void recordFileMode(String path, FileMode mode) {
        Set<String> values = this.fileModes.get(mode);
        if (path != null) {
            if (values == null) {
                values = new HashSet<String>();
                this.fileModes.put(mode, values);
            }
            values.add(path);
        }
    }

    private boolean isEntryGitLink(AbstractTreeIterator ti) {
        return ti != null && ti.getEntryRawMode() == FileMode.GITLINK.getBits();
    }

    private void addConflict(String path, int stage) {
        StageState existingStageStates = this.conflicts.get(path);
        int stageMask = 0;
        if (existingStageStates != null) {
            stageMask = (byte)(stageMask | existingStageStates.getStageMask());
        }
        int shifts = stage - 1;
        stageMask = (byte)(stageMask | 1 << shifts);
        StageState stageState = StageState.fromMask(stageMask);
        this.conflicts.put(path, stageState);
    }

    public Set<String> getAdded() {
        return this.added;
    }

    public Set<String> getChanged() {
        return this.changed;
    }

    public Set<String> getRemoved() {
        return this.removed;
    }

    public Set<String> getMissing() {
        return this.missing;
    }

    public Set<String> getModified() {
        return this.modified;
    }

    public Set<String> getUntracked() {
        return this.untracked;
    }

    public Set<String> getConflicting() {
        return this.conflicts.keySet();
    }

    public Map<String, StageState> getConflictingStageStates() {
        return this.conflicts;
    }

    public Set<String> getIgnoredNotInIndex() {
        return this.ignored;
    }

    public Set<String> getAssumeUnchanged() {
        if (this.assumeUnchanged == null) {
            HashSet<String> unchanged = new HashSet<String>();
            int i = 0;
            while (i < this.dirCache.getEntryCount()) {
                if (this.dirCache.getEntry(i).isAssumeValid()) {
                    unchanged.add(this.dirCache.getEntry(i).getPathString());
                }
                ++i;
            }
            this.assumeUnchanged = unchanged;
        }
        return this.assumeUnchanged;
    }

    public Set<String> getUntrackedFolders() {
        return this.indexDiffFilter == null ? Collections.emptySet() : new HashSet<String>(this.indexDiffFilter.getUntrackedFolders());
    }

    public FileMode getIndexMode(String path) {
        DirCacheEntry entry = this.dirCache.getEntry(path);
        return entry != null ? entry.getFileMode() : FileMode.MISSING;
    }

    public Set<String> getPathsWithIndexMode(FileMode mode) {
        Set<String> paths = this.fileModes.get(mode);
        if (paths == null) {
            paths = new HashSet<String>();
        }
        return paths;
    }

    private static final class ProgressReportingFilter
    extends TreeFilter {
        private final ProgressMonitor monitor;
        private int count = 0;
        private int stepSize;
        private final int total;

        private ProgressReportingFilter(ProgressMonitor monitor, int total) {
            this.monitor = monitor;
            this.total = total;
            this.stepSize = total / 100;
            if (this.stepSize == 0) {
                this.stepSize = 1000;
            }
        }

        @Override
        public boolean shouldBeRecursive() {
            return false;
        }

        @Override
        public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            ++this.count;
            if (this.count % this.stepSize == 0) {
                if (this.count <= this.total) {
                    this.monitor.update(this.stepSize);
                }
                if (this.monitor.isCancelled()) {
                    throw StopWalkException.INSTANCE;
                }
            }
            return true;
        }

        @Override
        public TreeFilter clone() {
            throw new IllegalStateException("Do not clone this kind of filter: " + this.getClass().getName());
        }
    }

    public static enum StageState {
        BOTH_DELETED(1),
        ADDED_BY_US(2),
        DELETED_BY_THEM(3),
        ADDED_BY_THEM(4),
        DELETED_BY_US(5),
        BOTH_ADDED(6),
        BOTH_MODIFIED(7);

        private final int stageMask;

        private StageState(int stageMask) {
            this.stageMask = stageMask;
        }

        int getStageMask() {
            return this.stageMask;
        }

        public boolean hasBase() {
            return (this.stageMask & 1) != 0;
        }

        public boolean hasOurs() {
            return (this.stageMask & 2) != 0;
        }

        public boolean hasTheirs() {
            return (this.stageMask & 4) != 0;
        }

        static StageState fromMask(int stageMask) {
            switch (stageMask) {
                case 1: {
                    return BOTH_DELETED;
                }
                case 2: {
                    return ADDED_BY_US;
                }
                case 3: {
                    return DELETED_BY_THEM;
                }
                case 4: {
                    return ADDED_BY_THEM;
                }
                case 5: {
                    return DELETED_BY_US;
                }
                case 6: {
                    return BOTH_ADDED;
                }
                case 7: {
                    return BOTH_MODIFIED;
                }
            }
            return null;
        }
    }

    public static interface WorkingTreeIteratorFactory {
        public WorkingTreeIterator getWorkingTreeIterator(Repository var1);
    }
}

