/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.lib;

import com.netflix.nebula.lint.jgit.annotations.NonNull;
import com.netflix.nebula.lint.jgit.annotations.Nullable;
import com.netflix.nebula.lint.jgit.lib.BatchRefUpdate;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.RefRename;
import com.netflix.nebula.lint.jgit.lib.RefUpdate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class RefDatabase {
    protected static final String[] SEARCH_PATH = new String[]{"", "refs/", "refs/tags/", "refs/heads/", "refs/remotes/"};
    public static final int MAX_SYMBOLIC_REF_DEPTH = 5;
    public static final String ALL = "";

    public abstract void create() throws IOException;

    public abstract void close();

    public abstract boolean isNameConflicting(String var1) throws IOException;

    @NonNull
    public Collection<String> getConflictingNames(String name) throws IOException {
        Map<String, Ref> allRefs = this.getRefs(ALL);
        int lastSlash = name.lastIndexOf(47);
        while (lastSlash > 0) {
            String needle = name.substring(0, lastSlash);
            if (allRefs.containsKey(needle)) {
                return Collections.singletonList(needle);
            }
            lastSlash = name.lastIndexOf(47, lastSlash - 1);
        }
        ArrayList<String> conflicting = new ArrayList<String>();
        String prefix = String.valueOf(name) + '/';
        for (String existing : allRefs.keySet()) {
            if (!existing.startsWith(prefix)) continue;
            conflicting.add(existing);
        }
        return conflicting;
    }

    @NonNull
    public abstract RefUpdate newUpdate(String var1, boolean var2) throws IOException;

    @NonNull
    public abstract RefRename newRename(String var1, String var2) throws IOException;

    @NonNull
    public BatchRefUpdate newBatchUpdate() {
        return new BatchRefUpdate(this);
    }

    public boolean performsAtomicTransactions() {
        return false;
    }

    @Nullable
    public abstract Ref getRef(String var1) throws IOException;

    @Nullable
    public Ref exactRef(String name) throws IOException {
        Ref ref = this.getRef(name);
        if (ref == null || !name.equals(ref.getName())) {
            return null;
        }
        return ref;
    }

    @NonNull
    public Map<String, Ref> exactRef(String ... refs) throws IOException {
        HashMap<String, Ref> result = new HashMap<String, Ref>(refs.length);
        String[] stringArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Ref ref = this.exactRef(name);
            if (ref != null) {
                result.put(name, ref);
            }
            ++n2;
        }
        return result;
    }

    @Nullable
    public Ref firstExactRef(String ... refs) throws IOException {
        String[] stringArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Ref ref = this.exactRef(name);
            if (ref != null) {
                return ref;
            }
            ++n2;
        }
        return null;
    }

    @NonNull
    public List<Ref> getRefs() throws IOException {
        return this.getRefsByPrefix(ALL);
    }

    @Deprecated
    @NonNull
    public abstract Map<String, Ref> getRefs(String var1) throws IOException;

    @NonNull
    public List<Ref> getRefsByPrefix(String prefix) throws IOException {
        List result;
        int lastSlash = prefix.lastIndexOf(47);
        Map<String, Ref> coarseRefs = lastSlash == -1 ? this.getRefs(ALL) : this.getRefs(prefix.substring(0, lastSlash + 1));
        if (lastSlash + 1 == prefix.length()) {
            result = coarseRefs.values().stream().collect(Collectors.toList());
        } else {
            String p = prefix.substring(lastSlash + 1);
            result = coarseRefs.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(p)).map(e -> (Ref)e.getValue()).collect(Collectors.toList());
        }
        return Collections.unmodifiableList(result);
    }

    public boolean hasRefs() throws IOException {
        return !this.getRefs().isEmpty();
    }

    @NonNull
    public abstract List<Ref> getAdditionalRefs() throws IOException;

    @NonNull
    public abstract Ref peel(Ref var1) throws IOException;

    public void refresh() {
    }

    @Nullable
    public static Ref findRef(Map<String, Ref> map, String name) {
        String[] stringArray = SEARCH_PATH;
        int n = SEARCH_PATH.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            String fullname = String.valueOf(prefix) + name;
            Ref ref = map.get(fullname);
            if (ref != null) {
                return ref;
            }
            ++n2;
        }
        return null;
    }
}

