/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.revwalk;

import com.netflix.nebula.lint.jgit.diff.DiffConfig;
import com.netflix.nebula.lint.jgit.errors.IncorrectObjectTypeException;
import com.netflix.nebula.lint.jgit.errors.MissingObjectException;
import com.netflix.nebula.lint.jgit.revwalk.RenameCallback;
import com.netflix.nebula.lint.jgit.treewalk.TreeWalk;
import com.netflix.nebula.lint.jgit.treewalk.filter.PathFilter;
import com.netflix.nebula.lint.jgit.treewalk.filter.TreeFilter;
import java.io.IOException;

public class FollowFilter
extends TreeFilter {
    private final PathFilter path;
    final DiffConfig cfg;
    private RenameCallback renameCallback;

    public static FollowFilter create(String path, DiffConfig cfg) {
        return new FollowFilter(PathFilter.create(path), cfg);
    }

    FollowFilter(PathFilter path, DiffConfig cfg) {
        this.path = path;
        this.cfg = cfg;
    }

    public String getPath() {
        return this.path.getPath();
    }

    @Override
    public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.path.include(walker) && ANY_DIFF.include(walker);
    }

    @Override
    public boolean shouldBeRecursive() {
        return this.path.shouldBeRecursive() || ANY_DIFF.shouldBeRecursive();
    }

    @Override
    public TreeFilter clone() {
        return new FollowFilter(this.path.clone(), this.cfg);
    }

    @Override
    public String toString() {
        return "(FOLLOW(" + this.path.toString() + ")" + " AND " + ANY_DIFF.toString() + ")";
    }

    public RenameCallback getRenameCallback() {
        return this.renameCallback;
    }

    public void setRenameCallback(RenameCallback callback) {
        this.renameCallback = callback;
    }
}

