/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.transport;

import com.netflix.nebula.lint.jgit.annotations.Nullable;
import com.netflix.nebula.lint.jgit.internal.storage.file.LazyObjectIdSetFile;
import com.netflix.nebula.lint.jgit.lib.Config;
import com.netflix.nebula.lint.jgit.lib.ObjectChecker;
import com.netflix.nebula.lint.jgit.lib.ObjectIdSet;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.transport.RefFilter;
import com.netflix.nebula.lint.jgit.util.StringUtils;
import com.netflix.nebula.lint.jgit.util.SystemReader;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class TransferConfig {
    private static final String FSCK = "fsck";
    public static final Config.SectionParser<TransferConfig> KEY = TransferConfig::new;
    private final boolean fetchFsck;
    private final boolean receiveFsck;
    private final String fsckSkipList;
    private final EnumSet<ObjectChecker.ErrorType> ignore;
    private final boolean allowInvalidPersonIdent;
    private final boolean safeForWindows;
    private final boolean safeForMacOS;
    private final boolean allowTipSha1InWant;
    private final boolean allowReachableSha1InWant;
    private final boolean allowFilter;
    @Nullable
    final ProtocolVersion protocolVersion;
    final String[] hideRefs;

    TransferConfig(Repository db) {
        this(db.getConfig());
    }

    TransferConfig(Config rc) {
        boolean fsck = rc.getBoolean("transfer", "fsckobjects", false);
        this.fetchFsck = rc.getBoolean("fetch", "fsckobjects", fsck);
        this.receiveFsck = rc.getBoolean("receive", "fsckobjects", fsck);
        this.fsckSkipList = rc.getString(FSCK, null, "skipList");
        this.allowInvalidPersonIdent = rc.getBoolean(FSCK, "allowInvalidPersonIdent", false);
        this.safeForWindows = rc.getBoolean(FSCK, "safeForWindows", SystemReader.getInstance().isWindows());
        this.safeForMacOS = rc.getBoolean(FSCK, "safeForMacOS", SystemReader.getInstance().isMacOS());
        this.ignore = EnumSet.noneOf(ObjectChecker.ErrorType.class);
        EnumSet<ObjectChecker.ErrorType> set = EnumSet.noneOf(ObjectChecker.ErrorType.class);
        for (String key : rc.getNames(FSCK)) {
            ObjectChecker.ErrorType id;
            if (StringUtils.equalsIgnoreCase(key, "skipList") || StringUtils.equalsIgnoreCase(key, "allowLeadingZeroFileMode") || StringUtils.equalsIgnoreCase(key, "allowInvalidPersonIdent") || StringUtils.equalsIgnoreCase(key, "safeForWindows") || StringUtils.equalsIgnoreCase(key, "safeForMacOS") || (id = FsckKeyNameHolder.parse(key)) == null) continue;
            switch (rc.getEnum(FSCK, null, key, FsckMode.ERROR)) {
                case ERROR: {
                    this.ignore.remove((Object)id);
                    break;
                }
                case WARN: 
                case IGNORE: {
                    this.ignore.add(id);
                }
            }
            set.add(id);
        }
        if (!set.contains((Object)ObjectChecker.ErrorType.ZERO_PADDED_FILEMODE) && rc.getBoolean(FSCK, "allowLeadingZeroFileMode", false)) {
            this.ignore.add(ObjectChecker.ErrorType.ZERO_PADDED_FILEMODE);
        }
        this.allowTipSha1InWant = rc.getBoolean("uploadpack", "allowtipsha1inwant", false);
        this.allowReachableSha1InWant = rc.getBoolean("uploadpack", "allowreachablesha1inwant", false);
        this.allowFilter = rc.getBoolean("uploadpack", "allowfilter", false);
        this.protocolVersion = ProtocolVersion.parse(rc.getString("protocol", null, "version"));
        this.hideRefs = rc.getStringList("uploadpack", null, "hiderefs");
    }

    @Nullable
    public ObjectChecker newObjectChecker() {
        return this.newObjectChecker(this.fetchFsck);
    }

    @Nullable
    public ObjectChecker newReceiveObjectChecker() {
        return this.newObjectChecker(this.receiveFsck);
    }

    private ObjectChecker newObjectChecker(boolean check) {
        if (!check) {
            return null;
        }
        return new ObjectChecker().setIgnore(this.ignore).setAllowInvalidPersonIdent(this.allowInvalidPersonIdent).setSafeForWindows(this.safeForWindows).setSafeForMacOS(this.safeForMacOS).setSkipList(this.skipList());
    }

    private ObjectIdSet skipList() {
        if (this.fsckSkipList != null && !this.fsckSkipList.isEmpty()) {
            return new LazyObjectIdSetFile(new File(this.fsckSkipList));
        }
        return null;
    }

    public boolean isAllowTipSha1InWant() {
        return this.allowTipSha1InWant;
    }

    public boolean isAllowReachableSha1InWant() {
        return this.allowReachableSha1InWant;
    }

    public boolean isAllowFilter() {
        return this.allowFilter;
    }

    public RefFilter getRefFilter() {
        if (this.hideRefs.length == 0) {
            return RefFilter.DEFAULT;
        }
        return new RefFilter(){

            @Override
            public Map<String, Ref> filter(Map<String, Ref> refs) {
                HashMap<String, Ref> result = new HashMap<String, Ref>();
                for (Map.Entry<String, Ref> e : refs.entrySet()) {
                    boolean add = true;
                    String[] stringArray = TransferConfig.this.hideRefs;
                    int n = TransferConfig.this.hideRefs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String hide = stringArray[n2];
                        if (e.getKey().equals(hide) || this.prefixMatch(hide, e.getKey())) {
                            add = false;
                            break;
                        }
                        ++n2;
                    }
                    if (!add) continue;
                    result.put(e.getKey(), e.getValue());
                }
                return result;
            }

            private boolean prefixMatch(String p, String s) {
                return p.charAt(p.length() - 1) == '/' && s.startsWith(p);
            }
        };
    }

    static class FsckKeyNameHolder {
        private static final Map<String, ObjectChecker.ErrorType> errors = new HashMap<String, ObjectChecker.ErrorType>();

        static {
            ObjectChecker.ErrorType[] errorTypeArray = ObjectChecker.ErrorType.values();
            int n = errorTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectChecker.ErrorType m = errorTypeArray[n2];
                errors.put(FsckKeyNameHolder.keyNameFor(m.name()), m);
                ++n2;
            }
        }

        @Nullable
        static ObjectChecker.ErrorType parse(String key) {
            return errors.get(StringUtils.toLowerCase(key));
        }

        private static String keyNameFor(String name) {
            StringBuilder r = new StringBuilder(name.length());
            int i = 0;
            while (i < name.length()) {
                char c = name.charAt(i);
                if (c != '_') {
                    r.append(c);
                }
                ++i;
            }
            return StringUtils.toLowerCase(r.toString());
        }

        private FsckKeyNameHolder() {
        }
    }

    public static enum FsckMode {
        ERROR,
        WARN,
        IGNORE;

    }

    static enum ProtocolVersion {
        V0("0"),
        V2("2");

        final String name;

        private ProtocolVersion(String name) {
            this.name = name;
        }

        @Nullable
        static ProtocolVersion parse(@Nullable String name) {
            if (name == null) {
                return null;
            }
            ProtocolVersion[] protocolVersionArray = ProtocolVersion.values();
            int n = protocolVersionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProtocolVersion v = protocolVersionArray[n2];
                if (v.name.equals(name)) {
                    return v;
                }
                ++n2;
            }
            return null;
        }
    }
}

