/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class PerforceShiftJISCharset
extends Charset {
    public static final boolean UNICODE_MAPPING = System.getProperty("unicodeMapping", System.getProperty("com.perforce.p4java.unicodeMapping", null)) != null;
    private static final String CHARSET_NAME = "MS932";
    Charset charset = Charset.forName("MS932");

    protected PerforceShiftJISCharset(String canonical, String[] aliases) {
        super(canonical, aliases);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this, this.charset.newEncoder());
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this, this.charset.newDecoder());
    }

    public boolean contains(Charset cs) {
        return this.getClass().isInstance(cs);
    }

    private void update(CharBuffer cb) {
        if (UNICODE_MAPPING) {
            block4: for (int pos = cb.position(); pos < cb.limit(); ++pos) {
                char c = cb.get(pos);
                switch (c) {
                    case '\\': {
                        cb.put(pos, '\u00a5');
                        continue block4;
                    }
                    case '~': {
                        cb.put(pos, '\u203e');
                        continue block4;
                    }
                }
            }
        }
    }

    private class Decoder
    extends CharsetDecoder {
        private CharsetDecoder decoder;

        Decoder(Charset cs, CharsetDecoder decoder) {
            super(cs, decoder.averageCharsPerByte(), decoder.maxCharsPerByte());
            this.decoder = decoder;
        }

        protected CoderResult decodeLoop(ByteBuffer bb, CharBuffer cb) {
            this.decoder.reset();
            CoderResult result = this.decoder.decode(bb, cb, true);
            PerforceShiftJISCharset.this.update(cb);
            return result;
        }
    }

    private class Encoder
    extends CharsetEncoder {
        private CharsetEncoder encoder;

        Encoder(Charset cs, CharsetEncoder encoder) {
            super(cs, encoder.averageBytesPerChar(), encoder.maxBytesPerChar());
            this.encoder = encoder;
        }

        protected CoderResult encodeLoop(CharBuffer cb, ByteBuffer bb) {
            CharBuffer tmpcb = CharBuffer.allocate(cb.remaining());
            while (cb.hasRemaining()) {
                tmpcb.put(cb.get());
            }
            tmpcb.rewind();
            PerforceShiftJISCharset.this.update(tmpcb);
            this.encoder.reset();
            CoderResult cr = this.encoder.encode(tmpcb, bb, true);
            cb.position(cb.position() - tmpcb.remaining());
            return cr;
        }
    }
}

