/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.IJobSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.ServerResource;
import com.perforce.p4java.server.IServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobSpec
extends ServerResource
implements IJobSpec {
    private String comments = null;
    private List<IJobSpec.IJobSpecField> fields = new ArrayList<IJobSpec.IJobSpecField>();
    private Map<String, String> presets = new HashMap<String, String>();
    private Map<String, List<String>> values = new HashMap<String, List<String>>();

    public JobSpec() {
    }

    public JobSpec(Map<String, Object> map, IServer server) {
        super(true, false);
        this.server = server;
        if (map != null) {
            try {
                this.comments = (String)map.get("Comments");
                String fieldStr = null;
                int i = 0;
                while ((fieldStr = (String)map.get("Fields" + i)) != null) {
                    this.fields.add(new JobSpecField(fieldStr));
                    ++i;
                }
                String valueStr = null;
                int i2 = 0;
                while ((valueStr = (String)map.get("Values" + i2)) != null) {
                    String[] values = valueStr.trim().split(" ");
                    if (values != null && values.length == 2 && values[0] != null) {
                        String[] vStrs;
                        ArrayList<String> valList = new ArrayList<String>();
                        if (values[1] != null && (vStrs = values[1].trim().split("/")) != null) {
                            for (String str : vStrs) {
                                if (str == null) continue;
                                valList.add(str);
                            }
                        }
                        this.values.put(values[0], valList);
                    }
                    ++i2;
                }
                String presetStr = null;
                int i3 = 0;
                while ((presetStr = (String)map.get("Presets" + i3)) != null) {
                    int firstSpace = presetStr.indexOf(" ");
                    if (firstSpace > 0 && firstSpace < presetStr.length() + 1) {
                        String key = presetStr.substring(0, firstSpace);
                        String value = presetStr.substring(firstSpace + 1);
                        if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 2) {
                            value = value.substring(1, value.length() - 2);
                        }
                        this.presets.put(key, value);
                    }
                    ++i3;
                }
            }
            catch (Exception exc) {
                Log.error("Unexpected exception: " + exc.getLocalizedMessage());
                Log.exception(exc);
                throw new P4JavaError("Unexpected conversion exception in JobSpec constructor: " + exc.getLocalizedMessage());
            }
        }
    }

    @Override
    public void complete() throws ConnectionException, RequestException, AccessException {
        this.refresh();
    }

    @Override
    public void refresh() throws ConnectionException, RequestException, AccessException {
        IJobSpec refreshedJobSpec;
        IServer refreshServer = this.server;
        if (refreshServer != null && (refreshedJobSpec = refreshServer.getJobSpec()) != null) {
            this.comments = refreshedJobSpec.getComments();
            this.fields = refreshedJobSpec.getFields();
            this.presets = refreshedJobSpec.getPresets();
            this.values = refreshedJobSpec.getValues();
        }
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public List<IJobSpec.IJobSpecField> getFields() {
        return this.fields;
    }

    @Override
    public Map<String, String> getPresets() {
        return this.presets;
    }

    @Override
    public Map<String, List<String>> getValues() {
        return this.values;
    }

    @Override
    public List<String> getFieldValues(String fieldName) {
        return this.values.get(fieldName);
    }

    @Override
    public String getFieldPreset(String fieldName) {
        return this.presets.get(fieldName);
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public void setFields(List<IJobSpec.IJobSpecField> fields) {
        this.fields = fields;
    }

    @Override
    public void setPresets(Map<String, String> presets) {
        this.presets = presets;
    }

    @Override
    public void setValues(Map<String, List<String>> values) {
        this.values = values;
    }

    protected class JobSpecField
    implements IJobSpec.IJobSpecField {
        private int code = 0;
        private String dataType = null;
        private String fieldType = null;
        private int length = 0;
        private String name = null;

        protected JobSpecField() {
        }

        protected JobSpecField(String fieldStr) {
            if (fieldStr != null) {
                try {
                    String[] fields = fieldStr.split(" ");
                    if (fields == null || fields.length != 5) {
                        throw new P4JavaError("Field conversion or format error in JobSpecField constructor");
                    }
                    if (fields[0] != null) {
                        this.code = new Integer(fields[0].trim());
                    }
                    if (fields[1] != null) {
                        this.name = fields[1].trim();
                    }
                    if (fields[2] != null) {
                        this.dataType = fields[2].trim();
                    }
                    if (fields[3] != null) {
                        this.length = new Integer(fields[3].trim());
                    }
                    if (fields[4] != null) {
                        this.fieldType = fields[4].trim();
                    }
                }
                catch (Exception exc) {
                    Log.exception(exc);
                    throw new P4JavaError("Field conversion or format error in JobSpecField constructor: " + exc.getLocalizedMessage());
                }
            }
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

