/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.impl.generic.core.ServerResource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamSummary
extends ServerResource
implements IStreamSummary {
    protected String stream = null;
    protected Date accessed = null;
    protected Date updated = null;
    protected String name = null;
    protected String ownerName = null;
    protected String description = null;
    protected String parent = null;
    protected IStreamSummary.Type type = null;
    protected IStreamSummary.IOptions options = new Options();
    protected String baseParent = null;
    protected boolean firmerThanParent = false;
    protected boolean changeFlowsToParent = false;
    protected boolean changeFlowsFromParent = false;
    protected boolean unloaded = false;

    public StreamSummary() {
    }

    public StreamSummary(boolean summaryOnly) {
        super(!summaryOnly, !summaryOnly);
    }

    public StreamSummary(boolean summaryOnly, String stream, Date accessed, Date updated, String name, String ownerName, String description, String parent, IStreamSummary.Type type, Options options) {
        super(!summaryOnly, !summaryOnly);
        this.stream = stream;
        this.accessed = accessed;
        this.updated = updated;
        this.name = name;
        this.ownerName = ownerName;
        this.description = description;
        this.parent = parent;
        this.type = type;
        this.options = options;
    }

    public StreamSummary(Map<String, Object> map, boolean summaryOnly) {
        super(!summaryOnly, !summaryOnly);
        if (map != null) {
            try {
                if (summaryOnly) {
                    this.description = (String)map.get("desc");
                    this.accessed = new Date(Long.parseLong((String)map.get("Access")) * 1000L);
                    this.updated = new Date(Long.parseLong((String)map.get("Update")) * 1000L);
                } else {
                    String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
                    this.description = (String)map.get("Description");
                    if (map.containsKey("Update")) {
                        this.updated = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse((String)map.get("Update"));
                    }
                    if (map.containsKey("Access")) {
                        this.accessed = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse((String)map.get("Access"));
                    }
                }
            }
            catch (Throwable thr) {
                Log.warn("Unexpected exception in StreamSummary constructor: " + thr.getMessage());
                Log.exception(thr);
            }
            this.stream = (String)map.get("Stream");
            this.name = (String)map.get("Name");
            this.ownerName = (String)map.get("Owner");
            this.parent = (String)map.get("Parent");
            if (map.containsKey("Type") && map.get("Type") != null) {
                this.type = IStreamSummary.Type.fromString(((String)map.get("Type")).toUpperCase());
            }
            this.options = new Options((String)map.get("Options"));
            this.firmerThanParent = new Boolean((String)map.get("firmerThanParent"));
            this.changeFlowsToParent = new Boolean((String)map.get("changeFlowsToParent"));
            this.changeFlowsFromParent = new Boolean((String)map.get("changeFlowsFromParent"));
            this.baseParent = (String)map.get("baseParent");
            if (map.get("IsUnloaded") != null && ((String)map.get("IsUnloaded")).equals("1")) {
                this.unloaded = true;
            }
        }
    }

    @Override
    public String getStream() {
        return this.stream;
    }

    @Override
    public void setStream(String stream) {
        this.stream = stream;
    }

    @Override
    public Date getAccessed() {
        return this.accessed;
    }

    @Override
    public void setAccessed(Date accessed) {
        this.accessed = accessed;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getParent() {
        return this.parent;
    }

    @Override
    public void setParent(String parent) {
        this.parent = parent;
    }

    @Override
    public IStreamSummary.Type getType() {
        return this.type;
    }

    @Override
    public void setType(IStreamSummary.Type type) {
        this.type = type;
    }

    @Override
    public IStreamSummary.IOptions getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(IStreamSummary.IOptions options) {
        this.options = options;
    }

    @Override
    public boolean isFirmerThanParent() {
        return this.firmerThanParent;
    }

    @Override
    public void setFirmerThanParent(boolean firmerThanParent) {
        this.firmerThanParent = firmerThanParent;
    }

    @Override
    public boolean isChangeFlowsToParent() {
        return this.changeFlowsToParent;
    }

    @Override
    public void setChangeFlowsToParent(boolean changeFlowsToParent) {
        this.changeFlowsToParent = changeFlowsToParent;
    }

    @Override
    public boolean isChangeFlowsFromParent() {
        return this.changeFlowsFromParent;
    }

    @Override
    public void setChangeFlowsFromParent(boolean changeFlowsFromParent) {
        this.changeFlowsFromParent = changeFlowsFromParent;
    }

    @Override
    public String getBaseParent() {
        return this.baseParent;
    }

    @Override
    public void setBaseParent(String baseParent) {
        this.baseParent = baseParent;
    }

    @Override
    public boolean isUnloaded() {
        return this.unloaded;
    }

    public static class Options
    implements IStreamSummary.IOptions {
        private boolean ownerSubmit = false;
        private boolean locked = false;
        private boolean noToParent = false;
        private boolean noFromParent = false;

        public Options() {
        }

        public Options(boolean ownerSubmit, boolean locked, boolean noToParent, boolean noFromParent) {
            this.ownerSubmit = ownerSubmit;
            this.locked = locked;
            this.noToParent = noToParent;
            this.noFromParent = noFromParent;
        }

        public Options(String optionsString) {
            if (optionsString != null) {
                String[] opts;
                for (String str : opts = optionsString.split(" ")) {
                    if (str.equalsIgnoreCase("ownersubmit")) {
                        this.ownerSubmit = true;
                        continue;
                    }
                    if (str.equalsIgnoreCase("locked")) {
                        this.locked = true;
                        continue;
                    }
                    if (str.equalsIgnoreCase("notoparent")) {
                        this.noToParent = true;
                        continue;
                    }
                    if (!str.equalsIgnoreCase("nofromparent")) continue;
                    this.noFromParent = true;
                }
            }
        }

        public String toString() {
            return (this.ownerSubmit ? "ownersubmit" : "allsubmit") + (this.locked ? " locked" : " unlocked") + (this.noToParent ? " notoparent" : " toparent") + (this.noFromParent ? " nofromparent" : " fromparent");
        }

        public boolean isOwnerSubmit() {
            return this.ownerSubmit;
        }

        public void setOwnerSubmit(boolean ownerSubmit) {
            this.ownerSubmit = ownerSubmit;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
        }

        public boolean isNoToParent() {
            return this.noToParent;
        }

        public void setNoToParent(boolean noToParent) {
            this.noToParent = noToParent;
        }

        public boolean isNoFromParent() {
            return this.noFromParent;
        }

        public void setNoFromParent(boolean noFromParent) {
            this.noFromParent = noFromParent;
        }
    }
}

