/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core.file;

import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.p4java.core.file.IRevisionIntegrationData;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRevisionData
implements IFileRevisionData {
    private int revision = 0;
    private int changeListId = -1;
    private FileAction action = null;
    private Date date = null;
    private String userName = null;
    private String fileType = null;
    private String description = null;
    private String depotFileName = null;
    private String clientName = null;
    private List<IRevisionIntegrationData> revisionIntegrationData = null;

    public FileRevisionData() {
    }

    public FileRevisionData(int revision, int changeListId, FileAction action, Date date, String userName, String fileType, String description, String depotFileName, String clientName) {
        this.revision = revision;
        this.changeListId = changeListId;
        this.action = action;
        this.date = date;
        this.userName = userName;
        this.fileType = fileType;
        this.description = description;
        this.depotFileName = depotFileName;
        this.clientName = clientName;
    }

    public FileRevisionData(Map<String, Object> map, int revNo) {
        if (map != null) {
            String revStr = "";
            if (map != null) {
                if (revNo >= 0) {
                    revStr = revStr + revNo;
                }
                this.setRevision(new Integer((String)map.get("rev" + revNo)));
                String changeId = (String)map.get("change" + revStr);
                if (changeId != null) {
                    if (changeId.equalsIgnoreCase("default")) {
                        this.setChangelistId(0);
                    } else {
                        this.setChangelistId(new Integer(changeId));
                    }
                }
                this.setAction(FileAction.fromString((String)map.get("action" + revStr)));
                this.setDate(new Date(Long.parseLong((String)map.get("time" + revStr)) * 1000L));
                this.setUserName((String)map.get("user" + revStr));
                this.setFileType((String)map.get("type" + revStr));
                this.setDescription((String)map.get("desc" + revStr));
                this.setDepotFileName((String)map.get("depotFile"));
                this.setClientName((String)map.get("client" + revStr));
                int revRev = 0;
                String fromFile = (String)map.get("file" + revNo + "," + revRev);
                while (fromFile != null) {
                    if (this.revisionIntegrationData == null) {
                        this.revisionIntegrationData = new ArrayList<IRevisionIntegrationData>();
                    }
                    this.revisionIntegrationData.add(new RevisionIntegrationData((String)map.get("srev" + revNo + "," + revRev), (String)map.get("erev" + revNo + "," + revRev), fromFile, (String)map.get("how" + revNo + "," + revRev)));
                    fromFile = (String)map.get("file" + revNo + "," + ++revRev);
                }
            }
        }
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getChangelistId() {
        return this.changeListId;
    }

    public void setChangelistId(int changeListId) {
        this.changeListId = changeListId;
    }

    @Override
    public FileAction getAction() {
        return this.action;
    }

    public void setAction(FileAction action) {
        this.action = action;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDepotFileName() {
        return this.depotFileName;
    }

    public void setDepotFileName(String depotFileName) {
        this.depotFileName = depotFileName;
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Override
    public List<IRevisionIntegrationData> getRevisionIntegrationData() {
        return this.revisionIntegrationData;
    }

    public class RevisionIntegrationData
    implements IRevisionIntegrationData {
        private int startFromRev = 0;
        private int endFromRev = 0;
        private String fromFile = null;
        private String howFrom = null;

        public RevisionIntegrationData(String startFromRev, String endFromRev, String fromFile, String howFrom) {
            this.startFromRev = FileSpec.getRevFromString(startFromRev);
            this.endFromRev = FileSpec.getRevFromString(endFromRev);
            this.fromFile = fromFile;
            this.howFrom = howFrom;
        }

        public int getEndFromRev() {
            return this.endFromRev;
        }

        public String getFromFile() {
            return this.fromFile;
        }

        public String getHowFrom() {
            return this.howFrom;
        }

        public int getStartFromRev() {
            return this.startFromRev;
        }
    }
}

