/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunction;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionMetadata;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionType;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketField;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RpcFunctionSpec {
    NONE,
    PROTOCOL_PROTOCOL,
    PROTOCOL_FLUSH1,
    PROTOCOL_FLUSH2,
    PROTOCOL_RELEASE,
    PROTOCOL_RELEASE2,
    PROTOCOL_CRYPTO,
    PROTOCOL_COMPRESS1,
    PROTOCOL_COMPRESS2,
    USER_SPECIFIED,
    USER_DEPOTS,
    USER_INFO,
    USER_FILES,
    USER_CLIENTS,
    USER_JOBS,
    USER_CHANGES,
    USER_LOGIN,
    USER_LOGOUT,
    USER_CLIENT,
    USER_FSTAT,
    USER_SYNC,
    USER_CHANGE,
    USER_DESCRIBE,
    USER_OPENED,
    USER_EDIT,
    USER_ADD,
    USER_DELETE,
    USER_REVERT,
    USER_SUBMIT,
    USER_FILELOG,
    USER_PRINT,
    USER_WHERE,
    USER_HAVE,
    USER_REOPEN,
    USER_DIRS,
    USER_INTEG,
    USER_RESOLVE,
    USER_RESOLVED,
    USER_FIXES,
    USER_JOBSPEC,
    USER_FIX,
    USER_JOB,
    USER_LOCK,
    USER_UNLOCK,
    USER_DIFF,
    USER_COUNTERS,
    USER_USERS,
    USER_MOVE,
    USER_LABELS,
    USER_LABEL,
    USER_LABELSYNC,
    USER_TAG,
    USER_MONITOR,
    USER_GROUP,
    USER_GROUPS,
    USER_BRANCH,
    USER_BRANCHES,
    USER_COUNTER,
    USER_INTEGRATED,
    USER_ANNOTATE,
    USER_DBSCHEMA,
    USER_EXPORT,
    USER_SHELVE,
    USER_UNSHELVE,
    USER_PROTECTS,
    USER_PROTECT,
    USER_USER,
    USER_REVIEWS,
    USER_REVIEW,
    USER_DIFF2,
    USER_INTERCHANGES,
    USER_GREP,
    USER_DEPOT,
    USER_ATTRIBUTE,
    USER_SPEC,
    USER_COPY,
    USER_CONFIGURE,
    USER_PASSWD,
    USER_DISKSPACE,
    USER_OBLITERATE,
    USER_STREAMS,
    USER_STREAM,
    USER_ISTAT,
    USER_MERGE,
    USER_LOGTAIL,
    USER_TRUST,
    USER_RECONCILE,
    USER_DUPLICATE,
    USER_UNLOAD,
    USER_RELOAD,
    USER_POPULATE,
    USER_KEY,
    USER_KEYS,
    USER_SEARCH,
    USER_PROPERTY,
    USER_SIZES,
    USER_JOURNALWAIT,
    USER_TRIGGERS,
    USER_VERIFY,
    USER_RENAMEUSER,
    CLIENT_MESSAGE,
    CLIENT_FSTATINFO,
    CLIENT_PROMPT,
    CLIENT_SETPASSWORD,
    CLIENT_CRYPTO,
    CLIENT_ACK,
    CLIENT_CHMODFILE,
    CLIENT_OPENFILE,
    CLIENT_OPENDIFF,
    CLIENT_WRITEFILE,
    CLIENT_CLOSEFILE,
    CLIENT_CHECKFILE,
    CLIENT_INPUTDATA,
    CLIENT_SENDFILE,
    CLIENT_DELETEFILE,
    CLIENT_OUTPUTBINARY,
    CLIENT_OUTPUTERROR,
    CLIENT_OUTPUTTEXT,
    CLIENT_OUTPUTDATA,
    CLIENT_OUTPUTINFO,
    CLIENT_MOVEFILE,
    CLIENT_OPENMERGE3,
    CLIENT_WRITEMERGE,
    CLIENT_CLOSEMERGE,
    CLIENT_SSO,
    CLIENT_OPENMERGE2,
    CLIENT_RECONCILEEDIT,
    CLIENT_RECONCILEADD,
    CLIENT_RECONCILEFLUSH,
    CLIENT_PROGRESS,
    CLIENT_DM_PROMPT,
    CLIENT_DM_OPENFILE,
    CLIENT_DM_MOVEFILE,
    SERVER_DM_LOGIN,
    SERVER_DM_PASSWD,
    SERVER_DM_SUBMITCHANGE,
    SERVER_LBR_OPEN,
    SERVER_DM_LBR_OPEN,
    SERVER_LBR_WRITEFILE,
    SERVER_DM_SUBMITFILE,
    SERVER_DM_COMMITSUBMIT,
    SERVER_RELEASEFILE,
    SERVER_CMPFILE,
    SERVER_DM_RESOLVEDFILE,
    SERVER_DM_RESOLVEDFAILED,
    SERVER_RECONCILEFILE,
    SERVER_RECONCILEADDS;


    public static RpcFunctionSpec decode(String str) {
        if (str == null) {
            throw new NullPointerError("Null string passed to RpcFunction.decode()");
        }
        return RpcFunction.getMetadata(str, false).getName();
    }

    public static RpcFunctionSpec decode(String str, boolean relaxedCheck) {
        if (str == null) {
            throw new NullPointerError("Null string passed to RpcFunction.decode()");
        }
        RpcFunctionMetadata metadata = RpcFunction.getMetadata(str, relaxedCheck);
        if (metadata == null) {
            return USER_SPECIFIED;
        }
        return metadata.getName();
    }

    public static RpcFunctionSpec decodeFromEndUserCmd(String str, boolean relaxedCheck) {
        if (str == null) {
            throw new NullPointerError("Null string passed to RpcFunction.decodeFromEndUserCmd()");
        }
        return RpcFunctionSpec.decode(RpcFunctionType.USER.getEncodingPrefix() + str, relaxedCheck);
    }

    public String getEncoding() {
        return RpcFunction.getMetadata(this).getEncoding();
    }

    public RpcFunctionType getType() {
        return RpcFunction.getMetadata(this).getType();
    }

    public void marshal(ByteBuffer buf) {
        if (buf == null) {
            throw new NullPointerError("Null byte buffer passed to RpcFunctionSpec.marshal()");
        }
        try {
            RpcPacketField.marshal(buf, "func", this.getEncoding().getBytes(CharsetDefs.DEFAULT.name()));
        }
        catch (UnsupportedEncodingException uee) {
            Log.exception(uee);
            throw new P4JavaError(uee);
        }
    }
}

