/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys.helper;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.FileDecoderException;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import com.perforce.p4java.io.apple.AppleFileData;
import com.perforce.p4java.io.apple.AppleFileDecoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class AppleFileHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void extractFile(RpcPerforceFile file) {
        block27: {
            if (file.getFileType() == RpcPerforceFileType.FST_APPLEFILE) {
                Exception e2222;
                FileOutputStream fosResource;
                FileOutputStream fosData;
                block25: {
                    block24: {
                        fosData = null;
                        fosResource = null;
                        byte[] data = AppleFileHelper.getBytesFromFile(file);
                        AppleFileData fileData = new AppleFileData(data);
                        AppleFileDecoder appleFile = new AppleFileDecoder(fileData);
                        appleFile.extract();
                        fosData = new FileOutputStream(file);
                        AppleFileData forkData = appleFile.getDataFork();
                        if (forkData != AppleFileData.EMPTY_FILE_DATA) {
                            fosData.write(forkData.getBytes());
                        }
                        String resourceFilePath = file.getParent() + File.separator + "%" + file.getName();
                        RpcPerforceFile targetResourceFile = new RpcPerforceFile(resourceFilePath, file.getFileType());
                        fosResource = new FileOutputStream(targetResourceFile);
                        AppleFileData forkResource = appleFile.getResourceFork();
                        if (forkResource == AppleFileData.EMPTY_FILE_DATA) break block24;
                        fosResource.write(forkResource.getBytes());
                    }
                    Object var11_12 = null;
                    if (fosData == null) break block25;
                    try {
                        fosData.close();
                    }
                    catch (Exception e2222) {
                        // empty catch block
                    }
                }
                if (fosResource != null) {
                    try {
                        fosResource.close();
                    }
                    catch (Exception e2222) {}
                }
                break block27;
                {
                    catch (IOException e3) {
                        Exception e2222;
                        Log.error("Problem handling the Apple file: " + file.getName());
                        Object var11_13 = null;
                        if (fosData != null) {
                            try {
                                fosData.close();
                            }
                            catch (Exception e2222) {
                                // empty catch block
                            }
                        }
                        if (fosResource != null) {
                            try {
                                fosResource.close();
                            }
                            catch (Exception e2222) {}
                        }
                        break block27;
                    }
                    catch (FileDecoderException e4) {
                        Exception e2222;
                        Log.error("Problem decoding the Apple file: " + file.getName());
                        Object var11_14 = null;
                        if (fosData != null) {
                            try {
                                fosData.close();
                            }
                            catch (Exception e2222) {
                                // empty catch block
                            }
                        }
                        if (fosResource != null) {
                            try {
                                fosResource.close();
                            }
                            catch (Exception e2222) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                    Exception e2222;
                    Object var11_15 = null;
                    if (fosData != null) {
                        try {
                            fosData.close();
                        }
                        catch (Exception e2222) {
                            // empty catch block
                        }
                    }
                    if (fosResource != null) {
                        try {
                            fosResource.close();
                        }
                        catch (Exception e2222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Apple file too large for decoding.");
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        try {
            int offset;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read the Apple file " + file.getName());
            }
            Object var8_6 = null;
            if (is == null) return bytes;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (is == null) throw throwable;
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((InputStream)is).close();
            return bytes;
        }
        catch (IOException e) {}
        return bytes;
    }
}

