/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.channel;

import com.trilead.ssh2.channel.Channel;
import com.trilead.ssh2.channel.IChannelWorkerThread;
import com.trilead.ssh2.channel.RemoteAcceptThread;
import com.trilead.ssh2.channel.RemoteForwardingData;
import com.trilead.ssh2.channel.RemoteX11AcceptThread;
import com.trilead.ssh2.channel.X11ServerData;
import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.packets.PacketChannelOpenConfirmation;
import com.trilead.ssh2.packets.PacketChannelOpenFailure;
import com.trilead.ssh2.packets.PacketChannelTrileadPing;
import com.trilead.ssh2.packets.PacketGlobalCancelForwardRequest;
import com.trilead.ssh2.packets.PacketGlobalForwardRequest;
import com.trilead.ssh2.packets.PacketGlobalTrileadPing;
import com.trilead.ssh2.packets.PacketOpenDirectTCPIPChannel;
import com.trilead.ssh2.packets.PacketOpenSessionChannel;
import com.trilead.ssh2.packets.PacketSessionExecCommand;
import com.trilead.ssh2.packets.PacketSessionPtyRequest;
import com.trilead.ssh2.packets.PacketSessionStartShell;
import com.trilead.ssh2.packets.PacketSessionSubsystemRequest;
import com.trilead.ssh2.packets.PacketSessionX11Request;
import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.transport.MessageHandler;
import com.trilead.ssh2.transport.TransportManager;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Vector;

public class ChannelManager
implements MessageHandler {
    private static final Logger log = Logger.getLogger(ChannelManager.class);
    private HashMap x11_magic_cookies = new HashMap();
    private TransportManager tm;
    private Vector channels = new Vector();
    private int nextLocalChannel = 100;
    private boolean shutdown = false;
    private int globalSuccessCounter = 0;
    private int globalFailedCounter = 0;
    private HashMap remoteForwardings = new HashMap();
    private Vector listenerThreads = new Vector();
    private boolean listenerThreadsAllowed = true;

    public ChannelManager(TransportManager tm) {
        this.tm = tm;
        tm.registerMessageHandler(this, 80, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel getChannel(int id) {
        Vector vector = this.channels;
        synchronized (vector) {
            for (int i = 0; i < this.channels.size(); ++i) {
                Channel c = (Channel)this.channels.elementAt(i);
                if (c.localID != id) continue;
                return c;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChannel(int id) {
        Vector vector = this.channels;
        synchronized (vector) {
            for (int i = 0; i < this.channels.size(); ++i) {
                Channel c = (Channel)this.channels.elementAt(i);
                if (c.localID != id) continue;
                this.channels.removeElementAt(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addChannel(Channel c) {
        Vector vector = this.channels;
        synchronized (vector) {
            this.channels.addElement(c);
            return this.nextLocalChannel++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilChannelOpen(Channel c) throws IOException {
        Channel channel = c;
        synchronized (channel) {
            while (c.state == 1) {
                try {
                    c.wait();
                }
                catch (InterruptedException ignore) {
                    throw new InterruptedIOException();
                }
            }
            if (c.state != 2) {
                this.removeChannel(c.localID);
                String detail = c.getReasonClosed();
                if (detail == null) {
                    detail = "state: " + c.state;
                }
                throw new IOException("Could not open channel (" + detail + ")");
            }
        }
    }

    private final boolean waitForGlobalRequestResult() throws IOException {
        Vector vector = this.channels;
        synchronized (vector) {
            while (this.globalSuccessCounter == 0 && this.globalFailedCounter == 0) {
                if (this.shutdown) {
                    throw new IOException("The connection is being shutdown");
                }
                try {
                    this.channels.wait();
                }
                catch (InterruptedException ignore) {
                    throw new InterruptedIOException();
                }
            }
            if (this.globalFailedCounter == 0 && this.globalSuccessCounter == 1) {
                return true;
            }
            if (this.globalFailedCounter == 1 && this.globalSuccessCounter == 0) {
                return false;
            }
            throw new IOException("Illegal state. The server sent " + this.globalSuccessCounter + " SSH_MSG_REQUEST_SUCCESS and " + this.globalFailedCounter + " SSH_MSG_REQUEST_FAILURE messages.");
        }
    }

    private final boolean waitForChannelRequestResult(Channel c) throws IOException {
        Channel channel = c;
        synchronized (channel) {
            while (c.successCounter == 0 && c.failedCounter == 0) {
                if (c.state != 2) {
                    String detail = c.getReasonClosed();
                    if (detail == null) {
                        detail = "state: " + c.state;
                    }
                    throw new IOException("This SSH2 channel is not open (" + detail + ")");
                }
                try {
                    c.wait();
                }
                catch (InterruptedException ignore) {
                    throw new InterruptedIOException();
                }
            }
            if (c.failedCounter == 0 && c.successCounter == 1) {
                return true;
            }
            if (c.failedCounter == 1 && c.successCounter == 0) {
                return false;
            }
            throw new IOException("Illegal state. The server sent " + c.successCounter + " SSH_MSG_CHANNEL_SUCCESS and " + c.failedCounter + " SSH_MSG_CHANNEL_FAILURE messages.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerX11Cookie(String hexFakeCookie, X11ServerData data) {
        HashMap hashMap = this.x11_magic_cookies;
        synchronized (hashMap) {
            this.x11_magic_cookies.put(hexFakeCookie, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterX11Cookie(String hexFakeCookie, boolean killChannels) {
        Vector channel_copy;
        if (hexFakeCookie == null) {
            throw new IllegalStateException("hexFakeCookie may not be null");
        }
        HashMap hashMap = this.x11_magic_cookies;
        synchronized (hashMap) {
            this.x11_magic_cookies.remove(hexFakeCookie);
        }
        if (!killChannels) {
            return;
        }
        if (log.isEnabled()) {
            log.log(50, "Closing all X11 channels for the given fake cookie");
        }
        Vector vector = this.channels;
        synchronized (vector) {
            channel_copy = (Vector)this.channels.clone();
        }
        for (int i = 0; i < channel_copy.size(); ++i) {
            Channel c;
            Channel channel = c = (Channel)channel_copy.elementAt(i);
            synchronized (channel) {
                if (!hexFakeCookie.equals(c.hexX11FakeCookie)) {
                    continue;
                }
            }
            try {
                this.closeChannel(c, "Closing X11 channel since the corresponding session is closing", true);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X11ServerData checkX11Cookie(String hexFakeCookie) {
        HashMap hashMap = this.x11_magic_cookies;
        synchronized (hashMap) {
            if (hexFakeCookie != null) {
                return (X11ServerData)this.x11_magic_cookies.get(hexFakeCookie);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllChannels() {
        Vector channel_copy;
        if (log.isEnabled()) {
            log.log(50, "Closing all channels");
        }
        Vector vector = this.channels;
        synchronized (vector) {
            channel_copy = (Vector)this.channels.clone();
        }
        for (int i = 0; i < channel_copy.size(); ++i) {
            Channel c = (Channel)channel_copy.elementAt(i);
            try {
                this.closeChannel(c, "Closing all channels", true);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(Channel c, String reason, boolean force) throws IOException {
        byte[] msg = new byte[5];
        Object object = c;
        synchronized (object) {
            if (force) {
                c.state = 4;
                c.EOF = true;
            }
            c.setReasonClosed(reason);
            msg[0] = 97;
            msg[1] = (byte)(c.remoteID >> 24);
            msg[2] = (byte)(c.remoteID >> 16);
            msg[3] = (byte)(c.remoteID >> 8);
            msg[4] = (byte)c.remoteID;
            c.notifyAll();
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                return;
            }
            this.tm.sendMessage(msg);
            c.closeMessageSent = true;
        }
        if (log.isEnabled()) {
            log.log(50, "Sent SSH_MSG_CHANNEL_CLOSE (channel " + c.localID + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEOF(Channel c) throws IOException {
        byte[] msg = new byte[5];
        Object object = c;
        synchronized (object) {
            if (c.state != 2) {
                return;
            }
            msg[0] = 96;
            msg[1] = (byte)(c.remoteID >> 24);
            msg[2] = (byte)(c.remoteID >> 16);
            msg[3] = (byte)(c.remoteID >> 8);
            msg[4] = (byte)c.remoteID;
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                return;
            }
            this.tm.sendMessage(msg);
        }
        if (log.isEnabled()) {
            log.log(50, "Sent EOF (Channel " + c.localID + "/" + c.remoteID + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendOpenConfirmation(Channel c) throws IOException {
        PacketChannelOpenConfirmation pcoc = null;
        Object object = c;
        synchronized (object) {
            if (c.state != 1) {
                return;
            }
            c.state = 2;
            pcoc = new PacketChannelOpenConfirmation(c.remoteID, c.localID, c.localWindow, c.localMaxPacketSize);
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                return;
            }
            this.tm.sendMessage(pcoc.getPayload());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData(Channel c, byte[] buffer, int pos, int len) throws IOException {
        while (len > 0) {
            byte[] msg;
            int thislen = 0;
            Object object = c;
            synchronized (object) {
                while (true) {
                    if (c.state == 4) {
                        throw new IOException("SSH channel is closed. (" + c.getReasonClosed() + ")");
                    }
                    if (c.state != 2) {
                        throw new IOException("SSH channel in strange state. (" + c.state + ")");
                    }
                    if (c.remoteWindow != 0L) break;
                    try {
                        c.wait();
                    }
                    catch (InterruptedException ignore) {
                        throw new InterruptedIOException();
                    }
                }
                thislen = c.remoteWindow >= (long)len ? len : (int)c.remoteWindow;
                int estimatedMaxDataLen = c.remoteMaxPacketSize - (this.tm.getPacketOverheadEstimate() + 9);
                if (estimatedMaxDataLen <= 0) {
                    estimatedMaxDataLen = 1;
                }
                if (thislen > estimatedMaxDataLen) {
                    thislen = estimatedMaxDataLen;
                }
                c.remoteWindow -= (long)thislen;
                msg = new byte[9 + thislen];
                msg[0] = 94;
                msg[1] = (byte)(c.remoteID >> 24);
                msg[2] = (byte)(c.remoteID >> 16);
                msg[3] = (byte)(c.remoteID >> 8);
                msg[4] = (byte)c.remoteID;
                msg[5] = (byte)(thislen >> 24);
                msg[6] = (byte)(thislen >> 16);
                msg[7] = (byte)(thislen >> 8);
                msg[8] = (byte)thislen;
                System.arraycopy(buffer, pos, msg, 9, thislen);
            }
            object = c.channelSendLock;
            synchronized (object) {
                if (c.closeMessageSent) {
                    throw new IOException("SSH channel is closed. (" + c.getReasonClosed() + ")");
                }
                this.tm.sendMessage(msg);
            }
            pos += thislen;
            len -= thislen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestGlobalForward(String bindAddress, int bindPort, String targetAddress, int targetPort) throws IOException {
        RemoteForwardingData rfd = new RemoteForwardingData();
        rfd.bindAddress = bindAddress;
        rfd.bindPort = bindPort;
        rfd.targetAddress = targetAddress;
        rfd.targetPort = targetPort;
        Cloneable cloneable = this.remoteForwardings;
        synchronized (cloneable) {
            Integer key = new Integer(bindPort);
            if (this.remoteForwardings.get(key) != null) {
                throw new IOException("There is already a forwarding for remote port " + bindPort);
            }
            this.remoteForwardings.put(key, rfd);
        }
        cloneable = this.channels;
        synchronized (cloneable) {
            this.globalFailedCounter = 0;
            this.globalSuccessCounter = 0;
        }
        PacketGlobalForwardRequest pgf = new PacketGlobalForwardRequest(true, bindAddress, bindPort);
        this.tm.sendMessage(pgf.getPayload());
        if (log.isEnabled()) {
            log.log(50, "Requesting a remote forwarding ('" + bindAddress + "', " + bindPort + ")");
        }
        try {
            if (!this.waitForGlobalRequestResult()) {
                throw new IOException("The server denied the request (did you enable port forwarding?)");
            }
        }
        catch (IOException e) {
            HashMap hashMap = this.remoteForwardings;
            synchronized (hashMap) {
                this.remoteForwardings.remove(rfd);
            }
            throw e;
        }
        return bindPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCancelGlobalForward(int bindPort) throws IOException {
        RemoteForwardingData rfd = null;
        Cloneable cloneable = this.remoteForwardings;
        synchronized (cloneable) {
            rfd = (RemoteForwardingData)this.remoteForwardings.get(new Integer(bindPort));
            if (rfd == null) {
                throw new IOException("Sorry, there is no known remote forwarding for remote port " + bindPort);
            }
        }
        cloneable = this.channels;
        synchronized (cloneable) {
            this.globalFailedCounter = 0;
            this.globalSuccessCounter = 0;
        }
        PacketGlobalCancelForwardRequest pgcf = new PacketGlobalCancelForwardRequest(true, rfd.bindAddress, rfd.bindPort);
        this.tm.sendMessage(pgcf.getPayload());
        if (log.isEnabled()) {
            log.log(50, "Requesting cancelation of remote forward ('" + rfd.bindAddress + "', " + rfd.bindPort + ")");
        }
        try {
            if (!this.waitForGlobalRequestResult()) {
                throw new IOException("The server denied the request.");
            }
        }
        finally {
            HashMap hashMap = this.remoteForwardings;
            synchronized (hashMap) {
                this.remoteForwardings.remove(rfd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerThread(IChannelWorkerThread thr) throws IOException {
        Vector vector = this.listenerThreads;
        synchronized (vector) {
            if (!this.listenerThreadsAllowed) {
                throw new IOException("Too late, this connection is closed.");
            }
            this.listenerThreads.addElement(thr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel openDirectTCPIPChannel(String host_to_connect, int port_to_connect, String originator_IP_address, int originator_port) throws IOException {
        Channel c;
        Channel channel = c = new Channel(this);
        synchronized (channel) {
            c.localID = this.addChannel(c);
        }
        PacketOpenDirectTCPIPChannel dtc = new PacketOpenDirectTCPIPChannel(c.localID, c.localWindow, c.localMaxPacketSize, host_to_connect, port_to_connect, originator_IP_address, originator_port);
        this.tm.sendMessage(dtc.getPayload());
        this.waitUntilChannelOpen(c);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel openSessionChannel() throws IOException {
        Channel c;
        Channel channel = c = new Channel(this);
        synchronized (channel) {
            c.localID = this.addChannel(c);
        }
        if (log.isEnabled()) {
            log.log(50, "Sending SSH_MSG_CHANNEL_OPEN (Channel " + c.localID + ")");
        }
        PacketOpenSessionChannel smo = new PacketOpenSessionChannel(c.localID, c.localWindow, c.localMaxPacketSize);
        this.tm.sendMessage(smo.getPayload());
        this.waitUntilChannelOpen(c);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestGlobalTrileadPing() throws IOException {
        Vector vector = this.channels;
        synchronized (vector) {
            this.globalFailedCounter = 0;
            this.globalSuccessCounter = 0;
        }
        PacketGlobalTrileadPing pgtp = new PacketGlobalTrileadPing();
        this.tm.sendMessage(pgtp.getPayload());
        if (log.isEnabled()) {
            log.log(50, "Sending SSH_MSG_GLOBAL_REQUEST 'trilead-ping'.");
        }
        try {
            if (this.waitForGlobalRequestResult()) {
                throw new IOException("Your server is alive - but buggy. It replied with SSH_MSG_REQUEST_SUCCESS when it actually should not.");
            }
        }
        catch (IOException e) {
            throw (IOException)new IOException("The ping request failed.").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestChannelTrileadPing(Channel c) throws IOException {
        PacketChannelTrileadPing pctp;
        Object object = c;
        synchronized (object) {
            if (c.state != 2) {
                throw new IOException("Cannot ping this channel (" + c.getReasonClosed() + ")");
            }
            pctp = new PacketChannelTrileadPing(c.remoteID);
            c.failedCounter = 0;
            c.successCounter = 0;
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                throw new IOException("Cannot ping this channel (" + c.getReasonClosed() + ")");
            }
            this.tm.sendMessage(pctp.getPayload());
        }
        try {
            if (this.waitForChannelRequestResult(c)) {
                throw new IOException("Your server is alive - but buggy. It replied with SSH_MSG_SESSION_SUCCESS when it actually should not.");
            }
        }
        catch (IOException e) {
            throw (IOException)new IOException("The ping request failed.").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPTY(Channel c, String term, int term_width_characters, int term_height_characters, int term_width_pixels, int term_height_pixels, byte[] terminal_modes) throws IOException {
        PacketSessionPtyRequest spr;
        Object object = c;
        synchronized (object) {
            if (c.state != 2) {
                throw new IOException("Cannot request PTY on this channel (" + c.getReasonClosed() + ")");
            }
            spr = new PacketSessionPtyRequest(c.remoteID, true, term, term_width_characters, term_height_characters, term_width_pixels, term_height_pixels, terminal_modes);
            c.failedCounter = 0;
            c.successCounter = 0;
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                throw new IOException("Cannot request PTY on this channel (" + c.getReasonClosed() + ")");
            }
            this.tm.sendMessage(spr.getPayload());
        }
        try {
            if (!this.waitForChannelRequestResult(c)) {
                throw new IOException("The server denied the request.");
            }
        }
        catch (IOException e) {
            throw (IOException)new IOException("PTY request failed").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestX11(Channel c, boolean singleConnection, String x11AuthenticationProtocol, String x11AuthenticationCookie, int x11ScreenNumber) throws IOException {
        PacketSessionX11Request psr;
        Object object = c;
        synchronized (object) {
            if (c.state != 2) {
                throw new IOException("Cannot request X11 on this channel (" + c.getReasonClosed() + ")");
            }
            psr = new PacketSessionX11Request(c.remoteID, true, singleConnection, x11AuthenticationProtocol, x11AuthenticationCookie, x11ScreenNumber);
            c.failedCounter = 0;
            c.successCounter = 0;
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                throw new IOException("Cannot request X11 on this channel (" + c.getReasonClosed() + ")");
            }
            this.tm.sendMessage(psr.getPayload());
        }
        if (log.isEnabled()) {
            log.log(50, "Requesting X11 forwarding (Channel " + c.localID + "/" + c.remoteID + ")");
        }
        try {
            if (!this.waitForChannelRequestResult(c)) {
                throw new IOException("The server denied the request.");
            }
        }
        catch (IOException e) {
            throw (IOException)new IOException("The X11 request failed.").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestSubSystem(Channel c, String subSystemName) throws IOException {
        PacketSessionSubsystemRequest ssr;
        Object object = c;
        synchronized (object) {
            if (c.state != 2) {
                throw new IOException("Cannot request subsystem on this channel (" + c.getReasonClosed() + ")");
            }
            ssr = new PacketSessionSubsystemRequest(c.remoteID, true, subSystemName);
            c.failedCounter = 0;
            c.successCounter = 0;
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                throw new IOException("Cannot request subsystem on this channel (" + c.getReasonClosed() + ")");
            }
            this.tm.sendMessage(ssr.getPayload());
        }
        try {
            if (!this.waitForChannelRequestResult(c)) {
                throw new IOException("The server denied the request.");
            }
        }
        catch (IOException e) {
            throw (IOException)new IOException("The subsystem request failed.").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestExecCommand(Channel c, String cmd) throws IOException {
        PacketSessionExecCommand sm;
        Object object = c;
        synchronized (object) {
            if (c.state != 2) {
                throw new IOException("Cannot execute command on this channel (" + c.getReasonClosed() + ")");
            }
            sm = new PacketSessionExecCommand(c.remoteID, true, cmd);
            c.failedCounter = 0;
            c.successCounter = 0;
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                throw new IOException("Cannot execute command on this channel (" + c.getReasonClosed() + ")");
            }
            this.tm.sendMessage(sm.getPayload());
        }
        if (log.isEnabled()) {
            log.log(50, "Executing command (channel " + c.localID + ", '" + cmd + "')");
        }
        try {
            if (!this.waitForChannelRequestResult(c)) {
                throw new IOException("The server denied the request.");
            }
        }
        catch (IOException e) {
            throw (IOException)new IOException("The execute request failed.").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestShell(Channel c) throws IOException {
        PacketSessionStartShell sm;
        Object object = c;
        synchronized (object) {
            if (c.state != 2) {
                throw new IOException("Cannot start shell on this channel (" + c.getReasonClosed() + ")");
            }
            sm = new PacketSessionStartShell(c.remoteID, true);
            c.failedCounter = 0;
            c.successCounter = 0;
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                throw new IOException("Cannot start shell on this channel (" + c.getReasonClosed() + ")");
            }
            this.tm.sendMessage(sm.getPayload());
        }
        try {
            if (!this.waitForChannelRequestResult(c)) {
                throw new IOException("The server denied the request.");
            }
        }
        catch (IOException e) {
            throw (IOException)new IOException("The shell request failed.").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelExtendedData(byte[] msg, int msglen) throws IOException {
        if (msglen <= 13) {
            throw new IOException("SSH_MSG_CHANNEL_EXTENDED_DATA message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        int dataType = (msg[5] & 0xFF) << 24 | (msg[6] & 0xFF) << 16 | (msg[7] & 0xFF) << 8 | msg[8] & 0xFF;
        int len = (msg[9] & 0xFF) << 24 | (msg[10] & 0xFF) << 16 | (msg[11] & 0xFF) << 8 | msg[12] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_EXTENDED_DATA message for non-existent channel " + id);
        }
        if (dataType != 1) {
            throw new IOException("SSH_MSG_CHANNEL_EXTENDED_DATA message has unknown type (" + dataType + ")");
        }
        if (len != msglen - 13) {
            throw new IOException("SSH_MSG_CHANNEL_EXTENDED_DATA message has wrong len (calculated " + (msglen - 13) + ", got " + len + ")");
        }
        if (log.isEnabled()) {
            log.log(80, "Got SSH_MSG_CHANNEL_EXTENDED_DATA (channel " + id + ", " + len + ")");
        }
        Channel channel = c;
        synchronized (channel) {
            if (c.state == 4) {
                return;
            }
            if (c.state != 2) {
                throw new IOException("Got SSH_MSG_CHANNEL_EXTENDED_DATA, but channel is not in correct state (" + c.state + ")");
            }
            if (c.localWindow < len) {
                throw new IOException("Remote sent too much data, does not fit into window.");
            }
            c.localWindow -= len;
            System.arraycopy(msg, 13, c.stderrBuffer, c.stderrWritepos, len);
            c.stderrWritepos += len;
            c.notifyAll();
        }
    }

    public int waitForCondition(Channel c, long timeout, int condition_mask) {
        long end_time = 0L;
        boolean end_time_set = false;
        Channel channel = c;
        synchronized (channel) {
            block5: while (true) {
                while (true) {
                    int current_cond = 0;
                    int stdoutAvail = c.stdoutWritepos - c.stdoutReadpos;
                    int stderrAvail = c.stderrWritepos - c.stderrReadpos;
                    if (stdoutAvail > 0) {
                        current_cond |= 4;
                    }
                    if (stderrAvail > 0) {
                        current_cond |= 8;
                    }
                    if (c.EOF) {
                        current_cond |= 0x10;
                    }
                    if (c.getExitStatus() != null) {
                        current_cond |= 0x20;
                    }
                    if (c.getExitSignal() != null) {
                        current_cond |= 0x40;
                    }
                    if (c.state == 4) {
                        return current_cond | 2 | 0x10;
                    }
                    if ((current_cond & condition_mask) != 0) {
                        return current_cond;
                    }
                    if (timeout > 0L) {
                        if (!end_time_set) {
                            end_time = System.currentTimeMillis() + timeout;
                            end_time_set = true;
                        } else {
                            timeout = end_time - System.currentTimeMillis();
                            if (timeout <= 0L) {
                                return current_cond | 1;
                            }
                        }
                    }
                    try {
                        if (timeout > 0L) {
                            c.wait(timeout);
                            continue block5;
                        }
                        c.wait();
                        continue block5;
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailable(Channel c, boolean extended) throws IOException {
        Channel channel = c;
        synchronized (channel) {
            int avail = extended ? c.stderrWritepos - c.stderrReadpos : c.stdoutWritepos - c.stdoutReadpos;
            return avail > 0 ? avail : (c.EOF ? -1 : 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChannelData(Channel c, boolean extended, byte[] target, int off, int len) throws IOException {
        int copylen = 0;
        int increment = 0;
        int remoteID = 0;
        int localID = 0;
        Object object = c;
        synchronized (object) {
            int stdoutAvail = 0;
            int stderrAvail = 0;
            while (true) {
                stdoutAvail = c.stdoutWritepos - c.stdoutReadpos;
                stderrAvail = c.stderrWritepos - c.stderrReadpos;
                if (!extended && stdoutAvail != 0 || extended && stderrAvail != 0) break;
                if (c.EOF || c.state != 2) {
                    return -1;
                }
                try {
                    c.wait();
                }
                catch (InterruptedException ignore) {
                    throw new InterruptedIOException();
                }
            }
            if (!extended) {
                copylen = stdoutAvail > len ? len : stdoutAvail;
                System.arraycopy(c.stdoutBuffer, c.stdoutReadpos, target, off, copylen);
                c.stdoutReadpos += copylen;
                if (c.stdoutReadpos != c.stdoutWritepos) {
                    System.arraycopy(c.stdoutBuffer, c.stdoutReadpos, c.stdoutBuffer, 0, c.stdoutWritepos - c.stdoutReadpos);
                }
                c.stdoutWritepos -= c.stdoutReadpos;
                c.stdoutReadpos = 0;
            } else {
                copylen = stderrAvail > len ? len : stderrAvail;
                System.arraycopy(c.stderrBuffer, c.stderrReadpos, target, off, copylen);
                c.stderrReadpos += copylen;
                if (c.stderrReadpos != c.stderrWritepos) {
                    System.arraycopy(c.stderrBuffer, c.stderrReadpos, c.stderrBuffer, 0, c.stderrWritepos - c.stderrReadpos);
                }
                c.stderrWritepos -= c.stderrReadpos;
                c.stderrReadpos = 0;
            }
            if (c.state != 2) {
                return copylen;
            }
            if (c.localWindow < 0x100000) {
                int minFreeSpace = Math.min(0x200000 - c.stdoutWritepos, 0x200000 - c.stderrWritepos);
                increment = minFreeSpace - c.localWindow;
                c.localWindow = minFreeSpace;
            }
            remoteID = c.remoteID;
            localID = c.localID;
        }
        if (increment > 0) {
            if (log.isEnabled()) {
                log.log(80, "Sending SSH_MSG_CHANNEL_WINDOW_ADJUST (channel " + localID + ", " + increment + ")");
            }
            object = c.channelSendLock;
            synchronized (object) {
                byte[] msg = c.msgWindowAdjust;
                msg[0] = 93;
                msg[1] = (byte)(remoteID >> 24);
                msg[2] = (byte)(remoteID >> 16);
                msg[3] = (byte)(remoteID >> 8);
                msg[4] = (byte)remoteID;
                msg[5] = (byte)(increment >> 24);
                msg[6] = (byte)(increment >> 16);
                msg[7] = (byte)(increment >> 8);
                msg[8] = (byte)increment;
                if (!c.closeMessageSent) {
                    this.tm.sendMessage(msg);
                }
            }
        }
        return copylen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelData(byte[] msg, int msglen) throws IOException {
        if (msglen <= 9) {
            throw new IOException("SSH_MSG_CHANNEL_DATA message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        int len = (msg[5] & 0xFF) << 24 | (msg[6] & 0xFF) << 16 | (msg[7] & 0xFF) << 8 | msg[8] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_DATA message for non-existent channel " + id);
        }
        if (len != msglen - 9) {
            throw new IOException("SSH_MSG_CHANNEL_DATA message has wrong len (calculated " + (msglen - 9) + ", got " + len + ")");
        }
        if (log.isEnabled()) {
            log.log(80, "Got SSH_MSG_CHANNEL_DATA (channel " + id + ", " + len + ")");
        }
        Channel channel = c;
        synchronized (channel) {
            if (c.state == 4) {
                return;
            }
            if (c.state != 2) {
                throw new IOException("Got SSH_MSG_CHANNEL_DATA, but channel is not in correct state (" + c.state + ")");
            }
            if (c.localWindow < len) {
                throw new IOException("Remote sent too much data, does not fit into window.");
            }
            c.localWindow -= len;
            System.arraycopy(msg, 9, c.stdoutBuffer, c.stdoutWritepos, len);
            c.stdoutWritepos += len;
            c.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelWindowAdjust(byte[] msg, int msglen) throws IOException {
        if (msglen != 9) {
            throw new IOException("SSH_MSG_CHANNEL_WINDOW_ADJUST message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        int windowChange = (msg[5] & 0xFF) << 24 | (msg[6] & 0xFF) << 16 | (msg[7] & 0xFF) << 8 | msg[8] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_WINDOW_ADJUST message for non-existent channel " + id);
        }
        Channel channel = c;
        synchronized (channel) {
            long huge = 0xFFFFFFFFL;
            c.remoteWindow += (long)windowChange & 0xFFFFFFFFL;
            if (c.remoteWindow > 0xFFFFFFFFL) {
                c.remoteWindow = 0xFFFFFFFFL;
            }
            c.notifyAll();
        }
        if (log.isEnabled()) {
            log.log(80, "Got SSH_MSG_CHANNEL_WINDOW_ADJUST (channel " + id + ", " + windowChange + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelOpen(byte[] msg, int msglen) throws IOException {
        TypesReader tr = new TypesReader(msg, 0, msglen);
        tr.readByte();
        String channelType = tr.readString();
        int remoteID = tr.readUINT32();
        int remoteWindow = tr.readUINT32();
        int remoteMaxPacketSize = tr.readUINT32();
        if ("x11".equals(channelType)) {
            Channel c;
            HashMap hashMap = this.x11_magic_cookies;
            synchronized (hashMap) {
                if (this.x11_magic_cookies.size() == 0) {
                    PacketChannelOpenFailure pcof = new PacketChannelOpenFailure(remoteID, 1, "X11 forwarding not activated", "");
                    this.tm.sendAsynchronousMessage(pcof.getPayload());
                    if (log.isEnabled()) {
                        log.log(20, "Unexpected X11 request, denying it!");
                    }
                    return;
                }
            }
            String remoteOriginatorAddress = tr.readString();
            int remoteOriginatorPort = tr.readUINT32();
            Channel channel = c = new Channel(this);
            synchronized (channel) {
                c.remoteID = remoteID;
                c.remoteWindow = (long)remoteWindow & 0xFFFFFFFFL;
                c.remoteMaxPacketSize = remoteMaxPacketSize;
                c.localID = this.addChannel(c);
            }
            RemoteX11AcceptThread rxat = new RemoteX11AcceptThread(c, remoteOriginatorAddress, remoteOriginatorPort);
            rxat.setDaemon(true);
            rxat.start();
            return;
        }
        if ("forwarded-tcpip".equals(channelType)) {
            Channel c;
            String remoteConnectedAddress = tr.readString();
            int remoteConnectedPort = tr.readUINT32();
            String remoteOriginatorAddress = tr.readString();
            int remoteOriginatorPort = tr.readUINT32();
            RemoteForwardingData rfd = null;
            HashMap hashMap = this.remoteForwardings;
            synchronized (hashMap) {
                rfd = (RemoteForwardingData)this.remoteForwardings.get(new Integer(remoteConnectedPort));
            }
            if (rfd == null) {
                PacketChannelOpenFailure pcof = new PacketChannelOpenFailure(remoteID, 1, "No thanks, unknown port in forwarded-tcpip request", "");
                this.tm.sendAsynchronousMessage(pcof.getPayload());
                if (log.isEnabled()) {
                    log.log(20, "Unexpected forwarded-tcpip request, denying it!");
                }
                return;
            }
            Channel channel = c = new Channel(this);
            synchronized (channel) {
                c.remoteID = remoteID;
                c.remoteWindow = (long)remoteWindow & 0xFFFFFFFFL;
                c.remoteMaxPacketSize = remoteMaxPacketSize;
                c.localID = this.addChannel(c);
            }
            RemoteAcceptThread rat = new RemoteAcceptThread(c, remoteConnectedAddress, remoteConnectedPort, remoteOriginatorAddress, remoteOriginatorPort, rfd.targetAddress, rfd.targetPort);
            rat.setDaemon(true);
            rat.start();
            return;
        }
        PacketChannelOpenFailure pcof = new PacketChannelOpenFailure(remoteID, 3, "Unknown channel type", "");
        this.tm.sendAsynchronousMessage(pcof.getPayload());
        if (log.isEnabled()) {
            log.log(20, "The peer tried to open an unsupported channel type (" + channelType + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelRequest(byte[] msg, int msglen) throws IOException {
        TypesReader tr = new TypesReader(msg, 0, msglen);
        tr.readByte();
        int id = tr.readUINT32();
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_REQUEST message for non-existent channel " + id);
        }
        String type = tr.readString("US-ASCII");
        boolean wantReply = tr.readBoolean();
        if (log.isEnabled()) {
            log.log(80, "Got SSH_MSG_CHANNEL_REQUEST (channel " + id + ", '" + type + "')");
        }
        if (type.equals("exit-status")) {
            if (wantReply) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message, 'want reply' is true");
            }
            int exit_status = tr.readUINT32();
            if (tr.remain() != 0) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message");
            }
            Channel channel = c;
            synchronized (channel) {
                c.exit_status = new Integer(exit_status);
                c.notifyAll();
            }
            if (log.isEnabled()) {
                log.log(50, "Got EXIT STATUS (channel " + id + ", status " + exit_status + ")");
            }
            return;
        }
        if (type.equals("exit-signal")) {
            if (wantReply) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message, 'want reply' is true");
            }
            String signame = tr.readString("US-ASCII");
            tr.readBoolean();
            tr.readString();
            tr.readString();
            if (tr.remain() != 0) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message");
            }
            Channel channel = c;
            synchronized (channel) {
                c.exit_signal = signame;
                c.notifyAll();
            }
            if (log.isEnabled()) {
                log.log(50, "Got EXIT SIGNAL (channel " + id + ", signal " + signame + ")");
            }
            return;
        }
        if (wantReply) {
            byte[] reply = new byte[]{100, (byte)(c.remoteID >> 24), (byte)(c.remoteID >> 16), (byte)(c.remoteID >> 8), (byte)c.remoteID};
            this.tm.sendAsynchronousMessage(reply);
        }
        if (log.isEnabled()) {
            log.log(50, "Channel request '" + type + "' is not known, ignoring it");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelEOF(byte[] msg, int msglen) throws IOException {
        if (msglen != 5) {
            throw new IOException("SSH_MSG_CHANNEL_EOF message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_EOF message for non-existent channel " + id);
        }
        Channel channel = c;
        synchronized (channel) {
            c.EOF = true;
            c.notifyAll();
        }
        if (log.isEnabled()) {
            log.log(50, "Got SSH_MSG_CHANNEL_EOF (channel " + id + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelClose(byte[] msg, int msglen) throws IOException {
        if (msglen != 5) {
            throw new IOException("SSH_MSG_CHANNEL_CLOSE message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_CLOSE message for non-existent channel " + id);
        }
        Channel channel = c;
        synchronized (channel) {
            c.EOF = true;
            c.state = 4;
            c.setReasonClosed("Close requested by remote");
            c.closeMessageRecv = true;
            this.removeChannel(c.localID);
            c.notifyAll();
        }
        if (log.isEnabled()) {
            log.log(50, "Got SSH_MSG_CHANNEL_CLOSE (channel " + id + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelSuccess(byte[] msg, int msglen) throws IOException {
        if (msglen != 5) {
            throw new IOException("SSH_MSG_CHANNEL_SUCCESS message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_SUCCESS message for non-existent channel " + id);
        }
        Channel channel = c;
        synchronized (channel) {
            ++c.successCounter;
            c.notifyAll();
        }
        if (log.isEnabled()) {
            log.log(80, "Got SSH_MSG_CHANNEL_SUCCESS (channel " + id + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelFailure(byte[] msg, int msglen) throws IOException {
        if (msglen != 5) {
            throw new IOException("SSH_MSG_CHANNEL_FAILURE message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_FAILURE message for non-existent channel " + id);
        }
        Channel channel = c;
        synchronized (channel) {
            ++c.failedCounter;
            c.notifyAll();
        }
        if (log.isEnabled()) {
            log.log(50, "Got SSH_MSG_CHANNEL_FAILURE (channel " + id + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelOpenConfirmation(byte[] msg, int msglen) throws IOException {
        PacketChannelOpenConfirmation sm = new PacketChannelOpenConfirmation(msg, 0, msglen);
        Channel c = this.getChannel(sm.recipientChannelID);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_OPEN_CONFIRMATION message for non-existent channel " + sm.recipientChannelID);
        }
        Channel channel = c;
        synchronized (channel) {
            if (c.state != 1) {
                throw new IOException("Unexpected SSH_MSG_CHANNEL_OPEN_CONFIRMATION message for channel " + sm.recipientChannelID);
            }
            c.remoteID = sm.senderChannelID;
            c.remoteWindow = (long)sm.initialWindowSize & 0xFFFFFFFFL;
            c.remoteMaxPacketSize = sm.maxPacketSize;
            c.state = 2;
            c.notifyAll();
        }
        if (log.isEnabled()) {
            log.log(50, "Got SSH_MSG_CHANNEL_OPEN_CONFIRMATION (channel " + sm.recipientChannelID + " / remote: " + sm.senderChannelID + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelOpenFailure(byte[] msg, int msglen) throws IOException {
        if (msglen < 5) {
            throw new IOException("SSH_MSG_CHANNEL_OPEN_FAILURE message has wrong size (" + msglen + ")");
        }
        TypesReader tr = new TypesReader(msg, 0, msglen);
        tr.readByte();
        int id = tr.readUINT32();
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_OPEN_FAILURE message for non-existent channel " + id);
        }
        int reasonCode = tr.readUINT32();
        String description = tr.readString("UTF-8");
        String reasonCodeSymbolicName = null;
        switch (reasonCode) {
            case 1: {
                reasonCodeSymbolicName = "SSH_OPEN_ADMINISTRATIVELY_PROHIBITED";
                break;
            }
            case 2: {
                reasonCodeSymbolicName = "SSH_OPEN_CONNECT_FAILED";
                break;
            }
            case 3: {
                reasonCodeSymbolicName = "SSH_OPEN_UNKNOWN_CHANNEL_TYPE";
                break;
            }
            case 4: {
                reasonCodeSymbolicName = "SSH_OPEN_RESOURCE_SHORTAGE";
                break;
            }
            default: {
                reasonCodeSymbolicName = "UNKNOWN REASON CODE (" + reasonCode + ")";
            }
        }
        StringBuffer descriptionBuffer = new StringBuffer();
        descriptionBuffer.append(description);
        for (int i = 0; i < descriptionBuffer.length(); ++i) {
            char cc = descriptionBuffer.charAt(i);
            if (cc >= ' ' && cc <= '~') continue;
            descriptionBuffer.setCharAt(i, '\ufffd');
        }
        Channel channel = c;
        synchronized (channel) {
            c.EOF = true;
            c.state = 4;
            c.setReasonClosed("The server refused to open the channel (" + reasonCodeSymbolicName + ", '" + descriptionBuffer.toString() + "')");
            c.notifyAll();
        }
        if (log.isEnabled()) {
            log.log(50, "Got SSH_MSG_CHANNEL_OPEN_FAILURE (channel " + id + ")");
        }
    }

    public void msgGlobalRequest(byte[] msg, int msglen) throws IOException {
        TypesReader tr = new TypesReader(msg, 0, msglen);
        tr.readByte();
        String requestName = tr.readString();
        boolean wantReply = tr.readBoolean();
        if (wantReply) {
            byte[] reply_failure = new byte[]{82};
            this.tm.sendAsynchronousMessage(reply_failure);
        }
        if (log.isEnabled()) {
            log.log(80, "Got SSH_MSG_GLOBAL_REQUEST (" + requestName + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgGlobalSuccess() throws IOException {
        Vector vector = this.channels;
        synchronized (vector) {
            ++this.globalSuccessCounter;
            this.channels.notifyAll();
        }
        if (log.isEnabled()) {
            log.log(80, "Got SSH_MSG_REQUEST_SUCCESS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgGlobalFailure() throws IOException {
        Vector vector = this.channels;
        synchronized (vector) {
            ++this.globalFailedCounter;
            this.channels.notifyAll();
        }
        if (log.isEnabled()) {
            log.log(80, "Got SSH_MSG_REQUEST_FAILURE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(byte[] msg, int msglen) throws IOException {
        if (msg == null) {
            int i;
            if (log.isEnabled()) {
                log.log(50, "HandleMessage: got shutdown");
            }
            Vector vector = this.listenerThreads;
            synchronized (vector) {
                for (i = 0; i < this.listenerThreads.size(); ++i) {
                    IChannelWorkerThread lat = (IChannelWorkerThread)this.listenerThreads.elementAt(i);
                    lat.stopWorking();
                }
                this.listenerThreadsAllowed = false;
            }
            vector = this.channels;
            synchronized (vector) {
                this.shutdown = true;
                for (i = 0; i < this.channels.size(); ++i) {
                    Channel c;
                    Channel channel = c = (Channel)this.channels.elementAt(i);
                    synchronized (channel) {
                        c.EOF = true;
                        c.state = 4;
                        c.setReasonClosed("The connection is being shutdown");
                        c.closeMessageRecv = true;
                        c.notifyAll();
                        continue;
                    }
                }
                this.channels.setSize(0);
                this.channels.trimToSize();
                this.channels.notifyAll();
                return;
            }
        }
        switch (msg[0]) {
            case 91: {
                this.msgChannelOpenConfirmation(msg, msglen);
                break;
            }
            case 93: {
                this.msgChannelWindowAdjust(msg, msglen);
                break;
            }
            case 94: {
                this.msgChannelData(msg, msglen);
                break;
            }
            case 95: {
                this.msgChannelExtendedData(msg, msglen);
                break;
            }
            case 98: {
                this.msgChannelRequest(msg, msglen);
                break;
            }
            case 96: {
                this.msgChannelEOF(msg, msglen);
                break;
            }
            case 90: {
                this.msgChannelOpen(msg, msglen);
                break;
            }
            case 97: {
                this.msgChannelClose(msg, msglen);
                break;
            }
            case 99: {
                this.msgChannelSuccess(msg, msglen);
                break;
            }
            case 100: {
                this.msgChannelFailure(msg, msglen);
                break;
            }
            case 92: {
                this.msgChannelOpenFailure(msg, msglen);
                break;
            }
            case 80: {
                this.msgGlobalRequest(msg, msglen);
                break;
            }
            case 81: {
                this.msgGlobalSuccess();
                break;
            }
            case 82: {
                this.msgGlobalFailure();
                break;
            }
            default: {
                throw new IOException("Cannot handle unknown channel message " + (msg[0] & 0xFF));
            }
        }
    }
}

